/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.initialization.TownyInitException;
import com.palmergames.util.FileMgmt;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.plugin.Plugin;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class TranslationLoader {
    private final Path langFolderPath;
    private final Plugin plugin;
    private final Class<?> clazz;
    private boolean updateReferenceFiles = true;
    private Map<String, Map<String, String>> newTranslations = new HashMap<String, Map<String, String>>();

    public TranslationLoader(Path langFolderPath, Plugin plugin, Class<?> clazz) {
        this.langFolderPath = langFolderPath;
        this.plugin = plugin;
        this.clazz = clazz;
    }

    public TranslationLoader(Plugin plugin) {
        this.langFolderPath = Paths.get(plugin.getDataFolder().getPath(), new String[0]).resolve("lang");
        this.plugin = plugin;
        this.clazz = plugin.getClass();
    }

    public void load() {
        this.newTranslations = new HashMap<String, Map<String, String>>();
        this.loadTranslationsIntoMemory();
        this.loadOverrideFiles();
        this.loadGlobalFile();
        this.plugin.getLogger().info(String.format("Successfully loaded translations for %d languages.", this.newTranslations.keySet().size()));
    }

    public Map<String, Map<String, String>> getTranslations() {
        return this.newTranslations;
    }

    void setTranslations(Map<String, Map<String, String>> translations) {
        this.newTranslations = translations;
    }

    void loadTranslationsIntoMemory() {
        String defaultLangContent;
        block32: {
            try {
                Files.createDirectories(this.langFolderPath.resolve("reference"), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new TownyInitException("Failed to create language reference folder.", TownyInitException.TownyError.LOCALIZATION, e);
            }
            defaultLangContent = null;
            if (this.updateReferenceFiles) {
                try (InputStream is = this.clazz.getResourceAsStream("/lang/en-US.yml");){
                    if (is == null) break block32;
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                        defaultLangContent = reader.lines().collect(Collectors.joining("\n"));
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        for (String lang : this.getLangFileNamesFromPlugin()) {
            try {
                InputStream is = this.clazz.getResourceAsStream("/lang/" + lang + ".yml");
                try {
                    if (is == null) {
                        throw new TownyInitException("Could not find '/lang/" + lang + ".yml' in the JAR", TownyInitException.TownyError.LOCALIZATION);
                    }
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                        String content = reader.lines().collect(Collectors.joining("\n"));
                        Map values = (Map)new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions())).load(content);
                        if (this.updateReferenceFiles) {
                            this.saveReferenceFile(lang, defaultLangContent, content, values);
                        }
                        lang = lang.replace("-", "_");
                        Map translations = this.newTranslations.computeIfAbsent(lang, k -> new HashMap());
                        for (Map.Entry entry : values.entrySet()) {
                            translations.put(((String)entry.getKey()).toLowerCase(Locale.ROOT), String.valueOf(entry.getValue()));
                        }
                    }
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.WARNING, "Unabled to read yaml file: '" + lang + ".yml' from within the " + this.plugin.getName() + ".jar.", e);
            }
        }
    }

    private Set<String> getLangFileNamesFromPlugin() {
        HashSet<String> lang = new HashSet<String>();
        try {
            URL root = this.clazz.getResource("");
            if (root == null) {
                return lang;
            }
            try (FileSystem fs = FileSystems.newFileSystem(root.toURI(), Collections.emptyMap());
                 Stream<Path> stream = Files.list(fs.getRootDirectories().iterator().next().resolve("/lang"));){
                stream.map(FileMgmt::getFileName).filter(TownySettings::isLanguageEnabled).forEach(lang::add);
            }
        }
        catch (IOException | URISyntaxException e) {
            this.plugin.getLogger().log(Level.WARNING, "An exception occurred while getting language file names from the plugin jar", e);
        }
        return lang;
    }

    private void saveReferenceFile(String lang, String defaultLangContent, String content, Map<String, Object> translations) {
        Path langPath = this.langFolderPath.resolve("reference").resolve(lang + ".yml");
        try {
            if (!Files.exists(langPath, new LinkOption[0])) {
                Files.createFile(langPath, new FileAttribute[0]);
            }
            if (defaultLangContent == null || lang.equals("en-US")) {
                try (Stream<String> lines = Files.lines(langPath);){
                    if (!content.equals(lines.collect(Collectors.joining("\n")))) {
                        Files.writeString(langPath, (CharSequence)content, new OpenOption[0]);
                    }
                }
                return;
            }
            List<String> list = Arrays.asList(defaultLangContent.split("\n"));
            ListIterator<String> iterator = list.listIterator();
            while (iterator.hasNext()) {
                String key;
                Object translated;
                String line = iterator.next();
                if (!line.contains(":") || (translated = translations.get(key = line.substring(0, line.indexOf(":")))) == null) continue;
                Object replace = String.valueOf(translated);
                replace = ((String)replace).contains("'") ? "\"" + (String)replace + "\"" : "'" + (String)replace + "'";
                iterator.set(key + ": " + (String)replace);
            }
            Files.writeString(langPath, (CharSequence)String.join((CharSequence)"\n", list), new OpenOption[0]);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to copy '/lang/" + lang + ".yml' from the JAR to '" + String.valueOf(langPath.toAbsolutePath()) + "' during a reference language file update.", e);
        }
    }

    void loadOverrideFiles() {
        try {
            Path overrides = Files.createDirectories(this.langFolderPath.resolve("override"), new FileAttribute[0]);
            try (Stream<Path> overrideStream = Files.list(overrides);){
                for (Path path : overrideStream.collect(Collectors.toList())) {
                    if (!FileMgmt.getExtension(path).equalsIgnoreCase("yml")) {
                        return;
                    }
                    String fileName = FileMgmt.getFileName(path);
                    if (fileName.equals("global") || !TownySettings.isLanguageEnabled(fileName)) {
                        return;
                    }
                    InputStream is = Files.newInputStream(path, new OpenOption[0]);
                    try {
                        Map values = (Map)new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions())).load(is);
                        String lang = fileName.replaceAll("-", "_");
                        Map translations = this.newTranslations.computeIfAbsent(lang, k -> new HashMap());
                        for (Map.Entry<String, Object> entry : values.entrySet()) {
                            translations.put(((String)entry.getKey()).toLowerCase(Locale.ROOT), TranslationLoader.getTranslationValue(entry));
                        }
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new TownyInitException("Failed to read language override folder.", TownyInitException.TownyError.LOCALIZATION, e);
        }
    }

    private static String getTranslationValue(Map.Entry<String, Object> entry) {
        if (entry.getKey().toLowerCase(Locale.ROOT).startsWith("msg_ptw_warning")) {
            String msg = String.valueOf(entry.getValue());
            Towny.getPlugin().getLogger().warning("Attempted to override an protected string. Skipped " + entry.getKey());
            if (!msg.contains("Towny")) {
                return switch (entry.getKey()) {
                    case "msg_ptw_warning_1" -> "If you have paid any real-life money for these townblocks please understand: the server you play on is in violation of the Minecraft EULA and the Towny license.";
                    case "msg_ptw_warning_2" -> "The Towny team never intended for townblocks to be purchaseable with real money.";
                    case "msg_ptw_warning_3" -> "If you did pay real money you should consider playing on a Towny server that respects the wishes of the Towny Team.";
                    default -> throw new IllegalArgumentException("Unexpected value: " + entry.getKey());
                };
            }
            return msg;
        }
        return String.valueOf(entry.getValue());
    }

    void createReadmeFile() {
        try (InputStream resourceAsStream = this.clazz.getResourceAsStream("/README - Translations.txt");){
            if (resourceAsStream == null) {
                return;
            }
            Path readmePath = this.langFolderPath.resolve("README - Translations.txt");
            if (Files.exists(readmePath, new LinkOption[0])) {
                return;
            }
            if (!FileMgmt.checkOrCreateFile(readmePath.toString())) {
                throw new TownyInitException("Failed to touch '" + String.valueOf(readmePath) + "'.", TownyInitException.TownyError.LOCALIZATION);
            }
            try {
                Files.copy(resourceAsStream, readmePath, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
            }
            catch (IOException e) {
                throw new TownyInitException("Failed to copy README - Translations.txt from the JAR to '" + String.valueOf(readmePath) + "'", TownyInitException.TownyError.LOCALIZATION, e);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void loadGlobalFile() {
        try {
            Map<String, Object> globalOverrides;
            Path globalYMLPath = this.langFolderPath.resolve("override").resolve("global.yml");
            Path glitchedGlobalPath = this.langFolderPath.resolve("global.yml");
            if (Files.exists(glitchedGlobalPath, new LinkOption[0])) {
                Files.move(glitchedGlobalPath, globalYMLPath, StandardCopyOption.REPLACE_EXISTING);
            }
            if (!Files.exists(globalYMLPath, new LinkOption[0])) {
                try (InputStream resourceAsStream = this.clazz.getResourceAsStream("/global.yml");){
                    if (resourceAsStream == null) {
                        return;
                    }
                    this.createGlobalYML(globalYMLPath, resourceAsStream);
                }
            }
            if ((globalOverrides = this.loadGlobalFile(globalYMLPath)) != null) {
                this.overwriteKeysWithGlobalOverrides(globalOverrides);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void createGlobalYML(Path globalYMLPath, InputStream resource) {
        if (!FileMgmt.checkOrCreateFile(globalYMLPath.toString())) {
            throw new TownyInitException("Failed to touch '" + String.valueOf(globalYMLPath) + "'.", TownyInitException.TownyError.LOCALIZATION);
        }
        try {
            if (resource == null) {
                throw new TownyInitException("Could not find global.yml in the JAR", TownyInitException.TownyError.LOCALIZATION);
            }
            Files.copy(resource, globalYMLPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException e) {
            throw new TownyInitException("Failed to copy global.yml from the JAR to '" + String.valueOf(globalYMLPath) + "'", TownyInitException.TownyError.LOCALIZATION, e);
        }
    }

    private Map<String, Object> loadGlobalFile(Path globalYMLPath) {
        Map<String, Object> globalOverrides = new HashMap<String, Object>();
        try (InputStream is = Files.newInputStream(globalYMLPath, new OpenOption[0]);){
            globalOverrides = (Map)new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions())).load(is);
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "An exception occurred while reading the global.yml file", e);
        }
        return globalOverrides;
    }

    private void overwriteKeysWithGlobalOverrides(Map<String, Object> globalOverrides) {
        for (Map.Entry<String, Object> entry : globalOverrides.entrySet()) {
            for (String lang : this.newTranslations.keySet()) {
                this.newTranslations.get(lang).put(entry.getKey().toLowerCase(Locale.ROOT), TranslationLoader.getTranslationValue(entry));
            }
        }
    }

    public void updateReferenceFiles(boolean update) {
        this.updateReferenceFiles = update;
    }
}

