/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.util.Pair;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BoundingBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class WorldCoord
extends Coord {
    private final String worldName;
    private UUID worldUUID;
    private Reference<World> worldRef = new WeakReference<Object>(null);

    public WorldCoord(String worldName, int x, int z) {
        super(x, z);
        this.worldName = worldName;
        World world = Bukkit.getServer().getWorld(worldName);
        if (world != null) {
            this.worldUUID = world.getUID();
        }
    }

    public WorldCoord(String worldName, Coord coord) {
        this(worldName, coord.getX(), coord.getZ());
    }

    public WorldCoord(String worldName, UUID worldUUID, int x, int z) {
        super(x, z);
        this.worldName = worldName;
        this.worldUUID = worldUUID;
    }

    public WorldCoord(String worldName, UUID worldUUID, Coord coord) {
        this(worldName, worldUUID, coord.getX(), coord.getZ());
    }

    public WorldCoord(@NotNull World world, int x, int z) {
        super(x, z);
        this.worldName = world.getName();
        this.worldUUID = world.getUID();
    }

    public WorldCoord(@NotNull World world, Coord coord) {
        this(world, coord.getX(), coord.getZ());
    }

    public WorldCoord(WorldCoord worldCoord) {
        super(worldCoord);
        this.worldName = worldCoord.getWorldName();
        this.worldUUID = worldCoord.worldUUID;
        this.worldRef = new WeakReference<World>(worldCoord.worldRef.get());
    }

    public String getWorldName() {
        return this.worldName;
    }

    public Coord getCoord() {
        return new Coord(this.getX(), this.getZ());
    }

    public static WorldCoord parseWorldCoord(Entity entity) {
        return WorldCoord.parseWorldCoord(entity.getLocation());
    }

    public static WorldCoord parseWorldCoord(String worldName, int blockX, int blockZ) {
        return new WorldCoord(worldName, WorldCoord.toCell(blockX), WorldCoord.toCell(blockZ));
    }

    public static WorldCoord parseWorldCoord(Location loc) {
        World world = loc.getWorld();
        if (world == null) {
            throw new IllegalArgumentException("Provided location does not have an associated world");
        }
        return new WorldCoord(world, WorldCoord.toCell(loc.getBlockX()), WorldCoord.toCell(loc.getBlockZ()));
    }

    public static WorldCoord parseWorldCoord(Block block) {
        return new WorldCoord(block.getWorld(), WorldCoord.toCell(block.getX()), WorldCoord.toCell(block.getZ()));
    }

    @Override
    public WorldCoord add(int xOffset, int zOffset) {
        return new WorldCoord(this.getWorldName(), this.worldUUID, this.getX() + xOffset, this.getZ() + zOffset);
    }

    @Override
    public int hashCode() {
        int hash = 17;
        hash = hash * 27 + this.worldName.hashCode();
        hash = hash * 27 + this.getX();
        hash = hash * 27 + this.getZ();
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Coord)) {
            return false;
        }
        if (!(obj instanceof WorldCoord)) {
            Coord that = (Coord)obj;
            return this.getX() == that.getZ() && this.getZ() == that.getZ();
        }
        WorldCoord that = (WorldCoord)obj;
        return this.getX() == that.getX() && this.getZ() == that.getZ() && Objects.equals(this.getWorldName(), that.getWorldName());
    }

    @Override
    public String toString() {
        return this.getWorldName() + "," + super.toString();
    }

    @Nullable
    public World getBukkitWorld() {
        World world = this.worldRef.get();
        if (world == null) {
            world = Bukkit.getServer().getWorld(this.worldName);
            this.worldRef = new WeakReference<World>(world);
            if (this.worldUUID == null && world != null) {
                this.worldUUID = world.getUID();
            }
        }
        return world;
    }

    @Nullable
    public TownyWorld getTownyWorld() {
        return TownyAPI.getInstance().getTownyWorld(this.worldName);
    }

    public TownBlock getTownBlock() throws NotRegisteredException {
        if (!this.hasTownBlock()) {
            throw new NotRegisteredException();
        }
        return TownyUniverse.getInstance().getTownBlock(this);
    }

    @Nullable
    public TownBlock getTownBlockOrNull() {
        return TownyUniverse.getInstance().getTownBlockOrNull(this);
    }

    public boolean hasTownBlock() {
        return TownyUniverse.getInstance().hasTownBlock(this);
    }

    public boolean hasTown(Town town) {
        return town != null && town.equals(this.getTownOrNull());
    }

    public boolean isWilderness() {
        return !this.hasTownBlock();
    }

    public void loadChunks() {
        Towny plugin = Towny.getPlugin();
        if (!plugin.getScheduler().isRegionThread(this.getLowerMostCornerLocation())) {
            plugin.getScheduler().run(this.getLowerMostCornerLocation(), () -> this.loadChunks(plugin));
        } else {
            this.loadChunks(plugin);
        }
    }

    private void loadChunks(Towny plugin) {
        this.getChunks().forEach(future -> future.thenAccept(chunk -> chunk.addPluginChunkTicket((Plugin)plugin)));
    }

    public void unloadChunks() {
        Towny plugin = Towny.getPlugin();
        if (!plugin.getScheduler().isRegionThread(this.getLowerMostCornerLocation())) {
            plugin.getScheduler().run(this.getLowerMostCornerLocation(), () -> this.unloadChunks(plugin));
        } else {
            this.unloadChunks(plugin);
        }
    }

    private void unloadChunks(Towny plugin) {
        this.getChunks().forEach(future -> future.thenAccept(chunk -> chunk.removePluginChunkTicket((Plugin)plugin)));
    }

    public @Unmodifiable Collection<CompletableFuture<Chunk>> getChunks() {
        World world = this.getBukkitWorld();
        if (world == null) {
            return Collections.emptyList();
        }
        if (WorldCoord.getCellSize() > 16) {
            HashSet<CompletableFuture> chunkFutures = new HashSet<CompletableFuture>();
            for (Pair<Integer, Integer> chunkPos : this.getChunkPositions()) {
                chunkFutures.add(world.getChunkAtAsync(chunkPos.left().intValue(), chunkPos.right().intValue()));
            }
            return Collections.unmodifiableSet(chunkFutures);
        }
        return Collections.singleton(world.getChunkAtAsync(this.getCorner()));
    }

    protected Collection<Pair<Integer, Integer>> getChunkPositions() {
        return this.getChunkPositions(WorldCoord.getCellSize());
    }

    protected Collection<Pair<Integer, Integer>> getChunkPositions(int cellSize) {
        HashSet<Pair<Integer, Integer>> chunks = new HashSet<Pair<Integer, Integer>>();
        int side = (int)Math.ceil((float)cellSize / 16.0f);
        for (int x = 0; x < side; ++x) {
            for (int z = 0; z < side; ++z) {
                chunks.add(Pair.pair(x + this.getX(), z + this.getZ()));
            }
        }
        return chunks;
    }

    public boolean isFullyLoaded() {
        World bukkitWorld = this.getBukkitWorld();
        if (bukkitWorld == null) {
            return false;
        }
        for (Pair<Integer, Integer> chunkPos : this.getChunkPositions()) {
            if (bukkitWorld.isChunkLoaded(chunkPos.left().intValue(), chunkPos.right().intValue())) continue;
            return false;
        }
        return true;
    }

    private Location getCorner() {
        return new Location(this.getBukkitWorld(), (double)(this.getX() * WorldCoord.getCellSize()), 0.0, (double)(this.getZ() * WorldCoord.getCellSize()));
    }

    public BoundingBox getBoundingBox() {
        return BoundingBox.of((Block)this.getLowerMostCornerLocation().getBlock(), (Block)this.getUpperMostCornerLocation().getBlock());
    }

    public Location getLowerMostCornerLocation() {
        return new Location(this.getBukkitWorld(), (double)(this.getX() * WorldCoord.getCellSize()), (double)this.getBukkitWorld().getMinHeight(), (double)(this.getZ() * WorldCoord.getCellSize()));
    }

    public Location getUpperMostCornerLocation() {
        return this.getCorner().add((double)(WorldCoord.getCellSize() - 1), (double)(this.getBukkitWorld().getMaxHeight() - 1), (double)(WorldCoord.getCellSize() - 1));
    }

    @Nullable
    public Town getTownOrNull() {
        TownBlock townBlock = this.getTownBlockOrNull();
        return townBlock != null ? townBlock.getTownOrNull() : null;
    }

    public static boolean cellChanged(Location from, Location to) {
        return WorldCoord.toCell(from.getBlockX()) != WorldCoord.toCell(to.getBlockX()) || WorldCoord.toCell(from.getBlockZ()) != WorldCoord.toCell(to.getBlockZ()) || !Objects.equals(from.getWorld(), to.getWorld());
    }

    public List<WorldCoord> getCardinallyAdjacentWorldCoords(boolean ... includeOrdinalFlag) {
        boolean includeOrdinal = includeOrdinalFlag.length >= 1 ? includeOrdinalFlag[0] : false;
        ArrayList<WorldCoord> list = new ArrayList<WorldCoord>(includeOrdinal ? 8 : 4);
        list.add(this.add(0, -1));
        list.add(this.add(0, 1));
        list.add(this.add(1, 0));
        list.add(this.add(-1, 0));
        if (includeOrdinal) {
            list.add(this.add(1, 1));
            list.add(this.add(1, -1));
            list.add(this.add(-1, -1));
            list.add(this.add(-1, 1));
        }
        return list;
    }

    public boolean canBeStolen() {
        return TownySettings.isOverClaimingAllowingStolenLand() && this.hasTownBlock() && this.getTownOrNull().isOverClaimed();
    }
}

