/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object.comparators;

import com.palmergames.bukkit.towny.object.Town;
import java.util.Comparator;
import java.util.function.Function;

public class TownComparators {
    public static final Comparator<Town> BY_FORSALE = Comparator.comparingDouble(Town::getForSalePrice);
    public static final Comparator<Town> BY_RUINED = (t1, t2) -> TownComparators.doCompare(t1, t2, Town::isRuined);
    public static final Comparator<Town> BY_BANKRUPT = (t1, t2) -> TownComparators.doCompare(t1, t2, Town::isBankrupt);

    private static int doCompare(Town t1, Town t2, Function<Town, Boolean> func) {
        if (func.apply(t1).booleanValue() && func.apply(t2).booleanValue()) {
            return t2.getResidents().size() - t1.getResidents().size();
        }
        if (func.apply(t2).booleanValue()) {
            return 1;
        }
        return -1;
    }
}

