/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object.economy;

import com.palmergames.bukkit.config.ConfigNodes;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.object.EconomyAccount;
import com.palmergames.bukkit.towny.object.EconomyHandler;
import com.palmergames.bukkit.towny.object.Identifiable;
import com.palmergames.bukkit.towny.object.Nameable;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.economy.AccountAuditor;
import com.palmergames.bukkit.towny.object.economy.AccountObserver;
import com.palmergames.bukkit.towny.object.economy.GlobalAccountObserver;
import com.palmergames.bukkit.towny.object.economy.TownyServerAccount;
import com.palmergames.bukkit.towny.object.economy.transaction.Transaction;
import com.palmergames.bukkit.towny.utils.MinecraftVersion;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.util.JavaUtil;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class Account
implements Nameable,
Identifiable {
    private static final long CACHE_TIMEOUT = TownySettings.getCachedBankTimeout();
    private static final AccountObserver GLOBAL_OBSERVER = new GlobalAccountObserver();
    private final List<AccountObserver> observers = new ArrayList<AccountObserver>();
    private final EconomyHandler economyHandler;
    private AccountAuditor auditor;
    CachedBalance cachedBalance = new CachedBalance(0.0);
    private String name;
    private UUID uuid;
    private final Supplier<TownyWorld> worldSupplier;
    private boolean playerAccount;
    private OfflinePlayer cachedOfflinePlayer;
    private static final MethodHandle NAME_AND_ID_CONSTRUCTOR = JavaUtil.make(() -> {
        try {
            Class<?> clazz = MinecraftVersion.CURRENT_VERSION.isNewerThanOrEquals(MinecraftVersion.MINECRAFT_1_21_9) ? Class.forName("net.minecraft.server.players.NameAndId") : Class.forName("com.mojang.authlib.GameProfile");
            return MethodHandles.publicLookup().findConstructor(clazz, MethodType.methodType(Void.TYPE, UUID.class, String.class));
        }
        catch (Throwable throwable) {
            Towny.getPlugin().getLogger().log(Level.WARNING, "Could not find game profile constructor", throwable);
            return null;
        }
    });
    private static final MethodHandle OFFLINEPLAYER_CONSTRUCTOR = JavaUtil.make(() -> {
        try {
            String cbPackagePath = Bukkit.getServer().getClass().getPackage().getName();
            Class<?> offlinePlayer = Class.forName(cbPackagePath + ".CraftOfflinePlayer");
            Class<?> nameAndIdClass = MinecraftVersion.CURRENT_VERSION.isNewerThanOrEquals(MinecraftVersion.MINECRAFT_1_21_9) ? Class.forName("net.minecraft.server.players.NameAndId") : Class.forName("com.mojang.authlib.GameProfile");
            Constructor<?> constructor = offlinePlayer.getDeclaredConstructor(Class.forName(cbPackagePath + ".CraftServer"), nameAndIdClass);
            constructor.setAccessible(true);
            return MethodHandles.lookup().unreflectConstructor(constructor);
        }
        catch (Throwable throwable) {
            Towny.getPlugin().getLogger().log(Level.WARNING, "Could not find craft offline player constructor", throwable);
            return null;
        }
    });

    public Account(EconomyHandler owner, @NotNull String name, @NotNull UUID uuid, @Nullable Supplier<TownyWorld> worldSupplier, boolean playerAccount) {
        this.economyHandler = owner;
        this.name = name;
        this.uuid = uuid;
        this.worldSupplier = worldSupplier;
        this.playerAccount = playerAccount;
        this.observers.add(GLOBAL_OBSERVER);
        try {
            this.cachedBalance = new CachedBalance(this.getHoldingBalance(false));
        }
        catch (Exception e) {
            Towny.getPlugin().getLogger().log(Level.WARNING, String.format("An exception occurred when initializing cached balance for an account (name: %s), see the below error for more details.", name), e);
        }
    }

    @Deprecated
    public Account(EconomyHandler owner, @NotNull String name, @NotNull UUID uuid, @Nullable Supplier<TownyWorld> worldSupplier) {
        this.economyHandler = owner;
        this.name = name;
        this.uuid = uuid;
        this.worldSupplier = worldSupplier;
        this.playerAccount = false;
        this.observers.add(GLOBAL_OBSERVER);
        try {
            this.cachedBalance = new CachedBalance(this.getHoldingBalance(false));
        }
        catch (Exception e) {
            Towny.getPlugin().getLogger().log(Level.WARNING, String.format("An exception occurred when initializing cached balance for an account (name: %s), see the below error for more details.", name), e);
        }
    }

    @Deprecated
    public Account(EconomyHandler economyHandler, String name, World world) {
        UUID uUID;
        this.name = name;
        if (economyHandler instanceof Identifiable) {
            Identifiable identifiable = (Identifiable)((Object)economyHandler);
            uUID = identifiable.getUUID();
        } else {
            uUID = null;
        }
        this.uuid = uUID;
        this.economyHandler = economyHandler;
        this.playerAccount = false;
        TownyWorld townyWorld = TownyAPI.getInstance().getTownyWorld(world);
        this.worldSupplier = () -> townyWorld;
    }

    @Deprecated
    public Account(EconomyHandler economyHandler, String name) {
        UUID uUID;
        this.name = name;
        if (economyHandler instanceof Identifiable) {
            Identifiable identifiable = (Identifiable)((Object)economyHandler);
            uUID = identifiable.getUUID();
        } else {
            uUID = null;
        }
        this.uuid = uUID;
        this.economyHandler = economyHandler;
        this.worldSupplier = () -> TownyUniverse.getInstance().getTownyWorlds().get(0);
        this.playerAccount = false;
    }

    protected abstract boolean addMoney(double var1);

    protected abstract boolean subtractMoney(double var1);

    public synchronized boolean deposit(double amount, String reason) {
        if (this.addMoney(amount)) {
            this.notifyObserversDeposit(this, amount, reason);
            if (TownySettings.getBoolean(ConfigNodes.ECO_CLOSED_ECONOMY_ENABLED)) {
                return this.payFromServer(amount, reason);
            }
            BukkitTools.fireEvent(Transaction.add(amount).paidTo(this).asTownyTransactionEvent());
            return true;
        }
        return false;
    }

    public synchronized boolean withdraw(double amount, String reason) {
        if (this.subtractMoney(amount)) {
            this.notifyObserversWithdraw(this, amount, reason);
            if (TownySettings.getBoolean(ConfigNodes.ECO_CLOSED_ECONOMY_ENABLED)) {
                return this.payToServer(amount, reason);
            }
            BukkitTools.fireEvent(Transaction.subtract(amount).paidBy(this).asTownyTransactionEvent());
            return true;
        }
        return false;
    }

    public synchronized boolean payTo(double amount, EconomyHandler collector, String reason) {
        return this.payTo(amount, collector.getAccount(), reason);
    }

    protected synchronized boolean payToServer(double amount, String reason) {
        boolean success = TownyServerAccount.addToServer(this, amount, this.getWorld());
        if (success) {
            this.notifyObserversDeposit(TownyServerAccount.ACCOUNT, amount, reason);
        }
        return success;
    }

    protected synchronized boolean payFromServer(double amount, String reason) {
        boolean success = TownyServerAccount.subtractFromServer(this, amount, this.getWorld());
        if (success) {
            this.notifyObserversWithdraw(TownyServerAccount.ACCOUNT, amount, reason);
        }
        return success;
    }

    public synchronized boolean payTo(double amount, Account collector, String reason) {
        boolean success;
        if (amount > this.getHoldingBalance()) {
            return false;
        }
        boolean bl = success = this.withdraw(amount, reason) && collector.deposit(amount, reason);
        if (success) {
            BukkitTools.fireEvent(Transaction.add(amount).paidBy(this).paidTo(collector).asTownyTransactionEvent());
        }
        return success;
    }

    @Deprecated
    @Nullable
    public World getBukkitWorld() {
        return this.getWorld().getBukkitWorld();
    }

    @NotNull
    public TownyWorld getWorld() {
        return this.worldSupplier.get();
    }

    public boolean setBalance(double amount, String reason) {
        double balance = this.getHoldingBalance();
        double diff = amount - balance;
        if (diff > 0.0) {
            return this.deposit(diff, reason);
        }
        if (balance > amount) {
            diff = -diff;
            return this.withdraw(diff, reason);
        }
        return true;
    }

    public synchronized double getHoldingBalance() {
        return this.getHoldingBalance(true);
    }

    public synchronized double getHoldingBalance(boolean setCache) {
        double balance = TownyEconomyHandler.getBalance(this);
        if (setCache) {
            this.cachedBalance.setBalance(balance);
        }
        return balance;
    }

    public synchronized boolean canPayFromHoldings(double amount) {
        return TownyEconomyHandler.hasEnough(this, amount);
    }

    public String getHoldingFormattedBalance() {
        return TownyEconomyHandler.getFormattedBalance(this.getHoldingBalance());
    }

    public void removeAccount() {
        double balance;
        if (TownySettings.isEcoClosedEconomyEnabled() && (balance = TownyEconomyHandler.getBalance(this)) > 0.0) {
            TownyServerAccount.addToServer(this, balance, this.getWorld());
        }
        TownyEconomyHandler.removeAccount(this);
    }

    public EconomyHandler getEconomyHandler() {
        return this.economyHandler;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.cachedOfflinePlayer = null;
    }

    @Override
    @NotNull
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public void setUUID(@NotNull UUID uuid) {
        this.uuid = uuid;
        this.cachedOfflinePlayer = null;
    }

    public boolean isPlayerAccount() {
        return this.playerAccount;
    }

    public void setPlayerAccount(boolean playerAccount) {
        this.playerAccount = playerAccount;
    }

    public @Unmodifiable List<AccountObserver> getObservers() {
        return Collections.unmodifiableList(this.observers);
    }

    private void notifyObserversDeposit(Account account, double amount, String reason) {
        for (AccountObserver observer : this.getObservers()) {
            observer.deposited(account, amount, reason);
        }
    }

    private void notifyObserversWithdraw(Account account, double amount, String reason) {
        for (AccountObserver observer : this.getObservers()) {
            observer.withdrew(account, amount, reason);
        }
    }

    public final void addObserver(AccountObserver observer) {
        this.observers.add(observer);
    }

    public final void removeObserver(AccountObserver observer) {
        this.observers.remove(observer);
    }

    public final AccountAuditor getAuditor() {
        return this.auditor;
    }

    public final void setAuditor(AccountAuditor auditor) {
        this.auditor = auditor;
        this.addObserver(auditor);
    }

    public double getCachedBalance() {
        return this.getCachedBalance(true);
    }

    public synchronized double getCachedBalance(boolean refreshIfStale) {
        if (refreshIfStale && this.cachedBalance.isStale()) {
            this.cachedBalance.updateCache();
        }
        return this.cachedBalance.getBalance();
    }

    @ApiStatus.Internal
    @NotNull
    public OfflinePlayer asOfflinePlayer() {
        Player player;
        if (this instanceof EconomyAccount && this.uuid.version() != 2 && (player = Bukkit.getServer().getPlayer(this.uuid)) != null) {
            return player;
        }
        if (this.cachedOfflinePlayer != null) {
            return this.cachedOfflinePlayer;
        }
        try {
            Object gameProfile = NAME_AND_ID_CONSTRUCTOR.invoke(this.uuid, this.name);
            this.cachedOfflinePlayer = OFFLINEPLAYER_CONSTRUCTOR.invoke(Bukkit.getServer(), gameProfile);
            return this.cachedOfflinePlayer;
        }
        catch (Throwable throwable) {
            Towny.getPlugin().getLogger().log(Level.WARNING, "An exception occurred when creating offline player for account " + String.valueOf(this.getUUID()), throwable);
            return Bukkit.getServer().getOfflinePlayer(this.uuid);
        }
    }

    class CachedBalance {
        private double balance = 0.0;
        private long time;

        CachedBalance(double balance) {
            this.balance = balance;
            this.time = System.currentTimeMillis();
        }

        double getBalance() {
            return this.balance;
        }

        boolean isStale() {
            return System.currentTimeMillis() - this.time > CACHE_TIMEOUT;
        }

        void setBalance(double _balance) {
            this.balance = _balance;
            this.time = System.currentTimeMillis();
        }

        void updateCache() {
            this.time = System.currentTimeMillis();
            TownyEconomyHandler.economyExecutor().execute(() -> this.setBalance(Account.this.getHoldingBalance()));
        }
    }
}

