/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object.economy;

import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.event.economy.TownEntersBankruptcyEvent;
import com.palmergames.bukkit.towny.object.Government;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.economy.Account;
import com.palmergames.bukkit.util.BukkitTools;
import org.jetbrains.annotations.Nullable;

public class BankAccount
extends Account {
    private double debtCap;
    private final Government government;

    public BankAccount(String name, Government government) {
        super(government, name, TownyEconomyHandler.modifyNPCUUID(government.getUUID()), () -> TownyAPI.getInstance().getTownyWorld(government.getWorld()), false);
        this.government = government;
    }

    public double getBalanceCap() {
        return this.government.getBankCap();
    }

    @Override
    protected synchronized boolean subtractMoney(double amount) {
        if (this.isBankrupt()) {
            return this.addDebt(amount);
        }
        if (!this.canPayFromHoldings(amount) && this.isAllowedToEnterBankruptcy()) {
            double newDebt = amount - this.getHoldingBalance();
            if (newDebt <= this.getDebtCap()) {
                boolean success = TownyEconomyHandler.setBalance(this, 0.0);
                if (success &= this.addDebt(newDebt)) {
                    BukkitTools.fireEvent(new TownEntersBankruptcyEvent(this.getTown()));
                }
                return success;
            }
            return false;
        }
        return TownyEconomyHandler.subtract(this, amount);
    }

    @Override
    protected synchronized boolean addMoney(double amount) {
        if (this.getBalanceCap() != 0.0 && this.getHoldingBalance() + amount > this.getBalanceCap()) {
            return false;
        }
        if (this.isBankrupt()) {
            return this.removeDebt(amount);
        }
        return TownyEconomyHandler.add(this, amount);
    }

    @Override
    public synchronized boolean canPayFromHoldings(double amount) {
        if (this.isBankrupt()) {
            return this.getTownDebt() + amount <= this.getDebtCap();
        }
        return super.canPayFromHoldings(amount);
    }

    @Override
    public synchronized double getHoldingBalance(boolean setCache) {
        double balance;
        double d = balance = this.isBankrupt() ? this.getTownDebt() * -1.0 : TownyEconomyHandler.getBalance(this);
        if (setCache) {
            this.cachedBalance.setBalance(balance);
        }
        return balance;
    }

    @Override
    public String getHoldingFormattedBalance() {
        if (this.isBankrupt()) {
            return "-" + TownyEconomyHandler.getFormattedBalance(this.getTownDebt());
        }
        return TownyEconomyHandler.getFormattedBalance(this.getHoldingBalance());
    }

    private boolean isTownAccount() {
        return this.government instanceof Town;
    }

    @Nullable
    private Town getTown() {
        return this.isTownAccount() ? (Town)this.government : null;
    }

    @Override
    public void removeAccount() {
        double balance;
        Resident owner;
        if (TownySettings.isDeletedObjectBalancePaidToOwner() && (owner = this.getGovernmentOwner()) != null && !owner.isNPC() && (balance = this.getHoldingBalance()) > 0.0) {
            TownyMessaging.sendMsg(owner, Translatable.of("msg_recieved_refund_for_deleted_object", TownyEconomyHandler.getFormattedBalance(balance)));
            this.payTo(balance, owner, "Deleted " + (this.isTownAccount() ? "Town" : "Nation") + " bank balance refund.");
        }
        super.removeAccount();
    }

    @Nullable
    private Resident getGovernmentOwner() {
        Resident resident;
        Government government = this.government;
        if (government instanceof Town) {
            Town town = (Town)government;
            resident = town.getMayor();
        } else {
            Nation nation;
            government = this.government;
            resident = government instanceof Nation && (nation = (Nation)government).hasCapital() ? nation.getKing() : null;
        }
        return resident;
    }

    public boolean isBankrupt() {
        Town town;
        Government government = this.government;
        return government instanceof Town && (town = (Town)government).isBankrupt();
    }

    private synchronized boolean addDebt(double amount) {
        if (this.isTownAccount() && TownySettings.isTownBankruptcyEnabled()) {
            double newDebtBalance = this.getTownDebt() + amount;
            if (newDebtBalance > this.getDebtCap()) {
                return false;
            }
            this.setTownDebt(newDebtBalance);
            return true;
        }
        return false;
    }

    private synchronized boolean removeDebt(double amount) {
        if (this.getTownDebt() < amount) {
            double netMoney = amount - this.getTownDebt();
            this.setTownDebt(0.0);
            TownyEconomyHandler.setBalance(this, this.getHoldingBalance() + netMoney);
            return true;
        }
        this.setTownDebt(this.getTownDebt() - amount);
        return true;
    }

    public synchronized double getDebtCap() {
        if (!this.isTownAccount()) {
            return Double.MAX_VALUE;
        }
        if (TownySettings.isDebtCapDeterminedByTownLevel()) {
            return this.getTown().getTownLevel().debtCapModifier() * TownySettings.getDebtCapOverride();
        }
        if (TownySettings.getDebtCapOverride() != 0.0) {
            return TownySettings.getDebtCapOverride();
        }
        if (TownySettings.getDebtCapMaximum() != 0.0) {
            return Math.min(this.debtCap, TownySettings.getDebtCapMaximum());
        }
        return this.debtCap;
    }

    public void setDebtCap(double debtCap) {
        this.debtCap = debtCap;
    }

    private boolean isAllowedToEnterBankruptcy() {
        return TownySettings.isTownBankruptcyEnabled() && this.isTownAccount();
    }

    private double getTownDebt() {
        return this.getTown().getDebtBalance();
    }

    private void setTownDebt(double amount) {
        this.getTown().setDebtBalance(amount);
        this.getTown().save();
    }
}

