/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object.economy;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.object.economy.Account;
import com.palmergames.bukkit.towny.object.economy.AccountAuditor;
import com.palmergames.bukkit.towny.object.economy.BankTransaction;
import com.palmergames.bukkit.towny.object.economy.transaction.TransactionType;
import com.palmergames.bukkit.util.Colors;
import java.util.ArrayList;
import java.util.List;

public class GovernmentAccountAuditor
implements AccountAuditor {
    private final List<BankTransaction> transactions = new ArrayList<BankTransaction>();

    @Override
    public void withdrew(Account account, double amount, String reason) {
        Towny.getPlugin().getScheduler().runLater(() -> this.transactions.add(new BankTransaction(TransactionType.WITHDRAW, System.currentTimeMillis(), account, amount, account.getHoldingBalance(), reason)), 1L);
    }

    @Override
    public void deposited(Account account, double amount, String reason) {
        Towny.getPlugin().getScheduler().runLater(() -> this.transactions.add(new BankTransaction(TransactionType.DEPOSIT, System.currentTimeMillis(), account, amount, account.getHoldingBalance(), reason)), 1L);
    }

    @Override
    public List<String> getAuditHistory() {
        ArrayList<String> history = new ArrayList<String>(this.transactions.size());
        for (BankTransaction transaction : this.transactions) {
            history.add(Colors.translateColorCodes(TownySettings.getBankHistoryBookFormat().replace("{time}", transaction.getTime()).replace("{type}", transaction.getType().getName()).replace("{amount}", Colors.strip(TownyEconomyHandler.getFormattedBalance(transaction.getAmount()))).replace("{to-from}", transaction.getType() == TransactionType.DEPOSIT ? " to " : " from ").replace("{name}", transaction.getAccount().getName()).replace("{reason}", transaction.getReason()).replace("{balance}", Colors.strip(TownyEconomyHandler.getFormattedBalance(transaction.getBalance())))));
        }
        return history;
    }

    @Override
    public List<BankTransaction> getTransactions() {
        return this.transactions;
    }
}

