/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object.economy;

import com.palmergames.bukkit.config.ConfigNodes;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.object.EconomyHandler;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.economy.Account;
import com.palmergames.bukkit.towny.object.economy.transaction.Transaction;
import com.palmergames.bukkit.util.BukkitTools;
import java.util.UUID;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class TownyServerAccount
extends Account {
    private static final UUID uuid = UUID.fromString(TownySettings.getString(ConfigNodes.ECO_CLOSED_ECONOMY_SERVER_ACCOUNT_UUID));
    private static final String name = TownySettings.getString(ConfigNodes.ECO_CLOSED_ECONOMY_SERVER_ACCOUNT);
    private static final ThreadLocal<TownyWorld> worldLocal = ThreadLocal.withInitial(() -> TownyUniverse.getInstance().getTownyWorlds().get(0));
    public static final TownyServerAccount ACCOUNT = new TownyServerAccount();

    private TownyServerAccount() {
        super(new EconomyHandlerHolder(), name, uuid, worldLocal::get, false);
    }

    @Override
    protected synchronized boolean addMoney(double amount) {
        return TownyServerAccount.addToServer(null, amount, this.getWorld());
    }

    @Override
    protected synchronized boolean subtractMoney(double amount) {
        return TownyServerAccount.subtractFromServer(null, amount, this.getWorld());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addToServer(Account account, double amount, TownyWorld world) {
        worldLocal.set(world);
        try {
            boolean success = TownyEconomyHandler.add(ACCOUNT, amount);
            if (success) {
                BukkitTools.fireEvent(Transaction.add(amount).paidBy(account).paidToServer().asTownyTransactionEvent());
            }
            boolean bl = success;
            return bl;
        }
        finally {
            worldLocal.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean subtractFromServer(Account account, double amount, TownyWorld world) {
        worldLocal.set(world);
        try {
            boolean success = TownyEconomyHandler.subtract(ACCOUNT, amount);
            if (success) {
                BukkitTools.fireEvent(Transaction.subtract(amount).paidByServer().paidTo(account).asTownyTransactionEvent());
            }
            boolean bl = success;
            return bl;
        }
        finally {
            worldLocal.remove();
        }
    }

    private static final class EconomyHandlerHolder
    implements EconomyHandler {
        private EconomyHandlerHolder() {
        }

        @Override
        public Account getAccount() {
            return ACCOUNT;
        }

        @Override
        public String getName() {
            return name;
        }
    }
}

