/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object.economy.adapter;

import com.palmergames.bukkit.towny.object.economy.Account;
import com.palmergames.bukkit.towny.object.economy.adapter.EconomyAdapter;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.OfflinePlayer;

public class VaultEconomyAdapter
implements EconomyAdapter {
    protected final Economy economy;

    public VaultEconomyAdapter(Economy economy) {
        this.economy = economy;
    }

    @Override
    public String name() {
        return this.economy.getName();
    }

    @Override
    public boolean add(Account account, double amount) {
        return this.economy.depositPlayer((OfflinePlayer)account.asOfflinePlayer(), (String)account.getWorld().getName(), (double)amount).type == EconomyResponse.ResponseType.SUCCESS;
    }

    @Override
    public boolean subtract(Account account, double amount) {
        return this.economy.withdrawPlayer((OfflinePlayer)account.asOfflinePlayer(), (String)account.getWorld().getName(), (double)amount).type == EconomyResponse.ResponseType.SUCCESS;
    }

    @Override
    public boolean hasAccount(Account account) {
        return this.economy.hasAccount(account.asOfflinePlayer(), account.getWorld().getName());
    }

    @Override
    public double getBalance(Account account) {
        return this.economy.getBalance(account.asOfflinePlayer(), account.getWorld().getName());
    }

    @Override
    public void newAccount(Account account) {
        this.economy.createPlayerAccount(account.asOfflinePlayer(), account.getWorld().getName());
    }

    @Override
    public void deleteAccount(Account account) {
        if (!this.hasAccount(account)) {
            return;
        }
        this.subtract(account, this.getBalance(account));
    }

    @Override
    public boolean setBalance(Account account, double amount) {
        double currentBalance = this.getBalance(account);
        double diff = Math.abs(amount - currentBalance);
        if (amount > currentBalance) {
            return this.add(account, diff);
        }
        if (amount < currentBalance) {
            return this.subtract(account, diff);
        }
        return true;
    }

    @Override
    public String getFormattedBalance(double balance) {
        return this.economy.format(balance);
    }

    @Override
    public boolean renameAccount(Account account, String newName) {
        return true;
    }

    public static class Legacy
    extends VaultEconomyAdapter {
        public Legacy(Economy economy) {
            super(economy);
        }

        @Override
        public boolean add(Account account, double amount) {
            return this.economy.depositPlayer((String)account.getName(), (String)account.getWorld().getName(), (double)amount).type == EconomyResponse.ResponseType.SUCCESS;
        }

        @Override
        public boolean subtract(Account account, double amount) {
            return this.economy.withdrawPlayer((String)account.getName(), (String)account.getWorld().getName(), (double)amount).type == EconomyResponse.ResponseType.SUCCESS;
        }

        @Override
        public boolean hasAccount(Account account) {
            return this.economy.hasAccount(account.getName(), account.getWorld().getName());
        }

        @Override
        public double getBalance(Account account) {
            return this.economy.getBalance(account.getName(), account.getWorld().getName());
        }

        @Override
        public void newAccount(Account account) {
            this.economy.createPlayerAccount(account.getName(), account.getWorld().getName());
        }
    }
}

