/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object.economy.adapter;

import com.palmergames.bukkit.towny.object.economy.Account;
import com.palmergames.bukkit.towny.object.economy.adapter.EconomyAdapter;
import java.math.BigDecimal;
import java.util.UUID;
import net.milkbowl.vault2.economy.Economy;
import net.milkbowl.vault2.economy.EconomyResponse;

public class VaultUnlockedEconomyAdapter
implements EconomyAdapter {
    private static final String TOWNY = "Towny";
    protected final Economy economy;

    public VaultUnlockedEconomyAdapter(Economy economy) {
        this.economy = economy;
    }

    @Override
    public String name() {
        return this.economy.getName();
    }

    @Override
    public boolean add(Account account, double amount) {
        BigDecimal bd = BigDecimal.valueOf(amount);
        return this.economy.deposit((String)TOWNY, (UUID)account.getUUID(), (String)account.getWorld().getName(), (BigDecimal)bd).type == EconomyResponse.ResponseType.SUCCESS;
    }

    @Override
    public boolean subtract(Account account, double amount) {
        BigDecimal bd = BigDecimal.valueOf(amount);
        return this.economy.withdraw((String)TOWNY, (UUID)account.getUUID(), (String)account.getWorld().getName(), (BigDecimal)bd).type == EconomyResponse.ResponseType.SUCCESS;
    }

    @Override
    public boolean hasAccount(Account account) {
        return this.economy.hasAccount(account.getUUID(), account.getWorld().getName());
    }

    @Override
    public double getBalance(Account account) {
        return this.economy.balance(TOWNY, account.getUUID(), account.getWorld().getName()).doubleValue();
    }

    @Override
    public void newAccount(Account account) {
        this.economy.createAccount(account.getUUID(), account.getName(), account.getWorld().getName(), account.isPlayerAccount());
    }

    @Override
    public void deleteAccount(Account account) {
        this.economy.deleteAccount(TOWNY, account.getUUID());
    }

    @Override
    public boolean renameAccount(Account account, String newName) {
        return this.economy.renameAccount(TOWNY, account.getUUID(), newName);
    }

    @Override
    public boolean setBalance(Account account, double amount) {
        double currentBalance = this.getBalance(account);
        double diff = Math.abs(amount - currentBalance);
        if (amount > currentBalance) {
            return this.add(account, diff);
        }
        if (amount < currentBalance) {
            return this.subtract(account, diff);
        }
        return true;
    }

    @Override
    public String getFormattedBalance(double balance) {
        BigDecimal bd = BigDecimal.valueOf(balance);
        return this.economy.format(TOWNY, bd);
    }
}

