/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object.economy.provider;

import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.object.economy.adapter.EconomyAdapter;
import com.palmergames.bukkit.towny.object.economy.adapter.ReserveEconomyAdapter;
import com.palmergames.bukkit.towny.object.economy.provider.EconomyProvider;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.tnemc.core.Reserve;
import net.tnemc.core.economy.EconomyAPI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReserveEconomyProvider
extends EconomyProvider {
    private final Reserve reserve;
    private final Function<EconomyAPI, ReserveEconomyAdapter> adapterFunction = api -> !this.isLegacy() ? new ReserveEconomyAdapter((EconomyAPI)api) : new ReserveEconomyAdapter.Legacy((EconomyAPI)api);

    public ReserveEconomyProvider(Reserve reserve) {
        this.reserve = reserve;
    }

    @Override
    public String name() {
        return "Reserve";
    }

    @Override
    public TownyEconomyHandler.EcoType economyType() {
        return TownyEconomyHandler.EcoType.RESERVE;
    }

    @Override
    @Nullable
    public EconomyAdapter mainAdapter() {
        if (this.reserve.economy() == null) {
            return null;
        }
        return this.adapterFunction.apply(this.reserve.economy());
    }

    @Override
    public Collection<EconomyAdapter> economyAdapters() {
        return this.reserve.getRegisteredEconomies().values().stream().map(this.adapterFunction).collect(Collectors.toSet());
    }

    @Override
    @Nullable
    public EconomyAdapter getEconomyAdapter(@NotNull String name) {
        return Optional.ofNullable((EconomyAPI)this.reserve.getRegisteredEconomies().get(name)).map(this.adapterFunction).orElse(null);
    }
}

