/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object.economy.provider;

import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.object.economy.adapter.EconomyAdapter;
import com.palmergames.bukkit.towny.object.economy.adapter.VaultEconomyAdapter;
import com.palmergames.bukkit.towny.object.economy.provider.EconomyProvider;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VaultEconomyProvider
extends EconomyProvider {
    private final Function<RegisteredServiceProvider<Economy>, EconomyAdapter> adapterFunction = registration -> !this.isLegacy() ? new VaultEconomyAdapter((Economy)registration.getProvider()) : new VaultEconomyAdapter.Legacy((Economy)registration.getProvider());

    @Override
    public String name() {
        return "Vault";
    }

    @Override
    public TownyEconomyHandler.EcoType economyType() {
        return TownyEconomyHandler.EcoType.VAULT;
    }

    @Override
    public EconomyAdapter mainAdapter() {
        RegisteredServiceProvider registration = Bukkit.getServer().getServicesManager().getRegistration(Economy.class);
        if (registration == null) {
            return null;
        }
        return this.adapterFunction.apply((RegisteredServiceProvider<Economy>)registration);
    }

    @Override
    public Collection<EconomyAdapter> economyAdapters() {
        return this.getEconomyRegistrations().values().stream().map(this.adapterFunction).collect(Collectors.toList());
    }

    @Override
    @Nullable
    public EconomyAdapter getEconomyAdapter(@NotNull String name) {
        return Optional.ofNullable(this.getEconomyRegistrations().get(name)).map(this.adapterFunction).orElse(null);
    }

    private Map<String, RegisteredServiceProvider<Economy>> getEconomyRegistrations() {
        return Bukkit.getServer().getServicesManager().getRegistrations(Economy.class).stream().collect(Collectors.toMap(registration -> ((Economy)registration.getProvider()).getName(), registration -> registration));
    }
}

