/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object.economy.transaction;

import com.palmergames.bukkit.towny.object.EconomyHandler;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.economy.Account;
import com.palmergames.bukkit.towny.object.economy.transaction.TransactionBuilder;
import com.palmergames.bukkit.towny.object.economy.transaction.TransactionType;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class Transaction {
    private final TransactionType type;
    private final Account receivingAccount;
    private final Account sendingAccount;
    private final double amount;

    public Transaction(TransactionBuilder builder) {
        this.type = builder.type;
        this.receivingAccount = builder.receivingAccount;
        this.sendingAccount = builder.sendingAccount;
        this.amount = builder.amount;
    }

    public static TransactionBuilder add(double amount) {
        return new TransactionBuilder(amount, TransactionType.ADD);
    }

    public static TransactionBuilder subtract(double amount) {
        return new TransactionBuilder(amount, TransactionType.SUBTRACT);
    }

    public static TransactionBuilder deposit(double amount) {
        return new TransactionBuilder(amount, TransactionType.DEPOSIT);
    }

    public static TransactionBuilder withdraw(double amount) {
        return new TransactionBuilder(amount, TransactionType.WITHDRAW);
    }

    public TransactionType getType() {
        return this.type;
    }

    @Nullable
    public Account getReceivingAccount() {
        return this.receivingAccount;
    }

    public boolean hasReceiverAccount() {
        return this.receivingAccount != null;
    }

    @Nullable
    public Account getSendingAccount() {
        return this.sendingAccount;
    }

    public boolean hasSenderAccount() {
        return this.sendingAccount != null;
    }

    @Nullable
    public Player getSendingPlayer() {
        EconomyHandler economyHandler;
        if (this.hasSenderAccount() && (economyHandler = this.getSendingAccount().getEconomyHandler()) instanceof Resident) {
            Resident resident = (Resident)economyHandler;
            return resident.getPlayer();
        }
        return null;
    }

    public double getAmount() {
        return this.amount;
    }
}

