/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object.gui;

import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyInventory;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class PermissionGUI
extends TownyInventory {
    private final TownBlock townBlock;
    private final boolean canEdit;

    public PermissionGUI(Resident res, Inventory inv, Component name, TownBlock townBlock, boolean canEdit) {
        super(res, inv, name);
        this.townBlock = townBlock;
        this.canEdit = canEdit;
    }

    public TownBlock getTownBlock() {
        return this.townBlock;
    }

    public boolean canEdit() {
        return this.canEdit;
    }

    @Override
    public void tryPaginate(ItemStack clickedItem, Player player, Resident resident, InventoryView inventoryView) {
        int currentPage = resident.getGUIPageNum();
        ItemMeta clickedItemItemMeta = clickedItem.getItemMeta();
        try {
            if (this.isNextButton(clickedItemItemMeta)) {
                if (resident.getGUIPageNum() <= resident.getGUIPages().size() - 1) {
                    resident.setGUIPageNum(++currentPage);
                    new PermissionGUI(resident, resident.getGUIPage(), inventoryView.title(), this.townBlock, this.canEdit);
                    this.playClickSound(player);
                }
            } else if (this.isBackButton(clickedItemItemMeta) && resident.getGUIPageNum() > 0) {
                resident.setGUIPageNum(--currentPage);
                new PermissionGUI(resident, resident.getGUIPage(), inventoryView.title(), this.townBlock, this.canEdit);
                this.playClickSound(player);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

