/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object.jail;

import com.google.common.collect.Lists;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.object.Position;
import com.palmergames.bukkit.towny.object.Savable;
import com.palmergames.bukkit.towny.object.SpawnPoint;
import com.palmergames.bukkit.towny.object.SpawnPointLocation;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.jetbrains.annotations.ApiStatus;

public class Jail
implements Savable {
    private UUID uuid;
    private Town town;
    private TownBlock townBlock;
    private final Map<SpawnPointLocation, Position> jailCellMap = new ConcurrentHashMap<SpawnPointLocation, Position>();
    private final List<Position> jailCells = new ArrayList<Position>();

    public Jail(UUID uuid, Town town, TownBlock townBlock, List<Location> jailCells) {
        this(uuid, town, townBlock, jailCells.stream().map(Position::ofLocation).collect(Collectors.toList()));
    }

    public Jail(UUID uuid, Town town, TownBlock townBlock, Collection<Position> jailCells) {
        this.uuid = uuid;
        this.town = town;
        this.townBlock = townBlock;
        for (Position cell : jailCells) {
            this.addJailCell(cell);
        }
    }

    public UUID getUUID() {
        return this.uuid;
    }

    @ApiStatus.Internal
    public void setUUID(UUID uuid) {
        this.uuid = uuid;
    }

    public Town getTown() {
        return this.town;
    }

    public void setTown(Town town) {
        this.town = town;
    }

    public TownBlock getTownBlock() {
        return this.townBlock;
    }

    public void setTownBlock(TownBlock townBlock) {
        this.townBlock = townBlock;
    }

    public List<Location> getJailCellLocations() {
        return Collections.unmodifiableList(Lists.transform(this.jailCells, Position::asLocation));
    }

    public List<Position> getJailCellPositions() {
        return Collections.unmodifiableList(this.jailCells);
    }

    public int getJailCellCount() {
        return this.jailCellMap.size();
    }

    public void setJailCells(List<Location> jailCells) {
        this.jailCellMap.clear();
        this.jailCells.clear();
        for (Location jail : jailCells) {
            this.addJailCell(jail);
        }
    }

    public void addJailCell(Location location) {
        Position pos = Position.ofLocation(location);
        this.jailCells.add(pos);
        this.jailCellMap.put(SpawnPointLocation.parseSpawnPointLocation(location), pos);
        TownyUniverse.getInstance().addSpawnPoint(new SpawnPoint(pos, SpawnPoint.SpawnPointType.JAIL_SPAWN));
    }

    public void addJailCell(Position position) {
        this.jailCells.add(position);
        this.jailCellMap.put(SpawnPointLocation.parsePos(position), position);
        TownyUniverse.getInstance().addSpawnPoint(new SpawnPoint(position, SpawnPoint.SpawnPointType.JAIL_SPAWN));
    }

    public void removeJailCell(Location loc) {
        this.removeJailCell(SpawnPointLocation.parseSpawnPointLocation(loc));
    }

    public void removeJailCell(SpawnPointLocation pos) {
        TownyUniverse.getInstance().removeSpawnPoint(pos);
        this.jailCellMap.remove(pos);
    }

    public void removeAllCells() {
        for (SpawnPointLocation pos : this.jailCellMap.keySet()) {
            this.removeJailCell(pos);
        }
    }

    public boolean hasJailCell(SpawnPointLocation loc) {
        return this.jailCellMap.containsKey(loc);
    }

    public boolean hasJailCell(int index) {
        return this.jailCellMap.size() - 1 >= index;
    }

    public String getWildName() {
        return this.getTownBlock().getWorld().getFormattedUnclaimedZoneName();
    }

    @Override
    public void save() {
        TownyUniverse.getInstance().getDataSource().saveJail(this);
    }

    public boolean hasCells() {
        return !this.jailCellMap.isEmpty();
    }

    public boolean hasName() {
        return !this.getTownBlock().getName().isEmpty();
    }

    public String getName() {
        if (this.hasName()) {
            return this.getTownBlock().getName();
        }
        return "";
    }
}

