/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object.metadata;

import com.palmergames.bukkit.towny.exceptions.InvalidMetadataTypeException;
import com.palmergames.bukkit.towny.utils.TownyComponents;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CustomDataField<T>
implements Cloneable {
    T value;
    final String key;
    protected String label;

    public CustomDataField(String key, T value, String label) {
        this.setValue(value);
        this.key = key;
        this.label = label;
    }

    public CustomDataField(String key, T value) {
        this(key, value, null);
    }

    public CustomDataField(String key, String label) {
        this(key, null, label);
    }

    public CustomDataField(String key) {
        this(key, null, null);
    }

    @NotNull
    public abstract String getTypeID();

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public abstract void setValueFromString(String var1);

    @Nullable
    protected String serializeValueToString() {
        return String.valueOf(this.getValue());
    }

    @NotNull
    public String getKey() {
        return this.key;
    }

    public boolean shouldDisplayInStatus() {
        return this.hasLabel();
    }

    @NotNull
    public String getLabel() {
        if (this.hasLabel()) {
            return this.label;
        }
        return "nil";
    }

    @NotNull
    public Component getLabelAsComp() {
        return TownyComponents.miniMessage(this.getLabel());
    }

    public boolean hasLabel() {
        return this.label != null;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{type=" + this.getTypeID() + ", key='" + this.key + "', value=" + String.valueOf(this.value) + "', label='" + this.label + "'}";
    }

    protected boolean canParseFromString(String strValue) {
        return true;
    }

    public final void isValidType(String str) throws InvalidMetadataTypeException {
        if (!this.canParseFromString(str)) {
            throw new InvalidMetadataTypeException(this);
        }
    }

    protected abstract String displayFormattedValue();

    public Component formatValueAsComp() {
        return TownyComponents.miniMessage(this.displayFormattedValue());
    }

    public boolean equals(Object rhs) {
        if (rhs instanceof CustomDataField) {
            return ((CustomDataField)rhs).getKey().equals(this.getKey());
        }
        return false;
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    @NotNull
    public abstract CustomDataField<T> clone();
}

