/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object.metadata;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.palmergames.bukkit.towny.object.metadata.BooleanDataField;
import com.palmergames.bukkit.towny.object.metadata.CustomDataField;
import com.palmergames.bukkit.towny.object.metadata.DecimalDataField;
import com.palmergames.bukkit.towny.object.metadata.IntegerDataField;
import com.palmergames.bukkit.towny.object.metadata.LongDataField;
import com.palmergames.bukkit.towny.object.metadata.RawDataField;
import com.palmergames.bukkit.towny.object.metadata.StringDataField;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class DataFieldIO {
    public static String serializeCDFs(Collection<CustomDataField<?>> cdfs) {
        if (cdfs.isEmpty()) {
            return "";
        }
        JsonArray array = new JsonArray();
        for (CustomDataField<?> cdf : cdfs) {
            JsonArray serializedArray = DataFieldIO.serializeCDF(cdf);
            array.add((JsonElement)serializedArray);
        }
        return array.toString();
    }

    private static JsonArray serializeCDF(CustomDataField<?> cdf) {
        JsonArray array = new JsonArray();
        array.add(cdf.getTypeID());
        array.add(cdf.getKey());
        if (cdf.getValue() != null) {
            array.add(cdf.serializeValueToString());
        } else {
            array.add((JsonElement)JsonNull.INSTANCE);
        }
        if (cdf.hasLabel()) {
            array.add(cdf.getLabel());
        }
        return array;
    }

    public static Collection<CustomDataField<?>> deserializeMeta(String metadata) throws IOException {
        if (metadata == null || metadata.isEmpty()) {
            return Collections.emptyList();
        }
        if (metadata.charAt(0) != '[') {
            return DataFieldIO.deserializeLegacyMeta(metadata);
        }
        return DataFieldIO.deserializeMetaToRaw(metadata);
    }

    private static JsonArray convertToArray(String metadata) throws IOException {
        try {
            JsonElement element = JsonParser.parseString((String)metadata);
            if (!element.isJsonArray()) {
                throw new IOException("Metadata cannot be read as a JSON Array!");
            }
            return element.getAsJsonArray();
        }
        catch (JsonSyntaxException jse) {
            throw new IOException(jse.getMessage(), jse.getCause());
        }
    }

    public static Collection<CustomDataField<?>> deserializeMetaToRaw(String metadata) throws IOException {
        JsonArray array = DataFieldIO.convertToArray(metadata);
        ArrayList cdfList = new ArrayList(array.size());
        for (JsonElement element : array) {
            JsonArray cdfArray;
            if (!element.isJsonArray() || (cdfArray = element.getAsJsonArray()).size() < 3) continue;
            RawDataField rdf = DataFieldIO.deserializeCDFToRaw(cdfArray);
            cdfList.add(rdf);
        }
        return cdfList;
    }

    private static RawDataField deserializeCDFToRaw(JsonArray array) {
        String typeID = array.get(0).getAsString();
        String key = array.get(1).getAsString();
        String value = array.get(2).isJsonNull() ? null : array.get(2).getAsString();
        String label = null;
        if (array.size() == 4 && !array.get(3).isJsonNull()) {
            label = array.get(3).getAsString();
        }
        return new RawDataField(typeID, key, value, label);
    }

    public static Collection<CustomDataField<?>> deserializeLegacyMeta(String metadata) {
        String[] split = metadata.split(";");
        ArrayList cdfList = new ArrayList(split.length);
        for (String cdfStr : split) {
            CustomDataField<?> cdf = DataFieldIO.deserializeLegacyCDF(cdfStr);
            if (cdf == null) continue;
            cdfList.add(cdf);
        }
        return cdfList;
    }

    private static CustomDataField<?> deserializeLegacyCDF(String str) {
        String[] tokens = str.split(",");
        if (tokens.length < 2) {
            return null;
        }
        int typeInt = Integer.parseInt(tokens[0]);
        String key = tokens[1];
        CustomDataField field = null;
        switch (typeInt) {
            case 0: {
                field = new IntegerDataField(key);
                break;
            }
            case 1: {
                field = new StringDataField(key);
                break;
            }
            case 2: {
                field = new BooleanDataField(key);
                break;
            }
            case 3: {
                field = new DecimalDataField(key);
                break;
            }
            case 4: {
                field = new LongDataField(key);
                break;
            }
        }
        if (field.canParseFromString(tokens[2])) {
            field.setValueFromString(tokens[2]);
        }
        String label = tokens[3] == null || tokens[3].equalsIgnoreCase("nil") ? null : tokens[3];
        field.setLabel(label);
        return field;
    }
}

