/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object.metadata;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.event.LoadedMetadataEvent;
import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.bukkit.towny.object.metadata.BooleanDataField;
import com.palmergames.bukkit.towny.object.metadata.ByteDataField;
import com.palmergames.bukkit.towny.object.metadata.CustomDataField;
import com.palmergames.bukkit.towny.object.metadata.DataFieldDeserializer;
import com.palmergames.bukkit.towny.object.metadata.DataFieldIO;
import com.palmergames.bukkit.towny.object.metadata.DecimalDataField;
import com.palmergames.bukkit.towny.object.metadata.IntegerDataField;
import com.palmergames.bukkit.towny.object.metadata.ListDataField;
import com.palmergames.bukkit.towny.object.metadata.LocationDataField;
import com.palmergames.bukkit.towny.object.metadata.LongDataField;
import com.palmergames.bukkit.towny.object.metadata.RawDataField;
import com.palmergames.bukkit.towny.object.metadata.StringDataField;
import com.palmergames.bukkit.towny.object.metadata.TownyCDFDeserializer;
import com.palmergames.bukkit.util.BukkitTools;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class MetadataLoader {
    private static final MetadataLoader INSTANCE = new MetadataLoader();
    private final Map<String, DataFieldDeserializer<?>> deserializerMap = new HashMap();
    private final ArrayList<TownyObject> storedMetadata = new ArrayList();

    public static MetadataLoader getInstance() {
        return INSTANCE;
    }

    private MetadataLoader() {
        this.deserializerMap.put(IntegerDataField.typeID(), TownyCDFDeserializer.INTEGER_DF);
        this.deserializerMap.put(StringDataField.typeID(), TownyCDFDeserializer.STRING_DF);
        this.deserializerMap.put(BooleanDataField.typeID(), TownyCDFDeserializer.BOOLEAN_DF);
        this.deserializerMap.put(DecimalDataField.typeID(), TownyCDFDeserializer.DECIMAL_DF);
        this.deserializerMap.put(LongDataField.typeID(), TownyCDFDeserializer.LONG_DF);
        this.deserializerMap.put(ByteDataField.typeID(), TownyCDFDeserializer.BYTE_DF);
        this.deserializerMap.put(LocationDataField.typeID(), TownyCDFDeserializer.LOCATION_DF);
        this.deserializerMap.put(ListDataField.typeID(), TownyCDFDeserializer.LIST_DF);
    }

    public boolean registerDeserializer(String typeID, DataFieldDeserializer<?> deserializer) {
        if (this.deserializerMap.containsKey(typeID)) {
            return false;
        }
        this.deserializerMap.put(typeID, deserializer);
        return true;
    }

    public void deserializeMetadata(TownyObject object, String serializedMetadata) {
        this.initialDeserialization(object, serializedMetadata);
    }

    /*
     * WARNING - void declaration
     */
    private void initialDeserialization(TownyObject object, String serializedMetadata) {
        if (serializedMetadata == null || serializedMetadata.isEmpty()) {
            return;
        }
        Collection<Object> fields = Collections.emptyList();
        try {
            fields = DataFieldIO.deserializeMeta(serializedMetadata);
        }
        catch (IOException e) {
            Towny.getPlugin().getLogger().log(Level.WARNING, "Error loading metadata for towny object " + object.getClass().getName() + object.getName() + "!", e);
        }
        if (!fields.isEmpty()) {
            boolean hasCustomTypes = false;
            for (CustomDataField customDataField : fields) {
                ListDataField listField;
                void var6_7;
                if (customDataField instanceof RawDataField) {
                    CustomDataField<?> customDataField2 = this.convertRawMetadata((RawDataField)customDataField);
                }
                if (var6_7 == null) continue;
                if (var6_7 instanceof RawDataField || var6_7 instanceof ListDataField && ((List)(listField = (ListDataField)var6_7).getValue()).stream().anyMatch(field -> field instanceof RawDataField)) {
                    hasCustomTypes = true;
                }
                object.addMetaData((CustomDataField<?>)var6_7, false);
            }
            if (hasCustomTypes) {
                this.storedMetadata.add(object);
            }
        }
    }

    public void scheduleDeserialization() {
        Towny.getPlugin().getScheduler().run(this::runDeserialization);
    }

    private void runDeserialization() {
        for (TownyObject tObj : this.storedMetadata) {
            List<CustomDataField<?>> deserializedFields = this.deserializeStoredMeta(tObj.getMetadata());
            for (CustomDataField<?> cdf : deserializedFields) {
                tObj.addMetaData(cdf, false);
            }
        }
        this.storedMetadata.clear();
        this.storedMetadata.trimToSize();
        BukkitTools.fireEvent(new LoadedMetadataEvent());
    }

    private List<CustomDataField<?>> deserializeStoredMeta(Collection<CustomDataField<?>> meta) {
        ArrayList deserializedFields = new ArrayList();
        for (CustomDataField<?> cdf : meta) {
            RawDataField raw;
            CustomDataField<?> convertedCDF;
            if (cdf instanceof ListDataField) {
                ListDataField listField = (ListDataField)cdf;
                try {
                    listField.setValue(this.deserializeStoredMeta((Collection)listField.getValue()));
                }
                catch (StackOverflowError stackOverflowError) {
                    // empty catch block
                }
            }
            if (!(cdf instanceof RawDataField) || (convertedCDF = this.convertRawMetadata(raw = (RawDataField)cdf)) == null || convertedCDF instanceof RawDataField) continue;
            deserializedFields.add(convertedCDF);
        }
        return deserializedFields;
    }

    private CustomDataField<?> convertRawMetadata(RawDataField rdf) {
        String typeID = rdf.getTypeID();
        DataFieldDeserializer<?> deserializer = this.deserializerMap.get(typeID);
        if (deserializer == null) {
            return rdf;
        }
        Object deserializedCDF = deserializer.deserialize(rdf.getKey(), (String)rdf.getValue());
        if (deserializedCDF == null) {
            return null;
        }
        if (rdf.hasLabel()) {
            ((CustomDataField)deserializedCDF).setLabel(rdf.getLabel());
        }
        return deserializedCDF;
    }
}

