/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object.notification;

import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.util.Colors;
import com.palmergames.util.StringMgmt;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class TitleNotification {
    private String titleNotification;
    private String subtitleNotification;
    @Nullable
    private final Town town;
    private final WorldCoord worldCoord;

    public TitleNotification(Town town, WorldCoord worldCoord) {
        this.town = town;
        this.worldCoord = worldCoord;
        this.makeTitles();
    }

    public Town getTown() {
        return this.town;
    }

    public WorldCoord getWorldCoord() {
        return this.worldCoord;
    }

    public String getTitleNotification() {
        return this.titleNotification;
    }

    public void setTitleNotification(String titleNotification) {
        this.titleNotification = Colors.translateColorCodes(titleNotification);
    }

    public String getSubtitleNotification() {
        return this.subtitleNotification;
    }

    public void setSubtitleNotification(String subtitleNotification) {
        this.subtitleNotification = Colors.translateColorCodes(subtitleNotification);
    }

    private void makeTitles() {
        if (this.worldCoord.isWilderness()) {
            this.makeWildernessTitles();
        } else {
            this.makeTownTitles();
        }
    }

    private void makeTownTitles() {
        String title = TownySettings.getNotificationTitlesTownTitle();
        String subtitle = TownySettings.getNotificationTitlesTownSubtitle();
        HashMap<String, Object> placeholders = new HashMap<String, Object>();
        placeholders.put("{townname}", StringMgmt.remUnderscore(TownySettings.isNotificationsTownNamesVerbose() ? this.town.getFormattedName() : this.town.getName()));
        placeholders.put("{town_motd}", this.town.getBoard());
        placeholders.put("{town_residents}", this.town.getNumResidents());
        placeholders.put("{town_residents_online}", TownyAPI.getInstance().getOnlinePlayers(this.town).size());
        Nation nation = this.town.getNationOrNull();
        placeholders.put("{nationname}", nation == null ? "" : String.format(TownySettings.getNotificationTitlesNationNameFormat(), nation.getName()));
        placeholders.put("{nation_residents}", nation == null ? "" : Integer.valueOf(nation.getNumResidents()));
        placeholders.put("{nation_residents_online}", nation == null ? "" : Integer.valueOf(TownyAPI.getInstance().getOnlinePlayers(nation).size()));
        placeholders.put("{nation_motd}", nation == null ? "" : nation.getBoard());
        placeholders.put("{nationcapital}", !this.town.isCapital() ? "" : this.getCapitalSlug(this.town.getName(), nation.getName()));
        for (Map.Entry placeholder : placeholders.entrySet()) {
            title = title.replace((CharSequence)placeholder.getKey(), placeholder.getValue().toString());
            subtitle = subtitle.replace((CharSequence)placeholder.getKey(), placeholder.getValue().toString());
        }
        this.setTitleNotification(title);
        this.setSubtitleNotification(subtitle);
    }

    private void makeWildernessTitles() {
        String wildernessName = this.worldCoord.getTownyWorld().getFormattedUnclaimedZoneName();
        String title = TownySettings.getNotificationTitlesWildTitle();
        String subtitle = TownySettings.getNotificationTitlesWildSubtitle();
        if (title.contains("{wilderness}")) {
            title = title.replace("{wilderness}", wildernessName);
        }
        if (subtitle.contains("{wilderness}")) {
            subtitle = subtitle.replace("{wilderness}", wildernessName);
        }
        if (title.contains("{townname}")) {
            subtitle = subtitle.replace("{townname}", StringMgmt.remUnderscore(this.town.getName()));
        }
        if (subtitle.contains("{townname}")) {
            subtitle = subtitle.replace("{townname}", StringMgmt.remUnderscore(this.town.getName()));
        }
        this.setTitleNotification(title);
        this.setSubtitleNotification(subtitle);
    }

    private Object getCapitalSlug(String townName, String nationName) {
        String format = TownySettings.getNotificationTitlesNationCapitalFormat();
        if (format.contains("%t") || format.contains("%n")) {
            return format.replace("%t", townName).replace("%n", nationName);
        }
        return String.format(format, nationName, townName);
    }
}

