/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object.resident.mode;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.event.ResidentModesInitializeEvent;
import com.palmergames.bukkit.towny.event.resident.ResidentToggleModeEvent;
import com.palmergames.bukkit.towny.exceptions.NoPermissionException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.resident.mode.AbstractResidentMode;
import com.palmergames.bukkit.towny.object.resident.mode.BorderResidentMode;
import com.palmergames.bukkit.towny.object.resident.mode.ClaimingResidentMode;
import com.palmergames.bukkit.towny.object.resident.mode.GenericResidentMode;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.util.StringMgmt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResidentModeHandler {
    private static Map<String, AbstractResidentMode> modes = new ConcurrentHashMap<String, AbstractResidentMode>();
    private static Map<Resident, Set<AbstractResidentMode>> residentModesMap = new ConcurrentHashMap<Resident, Set<AbstractResidentMode>>();

    public static void initialize() {
        modes.clear();
        residentModesMap.clear();
        ResidentModeHandler.addMode(new GenericResidentMode("adminbypass", ""));
        ResidentModeHandler.addMode(new GenericResidentMode("bedspawn", PermissionNodes.TOWNY_COMMAND_RESIDENT_TOGGLE_BEDSPAWN.getNode()));
        ResidentModeHandler.addMode(new GenericResidentMode("bordertitles", PermissionNodes.TOWNY_COMMAND_RESIDENT_TOGGLE_BORDERTITLES.getNode()));
        ResidentModeHandler.addMode(new GenericResidentMode("ignoreinvites", PermissionNodes.TOWNY_COMMAND_RESIDENT_TOGGLE_IGNOREPLOTS.getNode()));
        ResidentModeHandler.addMode(new GenericResidentMode("ignoreotherchannels", PermissionNodes.TOWNY_COMMAND_RESIDENT_TOGGLE_IGNOREOTHERCHANNELS.getNode()));
        ResidentModeHandler.addMode(new GenericResidentMode("ignoreplots", PermissionNodes.TOWNY_COMMAND_RESIDENT_TOGGLE_IGNOREPLOTS.getNode()));
        ResidentModeHandler.addMode(new GenericResidentMode("infotool", PermissionNodes.TOWNY_COMMAND_RESIDENT_TOGGLE_INFOTOOL.getNode()));
        ResidentModeHandler.addMode(new GenericResidentMode("map", PermissionNodes.TOWNY_COMMAND_RESIDENT_TOGGLE_MAP.getNode()));
        ResidentModeHandler.addMode(new GenericResidentMode("plotgroup", PermissionNodes.TOWNY_COMMAND_RESIDENT_TOGGLE_PLOTGROUP.getNode()));
        ResidentModeHandler.addMode(new GenericResidentMode("district", PermissionNodes.TOWNY_COMMAND_RESIDENT_TOGGLE_DISTRICT.getNode()));
        ResidentModeHandler.addMode(new GenericResidentMode("townborder", PermissionNodes.TOWNY_COMMAND_RESIDENT_TOGGLE_TOWNBORDER.getNode()));
        ResidentModeHandler.addMode(new GenericResidentMode("spy", PermissionNodes.TOWNY_CHAT_SPY.getNode()));
        ResidentModeHandler.addMode(new BorderResidentMode("constantplotborder", PermissionNodes.TOWNY_COMMAND_RESIDENT_TOGGLE_CONSTANTPLOTBORDER.getNode()));
        ResidentModeHandler.addMode(new BorderResidentMode("plotborder", PermissionNodes.TOWNY_COMMAND_RESIDENT_TOGGLE_PLOTBORDER.getNode()));
        ResidentModeHandler.addMode(new ClaimingResidentMode("townclaim", PermissionNodes.TOWNY_COMMAND_RESIDENT_TOGGLE_TOWNCLAIM.getNode()));
        ResidentModeHandler.addMode(new ClaimingResidentMode("townunclaim", PermissionNodes.TOWNY_COMMAND_RESIDENT_TOGGLE_TOWNUNCLAIM.getNode()));
        BukkitTools.fireEvent(new ResidentModesInitializeEvent());
    }

    public static void registerMode(@NotNull AbstractResidentMode mode) throws TownyException {
        if (modes.containsKey(mode.name)) {
            throw new TownyException();
        }
        ResidentModeHandler.addMode(mode);
    }

    private static void addMode(AbstractResidentMode mode) {
        if (modes.containsKey(mode.name)) {
            return;
        }
        modes.put(mode.name.toLowerCase(Locale.ROOT), mode);
    }

    public static boolean isValidMode(String name) {
        return modes.containsKey(name);
    }

    public static boolean isValidMode(AbstractResidentMode mode) {
        return modes.containsValue(mode);
    }

    public static List<String> getValidModeNames() {
        return new ArrayList<String>(modes.keySet());
    }

    @Nullable
    public static AbstractResidentMode getMode(String name) {
        return modes.get(name);
    }

    public static Set<AbstractResidentMode> getModes(Player player) {
        try {
            return residentModesMap.getOrDefault(ResidentModeHandler.getResident(player), new HashSet());
        }
        catch (TownyException townyException) {
            return new HashSet<AbstractResidentMode>();
        }
    }

    public static Set<AbstractResidentMode> getModes(Resident resident) {
        return residentModesMap.getOrDefault(resident, new HashSet());
    }

    public static boolean hasMode(Resident resident, String name) {
        return ResidentModeHandler.isValidMode(name) && ResidentModeHandler.hasMode(resident, ResidentModeHandler.getMode(name));
    }

    public static boolean hasMode(Resident resident, AbstractResidentMode mode) {
        return ResidentModeHandler.isValidMode(mode) && residentModesMap.containsKey(resident) && residentModesMap.get(resident).contains(mode);
    }

    public static void toggleModes(Player player, String[] names, boolean notify) throws TownyException {
        ResidentModeHandler.toggleModes(ResidentModeHandler.getResident(player), names, notify, false);
    }

    public static void toggleModes(Resident resident, String[] names, boolean notify, boolean clearModes) {
        if (clearModes) {
            ResidentModeHandler.clearModes(resident, false);
        }
        for (String mode : names) {
            try {
                ResidentModeHandler.toggleMode(resident, mode, false);
            }
            catch (TownyException e) {
                if (!resident.isOnline()) continue;
                TownyMessaging.sendErrorMsg(resident.getPlayer(), e.getMessage((CommandSender)resident.getPlayer()));
            }
        }
        if (notify && !ResidentModeHandler.getModes(resident).isEmpty()) {
            TownyMessaging.sendMsg(resident, Translatable.of("msg_modes_set").append(StringMgmt.join(ResidentModeHandler.getResidentModesNames(resident), ", ")));
        }
    }

    public static void toggleMode(Player player, String name, boolean notify) throws TownyException {
        ResidentModeHandler.toggleMode(ResidentModeHandler.getResident(player), name, notify);
    }

    public static void toggleMode(Resident resident, String name, boolean notify) throws TownyException {
        if (!ResidentModeHandler.isValidMode(name)) {
            throw new TownyException(Translatable.of("msg_err_mode_does_not_exist", name));
        }
        ResidentModeHandler.toggleMode(resident, ResidentModeHandler.getMode(name), notify);
    }

    public static void toggleMode(Resident resident, AbstractResidentMode mode, boolean notify) throws TownyException {
        if (!ResidentModeHandler.isValidMode(mode)) {
            throw new TownyException(Translatable.of("msg_err_mode_does_not_exist", mode.name));
        }
        if (!mode.permissionNode.isEmpty() && !resident.hasPermissionNode(mode.permissionNode) && ResidentModeHandler.isNotBecauseOfDefaultModes(resident, mode.name)) {
            throw new NoPermissionException();
        }
        BukkitTools.ifCancelledThenThrow(new ResidentToggleModeEvent(resident, mode.name));
        mode.toggle(resident);
        if (notify) {
            TownyMessaging.sendMsg(resident, Translatable.of("msg_modes_set").append(StringMgmt.join(ResidentModeHandler.getResidentModesNames(resident), ", ")));
        }
    }

    private static boolean isNotBecauseOfDefaultModes(Resident resident, String name) {
        List<String> defaultModes = Stream.of(ResidentModeHandler.getDefaultModes(resident).split(",")).collect(Collectors.toList());
        return !StringMgmt.containsIgnoreCase(defaultModes, name);
    }

    public static void clearModes(Player player) {
        try {
            ResidentModeHandler.clearModes(ResidentModeHandler.getResident(player), false);
        }
        catch (TownyException townyException) {
            // empty catch block
        }
    }

    public static void clearModes(Resident resident, boolean notify) {
        if (!residentModesMap.containsKey(resident)) {
            return;
        }
        residentModesMap.get(resident).clear();
        if (notify) {
            TownyMessaging.sendMsg(resident, Translatable.of("msg_modes_set"));
        }
    }

    public static void resetModes(Resident resident, boolean notify) {
        if (residentModesMap.containsKey(resident)) {
            residentModesMap.get(resident).clear();
        }
        Towny.getPlugin().getScheduler().runAsyncLater(() -> ResidentModeHandler.applyDefaultModes(resident, notify), 1L);
    }

    public static void applyDefaultModes(Resident resident, boolean notify) {
        if (resident == null || !resident.isOnline()) {
            return;
        }
        try {
            String modeString = ResidentModeHandler.getDefaultModes(resident);
            if (modeString.isEmpty()) {
                return;
            }
            ResidentModeHandler.toggleModes(resident, modeString.split(","), notify, true);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    protected static void addMode(Resident resident, AbstractResidentMode mode) {
        if (!residentModesMap.containsKey(resident)) {
            residentModesMap.put(resident, new HashSet<AbstractResidentMode>(Arrays.asList(mode)));
            return;
        }
        Set<AbstractResidentMode> modes = residentModesMap.get(resident);
        modes.add(mode);
        residentModesMap.put(resident, modes);
    }

    protected static void removeMode(Resident resident, AbstractResidentMode mode) {
        if (!residentModesMap.containsKey(resident) || !residentModesMap.get(resident).contains(mode)) {
            return;
        }
        Set<AbstractResidentMode> modes = residentModesMap.get(resident);
        modes.remove(mode);
        residentModesMap.put(resident, modes);
    }

    public static List<String> getResidentModesNames(Resident resident) {
        if (!residentModesMap.containsKey(resident)) {
            return new ArrayList<String>();
        }
        return residentModesMap.get(resident).stream().map(AbstractResidentMode::name).collect(Collectors.toUnmodifiableList());
    }

    protected static Set<AbstractResidentMode> getResidentModes(Resident resident) {
        return residentModesMap.getOrDefault(resident, new HashSet());
    }

    private static Resident getResident(Player player) throws TownyException {
        Resident resident = TownyUniverse.getInstance().getResident(player.getUniqueId());
        if (resident == null) {
            throw new TownyException(String.format("The player with the name '%s' is not registered!", player.getName()));
        }
        return resident;
    }

    private static String getDefaultModes(Resident resident) {
        return TownyUniverse.getInstance().getPermissionSource().getPlayerPermissionStringNode(resident.getName(), PermissionNodes.TOWNY_DEFAULT_MODES.getNode());
    }
}

