/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object.statusscreens;

import com.palmergames.bukkit.towny.utils.TownyComponents;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.Nullable;

public class StatusScreen {
    private static final int GUARANTEED_NO_WRAP_CHAT_WIDTH = 55;
    private final Map<String, Component> components = new LinkedHashMap<String, Component>();
    private final CommandSender sender;

    public StatusScreen(CommandSender sender) {
        this.sender = sender;
    }

    public CommandSender getCommandSender() {
        return this.sender;
    }

    public void addComponentOf(String name, String text) {
        this.components.put(name, TownyComponents.miniMessage(text));
    }

    public void addComponentOf(String name, Component component) {
        this.components.put(name, component);
    }

    public void addComponentOf(String name, String text, ClickEvent click) {
        this.components.put(name, TownyComponents.miniMessage(text).clickEvent(click));
    }

    public void addComponentOf(String name, String text, HoverEvent<?> hover) {
        this.components.put(name, TownyComponents.miniMessage(text).hoverEvent(hover));
    }

    public void addComponentOf(String name, String text, HoverEvent<?> hover, ClickEvent click) {
        this.components.put(name, TownyComponents.miniMessage(text).hoverEvent(hover).clickEvent(click));
    }

    public void removeStatusComponent(String name) {
        this.components.remove(name);
    }

    public Collection<String> getComponentKeys() {
        return Collections.unmodifiableCollection(this.components.keySet());
    }

    public Collection<Component> getComponents() {
        return Collections.unmodifiableCollection(this.components.values());
    }

    public boolean hasComponent(String name) {
        return this.components.containsKey(name);
    }

    @Nullable
    public Component getComponentOrNull(String name) {
        return this.components.get(name);
    }

    public boolean replaceComponent(String name, Component replacement) {
        return this.components.replace(name, replacement) != null;
    }

    public Component getFormattedStatusScreen() {
        TextComponent screen = Component.empty();
        TextComponent currentLine = Component.empty();
        ArrayList<Component> components = new ArrayList<Component>(this.components.values());
        for (Component nextComp : components) {
            if (nextComp.equals((Object)Component.newline())) {
                if (!currentLine.equals((Object)Component.empty())) {
                    screen = screen.append((Component)currentLine);
                }
                screen = screen.append((Component)Component.newline());
                currentLine = Component.empty();
                continue;
            }
            if (currentLine.equals((Object)Component.empty())) {
                currentLine = nextComp;
                continue;
            }
            if (this.lineWouldBeTooLong((Component)currentLine, nextComp)) {
                screen = screen.append((Component)currentLine).append((Component)Component.newline());
                currentLine = nextComp;
                continue;
            }
            currentLine = ((TextComponent)((TextComponent)Component.empty().append((Component)currentLine)).append((Component)Component.space())).append(nextComp);
        }
        if (!currentLine.equals((Object)Component.empty())) {
            screen = screen.append((Component)currentLine);
        }
        return screen;
    }

    private boolean lineWouldBeTooLong(Component line, Component comp) {
        return TownyComponents.plain(line).length() + TownyComponents.plain(comp).length() > 55;
    }
}

