/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.permissions;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.permissions.TownyPermissionSource;
import com.palmergames.bukkit.util.Colors;
import java.util.Locale;
import java.util.UUID;
import net.kyori.adventure.util.TriState;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.cacheddata.CachedMetaData;
import net.luckperms.api.model.group.Group;
import net.luckperms.api.model.user.User;
import net.luckperms.api.platform.PlayerAdapter;
import net.luckperms.api.query.QueryOptions;
import net.luckperms.api.util.Tristate;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.Nullable;

public class LuckPermsSource
extends TownyPermissionSource {
    private final Towny plugin;
    private final LuckPerms luckPerms;
    private final PlayerAdapter<Player> adapter;

    public LuckPermsSource(Towny plugin) {
        this.plugin = plugin;
        this.luckPerms = LuckPermsProvider.get();
        this.adapter = this.luckPerms.getPlayerAdapter(Player.class);
    }

    @Override
    public String getPrefixSuffix(Resident resident, String node) {
        Group primaryGroup;
        User user = this.lookupUser(resident.getName(), resident.getUUID());
        if (user == null) {
            return "";
        }
        QueryOptions queryOptions = this.luckPerms.getContextManager().getStaticQueryOptions();
        Player player = resident.getPlayer();
        if (player != null) {
            queryOptions = this.luckPerms.getContextManager().getQueryOptions((Object)player);
        }
        CachedMetaData groupMetadata = (primaryGroup = this.luckPerms.getGroupManager().getGroup(this.getPlayerGroup(player))) == null ? null : primaryGroup.getCachedData().getMetaData();
        CachedMetaData playerMetadata = user.getCachedData().getMetaData(queryOptions);
        String groupPrefixSuffix = "";
        String playerPrefixSuffix = "";
        switch (node.toLowerCase(Locale.ROOT)) {
            case "prefix": {
                if (groupMetadata != null) {
                    groupPrefixSuffix = groupMetadata.getSuffix();
                }
                playerPrefixSuffix = playerMetadata.getPrefix();
                break;
            }
            case "suffix": {
                if (primaryGroup != null) {
                    groupPrefixSuffix = groupMetadata.getSuffix();
                }
                playerPrefixSuffix = playerMetadata.getSuffix();
                break;
            }
            case "userprefix": {
                playerPrefixSuffix = playerMetadata.getPrefix();
                break;
            }
            case "usersuffix": {
                playerPrefixSuffix = playerMetadata.getSuffix();
                break;
            }
            case "groupprefix": {
                groupPrefixSuffix = groupMetadata != null ? groupMetadata.getPrefix() : "";
                break;
            }
            case "groupsuffix": {
                String string = groupPrefixSuffix = groupMetadata != null ? groupMetadata.getSuffix() : "";
            }
        }
        if (groupPrefixSuffix == null) {
            groupPrefixSuffix = "";
        }
        if (playerPrefixSuffix == null) {
            playerPrefixSuffix = "";
        }
        Object prefixSuffix = playerPrefixSuffix;
        if (!playerPrefixSuffix.equals(groupPrefixSuffix)) {
            prefixSuffix = groupPrefixSuffix + playerPrefixSuffix;
        }
        return Colors.translateColorCodes((String)prefixSuffix);
    }

    @Override
    public int getGroupPermissionIntNode(String playerName, String node) {
        User user = this.lookupUser(playerName, null);
        if (user == null) {
            return -1;
        }
        int value = -1;
        Group group = this.luckPerms.getGroupManager().getGroup(user.getPrimaryGroup());
        if (group != null) {
            String metadata = group.getCachedData().getMetaData().getMetaValue(node);
            value = this.parseInt(metadata);
        }
        if (value == -1) {
            value = this.getPlayerPermissionIntNode(playerName, node);
        }
        return value;
    }

    @Override
    public String getPlayerGroup(Player player) {
        return this.adapter.getUser((Object)player).getPrimaryGroup();
    }

    @Override
    public int getPlayerPermissionIntNode(String playerName, String node) {
        return this.parseInt(this.getPlayerPermissionStringNode(playerName, node));
    }

    @Override
    public String getPlayerPermissionStringNode(String playerName, String node) {
        User user;
        QueryOptions queryOptions = this.luckPerms.getContextManager().getStaticQueryOptions();
        Player player = this.plugin.getServer().getPlayerExact(playerName);
        if (player != null) {
            user = this.adapter.getUser((Object)player);
            queryOptions = this.luckPerms.getContextManager().getQueryOptions((Object)player);
        } else {
            user = this.lookupUser(playerName, null);
        }
        if (user == null) {
            return "";
        }
        String result = user.getCachedData().getMetaData(queryOptions).getMetaValue(node);
        return result != null ? result : "";
    }

    @Override
    public TriState strictHas(Permissible permissible, String node) {
        if (!(permissible instanceof Player)) {
            return super.strictHas(permissible, node);
        }
        Player player = (Player)permissible;
        return this.convertTriState(this.adapter.getUser((Object)player).getCachedData().getPermissionData(this.luckPerms.getContextManager().getQueryOptions((Object)player)).checkPermission(node));
    }

    @Nullable
    private User lookupUser(String playerName, @Nullable UUID uuid) {
        if (playerName == null) {
            return null;
        }
        Player player = this.plugin.getServer().getPlayerExact(playerName);
        if (player != null) {
            return this.adapter.getUser((Object)player);
        }
        if (uuid == null) {
            uuid = (UUID)this.luckPerms.getUserManager().lookupUniqueId(playerName).join();
        }
        if (uuid == null) {
            return null;
        }
        return (User)this.luckPerms.getUserManager().loadUser(uuid, playerName).join();
    }

    private TriState convertTriState(Tristate tristate) {
        return switch (tristate) {
            default -> throw new IncompatibleClassChangeError();
            case Tristate.TRUE -> TriState.TRUE;
            case Tristate.FALSE -> TriState.FALSE;
            case Tristate.UNDEFINED -> TriState.NOT_SET;
        };
    }

    private int parseInt(String string) {
        if (string == null) {
            return -1;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }
}

