/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.permissions;

import com.palmergames.bukkit.config.CommentedConfiguration;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.exceptions.initialization.TownyInitException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.util.JavaUtil;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.bukkit.configuration.MemorySection;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TownyPerms {
    protected static final LinkedHashMap<String, Permission> registeredPermissions = new LinkedHashMap();
    protected static final Map<String, PermissionAttachment> attachments = new ConcurrentHashMap<String, PermissionAttachment>();
    private static final HashMap<String, List<String>> groupPermsMap = new HashMap();
    private static CommentedConfiguration perms;
    private static Towny plugin;
    private static final List<String> vitalGroups;
    private static final HashMap<UUID, String> residentPrefixMap;
    private static final String RANKPRIORITY_PREFIX = "towny.rankpriority.";
    private static final String RANKPREFIX_PREFIX = "towny.rankprefix.";
    private static final String RANK_TOWN_LEVEL_REQUIREMENT_PREFIX = "towny.town_level_requirement.";
    private static final String RANK_NATION_LEVEL_REQUIREMENT_PREFIX = "towny.nation_level_requirement.";
    private static boolean ranksWithTownLevelRequirementPresent;
    private static boolean ranksWithNationLevelRequirementPresent;
    private static final MethodHandle PERMISSIONS;

    public static void initialize(Towny plugin) {
        TownyPerms.plugin = plugin;
    }

    public static void loadPerms(@NotNull Path permsYMLPath) {
        try {
            InputStream resource = Towny.class.getResourceAsStream("/townyperms.yml");
            if (resource == null) {
                throw new TownyInitException("Could not find 'townyperms.yml' in the JAR.", TownyInitException.TownyError.PERMISSIONS);
            }
            Files.copy(resource, permsYMLPath, new CopyOption[0]);
        }
        catch (FileAlreadyExistsException resource) {
        }
        catch (IOException e) {
            throw new TownyInitException("Could not copy townyperms.yml from JAR to '" + String.valueOf(permsYMLPath) + "'.", TownyInitException.TownyError.PERMISSIONS, e);
        }
        perms = new CommentedConfiguration(permsYMLPath);
        if (!perms.load()) {
            throw new TownyInitException("Could not read townyperms.yml", TownyInitException.TownyError.PERMISSIONS);
        }
        groupPermsMap.clear();
        TownyPerms.buildGroupPermsMap();
        TownyPerms.checkForVitalGroups();
        TownyPerms.buildComments();
        perms.save();
        TownyPerms.collectPermissions();
        TownyPerms.checkForLevelRequirementPerms();
    }

    private static void checkForVitalGroups() {
        for (String group : vitalGroups) {
            if (groupPermsMap.containsKey(group)) continue;
            throw new TownyInitException(TownyPerms.getErrorMessageForGroup(group), TownyInitException.TownyError.PERMISSIONS);
        }
    }

    @NotNull
    private static String getErrorMessageForGroup(String group) {
        if (!group.contains(".")) {
            return "Your townyperms.yml is missing the " + group + " group. Maybe you renamed it?";
        }
        String[] split = group.split("\\.");
        return "Your townyperms.yml's " + split[0] + " section is missing the " + split[1] + " group. Maybe you renamed it?";
    }

    public static void assignPermissions(Resident resident, Player player) {
        if (resident == null) {
            if (player != null) {
                resident = TownyAPI.getInstance().getResident(player);
            }
            if (resident == null) {
                return;
            }
        } else {
            player = resident.getPlayer();
        }
        if (player == null || !player.isOnline()) {
            attachments.remove(resident.getName());
            return;
        }
        TownyWorld world = TownyAPI.getInstance().getTownyWorld(player.getWorld());
        if (world == null) {
            return;
        }
        Player finalPlayer = player;
        PermissionAttachment attachment = attachments.computeIfAbsent(resident.getName(), k -> finalPlayer.addAttachment((Plugin)plugin));
        try {
            Map orig = PERMISSIONS.invokeExact(attachment);
            orig.clear();
            if (world.isUsingTowny()) {
                orig.putAll(TownyPerms.getResidentPerms(resident));
            }
            player.recalculatePermissions();
        }
        catch (Throwable e) {
            plugin.getLogger().log(Level.WARNING, "exception occurred while assigning permissions to player " + player.getName(), e);
        }
        attachments.put(resident.getName(), attachment);
        TownyPerms.setResidentPrimaryRankPrefix(resident);
    }

    public static void removeAttachment(String name) {
        attachments.remove(name);
    }

    public static void updateOnlinePerms() {
        for (Player player : BukkitTools.getOnlinePlayers()) {
            TownyPerms.assignPermissions(null, player);
        }
    }

    public static void updateTownPerms(Town town) {
        for (Resident resident : town.getResidents()) {
            TownyPerms.assignPermissions(resident, null);
        }
    }

    public static void updateNationPerms(Nation nation) {
        for (Town town : nation.getTowns()) {
            TownyPerms.updateTownPerms(town);
        }
    }

    private static List<String> getList(String path) {
        if (perms.contains(path)) {
            return perms.getStringList(path);
        }
        return new ArrayList<String>();
    }

    public static LinkedHashMap<String, Boolean> getResidentPerms(Resident resident) {
        HashSet<String> permList = new HashSet<String>(TownyPerms.getDefault());
        Town town = resident.getTownOrNull();
        if (town != null) {
            permList.addAll(TownyPerms.getTownDefault(town.getName().toLowerCase(Locale.ROOT)));
            if (resident.isMayor()) {
                permList.addAll(TownyPerms.getTownMayor());
            }
            for (String string : resident.getTownRanks()) {
                permList.addAll(TownyPerms.getTownRankPermissions(string));
            }
            Nation nation = town.getNationOrNull();
            if (nation != null) {
                permList.addAll(TownyPerms.getNationDefault(nation.getName().toLowerCase(Locale.ROOT)));
                if (resident.isKing()) {
                    permList.addAll(TownyPerms.getNationKing());
                }
                for (String rank : resident.getNationRanks()) {
                    permList.addAll(TownyPerms.getNationRankPermissions(rank));
                }
            } else {
                permList.add("towny.nationless");
            }
            if (TownyPerms.isPeaceful(town)) {
                permList.addAll(TownyPerms.getList("peaceful"));
            }
            if (town.isConquered()) {
                permList.addAll(TownyPerms.getList("conquered"));
            } else {
                permList.addAll(TownyPerms.getList("unconquered"));
            }
        } else {
            permList.add("towny.townless");
            permList.add("towny.nationless");
        }
        List<String> playerPermArray = TownyPerms.sort(permList);
        LinkedHashMap<String, Boolean> linkedHashMap = new LinkedHashMap<String, Boolean>();
        for (String permission : playerPermArray) {
            if (permission.contains("{townname}") && resident.getTownOrNull() != null) {
                permission = permission.replace("{townname}", resident.getTownOrNull().getName().toLowerCase(Locale.ROOT));
            }
            if (permission.contains("{nationname}") && resident.getNationOrNull() != null) {
                permission = permission.replace("{nationname}", resident.getNationOrNull().getName().toLowerCase(Locale.ROOT));
            }
            boolean value = !permission.startsWith("-");
            linkedHashMap.put(value ? permission : permission.substring(1), value);
        }
        return linkedHashMap;
    }

    public static void registerPermissionNodes() {
        plugin.getScheduler().runLater(() -> {
            Permission perm;
            for (String rank : TownyPerms.getTownRanks()) {
                perm = new Permission(PermissionNodes.TOWNY_COMMAND_TOWN_RANK.getNode(rank), "User can grant this town rank to others..", PermissionDefault.FALSE, null);
                perm.addParent(PermissionNodes.TOWNY_COMMAND_TOWN_RANK.getNode(), true);
            }
            for (String rank : TownyPerms.getNationRanks()) {
                perm = new Permission(PermissionNodes.TOWNY_COMMAND_NATION_RANK.getNode(rank), "User can grant this nation rank to others..", PermissionDefault.FALSE, null);
                perm.addParent(PermissionNodes.TOWNY_COMMAND_NATION_RANK.getNode(), true);
            }
        }, 1L);
    }

    public static List<String> getDefault() {
        return TownyPerms.getList("nomad");
    }

    public static List<String> getTownRanks() {
        return new ArrayList<String>(((MemorySection)perms.get("towns.ranks")).getKeys(false));
    }

    public static List<String> getTownRanks(Town town) {
        if (!TownyPerms.ranksWithTownLevelRequirementPresent()) {
            return TownyPerms.getTownRanks();
        }
        int level = town.getLevelNumber();
        return TownyPerms.getTownRanks().stream().filter(rank -> TownyPerms.getRankTownLevelReq(rank) <= level).collect(Collectors.toList());
    }

    public static List<String> getTownDefault(String townName) {
        List<String> permsList = TownyPerms.getList("towns.default");
        permsList.add("towny.town." + townName);
        return permsList;
    }

    public static List<String> getTownMayor() {
        return TownyPerms.getList("towns.mayor");
    }

    public static List<String> getTownRankPermissions(String rank) {
        return TownyPerms.getList("towns.ranks." + rank);
    }

    public static List<String> getNationRanks() {
        return new ArrayList<String>(((MemorySection)perms.get("nations.ranks")).getKeys(false));
    }

    public static List<String> getNationRanks(Nation nation) {
        if (!TownyPerms.ranksWithNationLevelRequirementPresent()) {
            return TownyPerms.getNationRanks();
        }
        int level = nation.getLevelNumber();
        return TownyPerms.getNationRanks().stream().filter(rank -> TownyPerms.getRankNationLevelReq(rank) <= level).collect(Collectors.toList());
    }

    public static List<String> getNationDefault(String nationName) {
        List<String> permsList = TownyPerms.getList("nations.default");
        permsList.add("towny.nation." + nationName);
        return permsList;
    }

    public static List<String> getNationKing() {
        return TownyPerms.getList("nations.king");
    }

    public static List<String> getNationRankPermissions(String rank) {
        return TownyPerms.getList("nations.ranks." + rank);
    }

    @Nullable
    public static String matchNationRank(String rank) {
        for (String nationRank : TownyPerms.getNationRanks()) {
            if (!nationRank.equalsIgnoreCase(rank)) continue;
            return nationRank;
        }
        return null;
    }

    @Nullable
    public static String matchTownRank(String rank) {
        for (String townRank : TownyPerms.getTownRanks()) {
            if (!townRank.equalsIgnoreCase(rank)) continue;
            return townRank;
        }
        return null;
    }

    private static boolean isPeaceful(Town town) {
        return town.isNeutral() || town.hasNation() && town.getNationOrNull().isNeutral();
    }

    public static boolean hasPeacefulNodes() {
        return !TownyPerms.getList("peaceful").isEmpty();
    }

    public static boolean hasConqueredNodes() {
        return !TownyPerms.getList("conquered").isEmpty() || !TownyPerms.getList("unconquered").isEmpty();
    }

    public static String getResidentPrimaryRankPrefix(Resident resident) {
        return residentPrefixMap.getOrDefault(resident.getUUID(), TownyPerms.setResidentPrimaryRankPrefix(resident));
    }

    private static String setResidentPrimaryRankPrefix(Resident resident) {
        String prefix = TownyPerms.getPrimaryRankPrefix(resident);
        residentPrefixMap.put(resident.getUUID(), prefix);
        return prefix;
    }

    private static String getPrimaryRankPrefix(Resident resident) {
        String prefix = TownyPerms.getHighestPriorityRankPrefix(resident);
        return prefix == null ? "" : prefix;
    }

    @Nullable
    private static String getHighestPriorityRankPrefix(Resident resident) {
        String rank;
        String prefix;
        if (resident.hasNation() && !resident.getNationRanks().isEmpty() && (prefix = TownyPerms.getPrefixFromRank(TownyPerms.getNationRankPermissions(rank = TownyPerms.getHighestPriorityRank(resident, resident.getNationRanks(), r -> TownyPerms.getNationRankPermissions(r))))) != null) {
            return prefix;
        }
        if (resident.hasTown() && !resident.getTownRanks().isEmpty() && (prefix = TownyPerms.getPrefixFromRank(TownyPerms.getTownRankPermissions(rank = TownyPerms.getHighestPriorityRank(resident, resident.getTownRanks(), r -> TownyPerms.getTownRankPermissions(r))))) != null) {
            return prefix;
        }
        return null;
    }

    private static String getPrefixFromRank(List<String> nodes) {
        for (String node : nodes) {
            if (!node.startsWith(RANKPREFIX_PREFIX)) continue;
            return node.substring(RANKPREFIX_PREFIX.length());
        }
        return null;
    }

    public static String getHighestPriorityRank(Resident resident, List<String> ranks, Function<String, List<String>> rankFunction) {
        HashMap<String, Integer> rankPriorityMap = new HashMap<String, Integer>();
        for (String rank : ranks) {
            rankPriorityMap.put(rank, TownyPerms.getRankPriority(rankFunction.apply(rank)));
        }
        return (String)Collections.max(rankPriorityMap.entrySet(), Comparator.comparingInt(Map.Entry::getValue)).getKey();
    }

    private static int getRankPriority(List<String> nodes) {
        int topValue = 0;
        for (String node : nodes) {
            int priorityValue;
            if (!node.startsWith(RANKPRIORITY_PREFIX) || topValue >= (priorityValue = TownyPerms.getNodePriority(node, RANKPRIORITY_PREFIX.length()))) continue;
            topValue = priorityValue;
        }
        return topValue;
    }

    private static int getNodePriority(String node, int length) {
        try {
            return Integer.parseInt(node.substring(length));
        }
        catch (NumberFormatException ignored) {
            return 0;
        }
    }

    private static void checkForLevelRequirementPerms() {
        ranksWithNationLevelRequirementPresent = TownyPerms.getNationRanks().stream().anyMatch(rank -> TownyPerms.getNationRankPermissions(rank).stream().anyMatch(node -> node.startsWith(RANK_NATION_LEVEL_REQUIREMENT_PREFIX)));
        ranksWithTownLevelRequirementPresent = TownyPerms.getTownRanks().stream().anyMatch(rank -> TownyPerms.getTownRankPermissions(rank).stream().anyMatch(node -> node.startsWith(RANK_TOWN_LEVEL_REQUIREMENT_PREFIX)));
    }

    public static int getRankTownLevelReq(String rank) {
        for (String node : TownyPerms.getTownRankPermissions(rank)) {
            if (!node.startsWith(RANK_TOWN_LEVEL_REQUIREMENT_PREFIX)) continue;
            return TownyPerms.getNodePriority(node, RANK_TOWN_LEVEL_REQUIREMENT_PREFIX.length());
        }
        return 0;
    }

    public static int getRankNationLevelReq(String rank) {
        for (String node : TownyPerms.getNationRankPermissions(rank)) {
            if (!node.startsWith(RANK_NATION_LEVEL_REQUIREMENT_PREFIX)) continue;
            return TownyPerms.getNodePriority(node, RANK_NATION_LEVEL_REQUIREMENT_PREFIX.length());
        }
        return 0;
    }

    public static boolean ranksWithTownLevelRequirementPresent() {
        return ranksWithTownLevelRequirementPresent;
    }

    public static boolean ranksWithNationLevelRequirementPresent() {
        return ranksWithNationLevelRequirementPresent;
    }

    public static void collectPermissions() {
        registeredPermissions.clear();
        for (Permission perm : BukkitTools.getPluginManager().getPermissions()) {
            registeredPermissions.put(perm.getName().toLowerCase(Locale.ROOT), perm);
        }
    }

    private static List<String> sort(Iterable<String> permList) {
        ArrayList<String> result = new ArrayList<String>();
        for (String key : permList) {
            String a = key.charAt(0) == '-' ? key.substring(1) : key;
            Map<String, Boolean> allchildren = TownyPerms.getAllChildren(a, new HashSet<String>());
            if (allchildren != null) {
                ListIterator<String> itr = result.listIterator();
                while (itr.hasNext()) {
                    String node = (String)itr.next();
                    String b = node.charAt(0) == '-' ? node.substring(1) : node;
                    if (!allchildren.containsKey(b)) continue;
                    itr.set(key);
                    itr.add(node);
                    break;
                }
            }
            if (result.contains(key)) continue;
            result.add(key);
        }
        return result;
    }

    public List<String> getAllRegisteredPermissions(boolean includeChildren) {
        ArrayList<String> perms = new ArrayList<String>();
        for (String key : registeredPermissions.keySet()) {
            Map<String, Boolean> children;
            if (perms.contains(key)) continue;
            perms.add(key);
            if (!includeChildren || (children = TownyPerms.getAllChildren(key, new HashSet<String>())) == null) continue;
            for (String node : children.keySet()) {
                if (perms.contains(node)) continue;
                perms.add(node);
            }
        }
        return perms;
    }

    public static Map<String, Boolean> getAllChildren(String node, Set<String> playerPermArray) {
        LinkedList<String> stack = new LinkedList<String>();
        HashMap<String, Boolean> alreadyVisited = new HashMap<String, Boolean>();
        stack.push(node);
        alreadyVisited.put(node, true);
        while (!stack.isEmpty()) {
            String now = (String)stack.pop();
            Map<String, Boolean> children = TownyPerms.getChildren(now);
            if (children == null || playerPermArray.contains("-" + now)) continue;
            for (String childName : children.keySet()) {
                if (alreadyVisited.containsKey(childName)) continue;
                stack.push(childName);
                alreadyVisited.put(childName, children.get(childName));
            }
        }
        alreadyVisited.remove(node);
        if (!alreadyVisited.isEmpty()) {
            return alreadyVisited;
        }
        return null;
    }

    public static Map<String, Boolean> getChildren(String node) {
        Permission perm = registeredPermissions.get(node.toLowerCase(Locale.ROOT));
        if (perm == null) {
            return null;
        }
        return perm.getChildren();
    }

    public static List<String> getGroupList() {
        return new ArrayList<String>(groupPermsMap.keySet());
    }

    public static boolean mapHasGroup(String group) {
        return groupPermsMap.containsKey(group);
    }

    public static List<String> getPermsOfGroup(String group) {
        return TownyPerms.mapHasGroup(group) ? (groupPermsMap.get(group) != null ? groupPermsMap.get(group) : new ArrayList()) : new ArrayList();
    }

    private static void buildGroupPermsMap() {
        perms.getKeys(true).forEach(key -> groupPermsMap.put((String)key, perms.getStringList((String)key)));
    }

    private static void buildComments() {
        perms.addComment("nomad", "#############################################################################################", "# This file contains custom permission sets which will be assigned to your players          #", "# depending on their current status. This file uses YAML formatting. Do not include tabs    #", "# and be very careful to align the spacing preceding the - symbols. Improperly editing this #", "# file will prevent Towny from loading correctly.                                           #", "#                                                                                           #", "# This is all managed by towny and pushed directly to CraftBukkit's SuperPerms.             #", "# These will be give in addition to any you manually assign in your specific permission     #", "# plugin. Note: You do not need to assign any Towny permission nodes to your players in     #", "# your server's permission plugin, ie: LuckPerms.                                           #", "#                                                                                           #", "# You may assign any Permission nodes here, including those from other plugins.             #", "#                                                                                           #", "# You may also create any custom ranks you require. Creating ranks can be done using the    #", "# /ta townyperms townrank addrank [name] or by carefully editing this file.                 #", "# You can add permission to a rank/group using the                                          #", "# /ta townyperms group [name] addperm [node] command.                                       #", "#                                                                                           #", "# You may change the names of any of the ranks except: nomad, default, mayor, king, ranks,  #", "# peaceful, conquered, unconquered.                                                         #", "#                                                                                           #", "# If you want to, you can negate permissions nodes from nodes by doing the following:       #", "# Ex:                                                                                       #", "#    - towny.command.plot.*                                                                 #", "#    - -towny.command.plot.set.jail                                                         #", "# In this example the user is given full rights to all of the /plot command nodes,          #", "# but has had their ability to set a plot to a Jail plot type disabled.                     #", "#                                                                                           #", "# The towns.ranks and nations.ranks sections support adding prefix and priorities, this     #", "# is done using two nodes: towny.rankpriority.# and towny.rankprefix.<prefix_here>.         #", "# Residents will have their ranks parsed until one rank is determined to be the highest     #", "# priority, this rank will then be searched for a prefix node. This prefix can be shown     #", "# using the %townyadvanced_resident_primary_rank% placeholder for PlaceholderAPI. A prefix  #", "# from a Nation rank will take precendence over a prefix from a Town rank.                  #", "# Ex:                                                                                       #", "#    - towny.rankpriority.100                                                               #", "#    - towny.rankprefix.&a<&2Sheriff&a>                                                     #", "#                                                                                           #", "# The towns.ranks and nations.ranks sections support requiring their town or nation to have #", "# a minimum town_level or nation_level. This means that you can lock ranks behind a town or #", "# nation's population. By adding a permission node to a rank you will set this requirement: #", "# You can read about town_levels and nation_levels here: https://tinyurl.com/3e9ahk2m       #", "# Ex:                                                                                       #", "#    - towny.town_level_requirement.4                                                       #", "# Adding this to a town rank will require the Town to have a town_level of 4 or more to be  #", "# able to assign that rank to their residents. If the town lost population the residents    #", "# with a rank beyond their town's town_level will have that rank removed from them. When    #", "# their town regains enough population, that rank will automatically be re-assigned to the  #", "# resident. When a town rank does not contain this node it will have no town_level          #", "# requirement.                                                                              #", "# Likewise, nation ranks support an optional nation_level requirement, Ex:                  #", "#    - towny.nation_level_requirement.4                                                     #", "# When added to a nation rank this rank will only be granted when a nation is of level 4 or #", "# greater. When a nation rank does not include this node it will not require any            #", "# nation_level.                                                                             #", "#                                                                                           #", "#############################################################################################", "", "", "# The 'nomad' permissions are given to all players in all Towny worlds, townless and players who are part of a town.");
        perms.addComment("towns", "", "# This section of permissions covers players who are members of a town.");
        perms.addComment("towns.default", "", "# 'default' is the permission set which is auto assigned to any normal town member.");
        perms.addComment("towns.mayor", "", "# Mayors get these permissions in addition to the default set.");
        perms.addComment("towns.ranks", "", "# Ranks contain additional permissions residents will be", "# granted if they are assigned that specific rank.");
        if (perms.getKeys(true).contains("towns.ranks.assistant")) {
            perms.addComment("towns.ranks.assistant", "", "# assistants are able to grant VIP and helper rank.");
        }
        if (perms.getKeys(true).contains("towns.ranks.donator")) {
            perms.addComment("towns.ranks.donator", "", "# Currently only an example rank holder with no extra permissions.");
        }
        if (perms.getKeys(true).contains("towns.ranks.vip")) {
            perms.addComment("towns.ranks.vip", "", "# Currently only an example rank holder with no extra permissions.");
        }
        if (perms.getKeys(true).contains("towns.ranks.sheriff")) {
            perms.addComment("towns.ranks.sheriff", "", "# Sheriff rank is able to jail other town members.");
        }
        perms.addComment("nations", "", "# This section of permissions covers players who are members of any town in a nation.");
        perms.addComment("nations.default", "", "# All nation members get these permissions.");
        perms.addComment("nations.king", "", "# Kings get these permissions in addition to the default set.");
        perms.addComment("peaceful", "", "# Nodes that are given to players who are in a peaceful/neutral town or nation.");
    }

    public static CommentedConfiguration getTownyPermsFile() {
        return perms;
    }

    static {
        vitalGroups = Arrays.asList("nomad", "towns.default", "towns.mayor", "towns.ranks", "nations.default", "nations.king", "nations.ranks");
        residentPrefixMap = new HashMap();
        ranksWithTownLevelRequirementPresent = false;
        ranksWithNationLevelRequirementPresent = false;
        PERMISSIONS = Objects.requireNonNull(JavaUtil.getFieldHandle(PermissionAttachment.class, "permissions"), "Could not find expected PermissionAttachment.permissions field");
    }
}

