/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.permissions;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.permissions.TownyPermissionSource;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.Colors;
import net.milkbowl.vault.chat.Chat;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class VaultPermSource
extends TownyPermissionSource {
    private final Chat chat;

    public VaultPermSource(Towny plugin, Chat chat) {
        this.plugin = plugin;
        this.chat = chat;
    }

    @Override
    public String getPrefixSuffix(Resident resident, String node) {
        Player player = BukkitTools.getPlayerExact(resident.getName());
        if (player != null) {
            String primaryGroup = this.getPlayerGroup(player);
            String groupPrefixSuffix = "";
            String playerPrefixSuffix = "";
            if ("prefix".equalsIgnoreCase(node)) {
                if (!primaryGroup.isEmpty()) {
                    groupPrefixSuffix = this.chat.getGroupPrefix(player.getWorld(), primaryGroup);
                }
                playerPrefixSuffix = this.chat.getPlayerPrefix(player);
            } else if ("suffix".equalsIgnoreCase(node)) {
                if (!primaryGroup.isEmpty()) {
                    groupPrefixSuffix = this.chat.getGroupSuffix(player.getWorld(), primaryGroup);
                }
                playerPrefixSuffix = this.chat.getPlayerSuffix(player);
            } else if (node.equals("userprefix")) {
                playerPrefixSuffix = this.chat.getPlayerPrefix(player);
            } else if (node.equals("usersuffix")) {
                playerPrefixSuffix = this.chat.getPlayerSuffix(player);
            } else if (node.equals("groupprefix")) {
                groupPrefixSuffix = !primaryGroup.isEmpty() ? this.chat.getGroupPrefix(player.getWorld(), primaryGroup) : "";
            } else if (node.equals("groupsuffix")) {
                groupPrefixSuffix = !primaryGroup.isEmpty() ? this.chat.getGroupSuffix(player.getWorld(), primaryGroup) : "";
            }
            if (groupPrefixSuffix == null) {
                groupPrefixSuffix = "";
            }
            if (playerPrefixSuffix == null) {
                playerPrefixSuffix = "";
            }
            Object prefixSuffix = playerPrefixSuffix;
            if (!playerPrefixSuffix.equals(groupPrefixSuffix)) {
                prefixSuffix = groupPrefixSuffix + playerPrefixSuffix;
            }
            return Colors.translateColorCodes((String)prefixSuffix);
        }
        return "";
    }

    @Override
    public int getGroupPermissionIntNode(String playerName, String node) {
        String primaryGroup;
        int iReturn = -1;
        Player player = BukkitTools.getPlayerExact(playerName);
        if (player != null && !(primaryGroup = this.getPlayerGroup(player)).isEmpty()) {
            iReturn = this.chat.getGroupInfoInteger(player.getWorld(), primaryGroup, node, -1);
        }
        if (iReturn == -1) {
            iReturn = this.getEffectivePermIntNode(playerName, node);
        }
        return iReturn;
    }

    @Override
    public int getPlayerPermissionIntNode(String playerName, String node) {
        int iReturn = -1;
        Player player = Bukkit.getPlayerExact((String)playerName);
        if (player != null) {
            iReturn = this.chat.getPlayerInfoInteger(player.getWorld().getName(), (OfflinePlayer)player, node, -1);
        }
        if (iReturn == -1) {
            iReturn = this.getEffectivePermIntNode(playerName, node);
        }
        return iReturn;
    }

    @Override
    public String getPlayerGroup(Player player) {
        String result = this.chat.getPrimaryGroup(player.getWorld().getName(), (OfflinePlayer)player);
        return result != null ? result : "";
    }

    @Override
    public String getPlayerPermissionStringNode(String playerName, String node) {
        Player player = BukkitTools.getPlayerExact(playerName);
        if (player != null) {
            return this.chat.getPlayerInfoString(player, node, "");
        }
        return "";
    }
}

