/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.regen;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.event.actions.TownyExplodingBlocksEvent;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.regen.PlotBlockData;
import com.palmergames.bukkit.towny.regen.block.BlockLocation;
import com.palmergames.bukkit.towny.tasks.ProtectionRegenTask;
import com.palmergames.bukkit.towny.utils.MinecraftVersion;
import com.palmergames.bukkit.util.ItemLists;
import com.palmergames.util.JavaUtil;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.bukkit.Chunk;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Door;
import org.bukkit.block.data.type.PistonHead;
import org.bukkit.block.sign.Side;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TownyRegenAPI {
    private static final Set<WorldCoord> regenWorldCoordList = ConcurrentHashMap.newKeySet();
    private static final Map<String, PlotBlockData> plotChunks = new ConcurrentHashMap<String, PlotBlockData>();
    private static final Map<BlockLocation, ProtectionRegenTask> protectionRegenTasks = new ConcurrentHashMap<BlockLocation, ProtectionRegenTask>();
    private static final Set<Block> protectionPlaceholders = new HashSet<Block>();
    private static final MethodHandle GET_CHUNK_SNAPSHOT = JavaUtil.getMethodHandle(Chunk.class, "getChunkSnapshot", Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE);

    public static void turnOffRevertOnUnclaimForWorld(TownyWorld world) {
        TownyRegenAPI.removeRegenQueueListOfWorld(world);
        TownyRegenAPI.removePlotChunksForWorld(world);
    }

    public static void finishPlotBlockData(PlotBlockData plotChunk) {
        TownyMessaging.sendDebugMsg("Revert on unclaim complete for " + plotChunk.getWorldName() + " " + plotChunk.getX() + "," + plotChunk.getZ());
        TownyRegenAPI.removeFromRegenQueueList(plotChunk.getWorldCoord());
        TownyRegenAPI.removeFromActiveRegeneration(plotChunk);
        TownyRegenAPI.deletePlotChunkSnapshot(plotChunk);
        plotChunk.getWorldCoord().unloadChunks();
    }

    public static Collection<WorldCoord> getRegenQueueList() {
        return regenWorldCoordList;
    }

    public static boolean regenQueueHasAvailable() {
        return !regenWorldCoordList.isEmpty();
    }

    private static void removeRegenQueueListOfWorld(@NotNull TownyWorld world) {
        if (regenWorldCoordList.removeIf(wc -> world.equals(wc.getTownyWorld()))) {
            TownyUniverse.getInstance().getDataSource().saveRegenList();
        }
    }

    public static void removeFromRegenQueueList(WorldCoord wc) {
        if (regenWorldCoordList.remove(wc)) {
            TownyUniverse.getInstance().getDataSource().saveRegenList();
        }
    }

    public static void addToRegenQueueList(WorldCoord wc, boolean save) {
        if (regenWorldCoordList.add(wc) && save) {
            TownyUniverse.getInstance().getDataSource().saveRegenList();
        }
    }

    public static void getWorldCoordFromQueueForRegeneration() {
        for (WorldCoord wc : TownyRegenAPI.getRegenQueueList()) {
            if (TownyRegenAPI.getPlotChunks().size() >= 20) break;
            if (TownyRegenAPI.hasActiveRegeneration(wc)) continue;
            PlotBlockData plotData = TownyRegenAPI.getPlotChunkSnapshot(new TownBlock(wc.getX(), wc.getZ(), wc.getTownyWorld()));
            if (plotData != null) {
                plotData.getWorldCoord().loadChunks();
                TownyRegenAPI.addToActiveRegeneration(plotData);
                TownyMessaging.sendDebugMsg("Revert on unclaim beginning for " + plotData.getWorldName() + " " + plotData.getX() + "," + plotData.getZ());
                continue;
            }
            TownyRegenAPI.removeFromRegenQueueList(wc);
        }
    }

    public static Map<String, PlotBlockData> getPlotChunks() {
        return plotChunks;
    }

    public static Collection<PlotBlockData> getActivePlotBlockDatas() {
        return plotChunks.values();
    }

    public static boolean hasActiveRegenerations() {
        return !plotChunks.isEmpty();
    }

    public static boolean hasActiveRegeneration(WorldCoord wc) {
        return plotChunks.containsKey(TownyRegenAPI.getPlotKey(wc));
    }

    private static void removePlotChunksForWorld(TownyWorld world) {
        plotChunks.values().removeIf(data -> data.getWorldName().equals(world.getName()));
    }

    public static void removeFromActiveRegeneration(PlotBlockData plotChunk) {
        plotChunks.remove(TownyRegenAPI.getPlotKey(plotChunk));
    }

    public static void addToActiveRegeneration(PlotBlockData plotChunk) {
        plotChunks.putIfAbsent(TownyRegenAPI.getPlotKey(plotChunk), plotChunk);
    }

    public static void addPlotChunkSnapshot(PlotBlockData plotChunk) {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        TownBlock townBlock = plotChunk.getWorldCoord().getTownBlockOrNull();
        if (townBlock == null || !townyUniverse.getDataSource().hasPlotData(townBlock)) {
            townyUniverse.getDataSource().savePlotData(plotChunk);
        }
    }

    private static void deletePlotChunkSnapshot(PlotBlockData plotChunk) {
        TownyUniverse.getInstance().getDataSource().deletePlotData(plotChunk);
    }

    public static PlotBlockData getPlotChunkSnapshot(TownBlock townBlock) {
        return TownyUniverse.getInstance().getDataSource().loadPlotData(townBlock);
    }

    @Nullable
    public static PlotBlockData getPlotChunk(TownBlock townBlock) {
        return plotChunks.get(TownyRegenAPI.getPlotKey(townBlock));
    }

    private static String getPlotKey(PlotBlockData plotChunk) {
        return "[" + plotChunk.getWorldName() + "|" + plotChunk.getX() + "|" + plotChunk.getZ() + "]";
    }

    public static String getPlotKey(TownBlock townBlock) {
        return "[" + townBlock.getWorld().getName() + "|" + townBlock.getX() + "|" + townBlock.getZ() + "]";
    }

    public static String getPlotKey(WorldCoord wc) {
        return "[" + wc.getWorldName() + "|" + wc.getX() + "|" + wc.getZ() + "]";
    }

    public static boolean beginProtectionRegenTask(Block block, int count, TownyWorld world, Event event) {
        if (!TownyRegenAPI.hasProtectionRegenTask(new BlockLocation(block.getLocation()))) {
            if (block.getType() == Material.PISTON_HEAD) {
                PistonHead blockData = (PistonHead)block.getBlockData();
                block = block.getRelative(blockData.getFacing().getOppositeFace());
            }
            ProtectionRegenTask task = new ProtectionRegenTask(Towny.getPlugin(), block);
            task.setTask(Towny.getPlugin().getScheduler().runLater(block.getLocation(), (Runnable)task, (world.getPlotManagementWildRevertDelay() + (long)count) * 20L));
            TownyRegenAPI.addProtectionRegenTask(task);
            if (event instanceof TownyExplodingBlocksEvent) {
                event = ((TownyExplodingBlocksEvent)event).getBukkitExplodeEvent();
            }
            if (event instanceof EntityExplodeEvent) {
                ((EntityExplodeEvent)event).setYield(0.0f);
            } else if (event instanceof BlockExplodeEvent) {
                ((BlockExplodeEvent)event).setYield(0.0f);
            }
            TownyRegenAPI.handlePeskyBlocks(block, (world.getPlotManagementWildRevertDelay() + (long)count++) * 20L);
            return true;
        }
        return false;
    }

    private static void handlePeskyBlocks(Block block, long delay) {
        if (ItemLists.EXPLODABLE_ATTACHABLES.contains(block.getType())) {
            BlockData blockData = block.getBlockData();
            if (!(blockData instanceof Door)) {
                block.setType(Material.AIR);
            } else {
                Door door = (Door)blockData;
                if (door.getHalf().equals((Object)Bisected.Half.TOP)) {
                    block.getRelative(BlockFace.DOWN).setType(Material.AIR);
                    block.setType(Material.AIR);
                }
            }
        }
        if (ItemLists.SIGNS.contains(block.getType())) {
            TownyRegenAPI.regenerateSign(block, delay);
        }
    }

    private static void regenerateSign(Block block, long delay) {
        Sign sign = (Sign)block.getState();
        if (MinecraftVersion.CURRENT_VERSION.isOlderThan(MinecraftVersion.MINECRAFT_1_20)) {
            String[] lines = sign.getLines();
            boolean glowing = sign.isGlowingText();
            DyeColor color = sign.getColor();
            Towny.getPlugin().getScheduler().runLater(block.getLocation(), () -> {
                int lineNum = 0;
                for (String line : lines) {
                    sign.setLine(lineNum, line);
                    ++lineNum;
                }
                sign.setGlowingText(glowing);
                sign.setColor(color);
                sign.update(true);
            }, delay);
            return;
        }
        String[] frontLines = sign.getSide(Side.FRONT).getLines();
        String[] backLines = sign.getSide(Side.BACK).getLines();
        boolean waxed = sign.isWaxed();
        boolean frontGlowing = sign.getSide(Side.FRONT).isGlowingText();
        boolean backGlowing = sign.getSide(Side.BACK).isGlowingText();
        DyeColor frontColor = sign.getSide(Side.FRONT).getColor();
        DyeColor backColor = sign.getSide(Side.BACK).getColor();
        Towny.getPlugin().getScheduler().runLater(block.getLocation(), () -> {
            int lineNum = 0;
            for (String line : frontLines) {
                sign.getSide(Side.FRONT).setLine(lineNum, line);
                ++lineNum;
            }
            lineNum = 0;
            for (String line : backLines) {
                sign.getSide(Side.BACK).setLine(lineNum, line);
                ++lineNum;
            }
            sign.setWaxed(waxed);
            sign.getSide(Side.FRONT).setGlowingText(frontGlowing);
            sign.getSide(Side.BACK).setGlowingText(backGlowing);
            sign.getSide(Side.FRONT).setColor(frontColor);
            sign.getSide(Side.BACK).setColor(backColor);
            sign.update(true);
        }, delay);
    }

    public static boolean hasProtectionRegenTask(BlockLocation blockLocation) {
        return protectionRegenTasks.containsKey(blockLocation);
    }

    public static ProtectionRegenTask GetProtectionRegenTask(BlockLocation blockLocation) {
        return protectionRegenTasks.get(blockLocation);
    }

    public static void addProtectionRegenTask(ProtectionRegenTask task) {
        protectionRegenTasks.put(task.getBlockLocation(), task);
    }

    public static void removeProtectionRegenTask(ProtectionRegenTask task) {
        protectionRegenTasks.remove(task.getBlockLocation());
        if (protectionRegenTasks.isEmpty()) {
            protectionPlaceholders.clear();
        }
    }

    public static void cancelProtectionRegenTasks() {
        boolean replaceProtections = true;
        try {
            if (Class.forName("org.spigotmc.WatchdogThread").isInstance(Thread.currentThread())) {
                Towny.getPlugin().getLogger().severe("Detected a watchdog crash, ongoing protection revert tasks will not be finished.");
                replaceProtections = false;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        for (ProtectionRegenTask task : protectionRegenTasks.values()) {
            task.getTask().cancel();
            if (!replaceProtections) continue;
            task.replaceProtections();
        }
        protectionRegenTasks.clear();
        protectionPlaceholders.clear();
    }

    public static boolean isPlaceholder(Block block) {
        return protectionPlaceholders.contains(block);
    }

    public static void addPlaceholder(Block block) {
        protectionPlaceholders.add(block);
    }

    public static void removePlaceholder(Block block) {
        protectionPlaceholders.remove(block);
    }

    public static void handleNewSnapshot(@NotNull TownBlock townBlock) {
        ((CompletableFuture)TownyRegenAPI.createPlotSnapshot(townBlock).thenAcceptAsync(data -> {
            if (data.getBlockList().isEmpty()) {
                return;
            }
            TownyRegenAPI.addPlotChunkSnapshot(data);
        })).exceptionally(e -> {
            if (e.getCause() != null) {
                e = e.getCause();
            }
            Towny.getPlugin().getLogger().log(Level.WARNING, "An exception occurred while creating a plot snapshot for " + townBlock.getWorldCoord().toString(), (Throwable)e);
            return null;
        });
    }

    public static CompletableFuture<PlotBlockData> createPlotSnapshot(@NotNull TownBlock townBlock) {
        ArrayList snapshots = new ArrayList();
        Collection<CompletableFuture<Chunk>> futures = townBlock.getWorldCoord().getChunks();
        futures.forEach(future -> future.thenAccept(chunk -> {
            try {
                if (GET_CHUNK_SNAPSHOT != null) {
                    snapshots.add(GET_CHUNK_SNAPSHOT.invoke((Chunk)chunk, false, false, false, false));
                } else {
                    snapshots.add(chunk.getChunkSnapshot(false, false, false));
                }
            }
            catch (Throwable throwable) {
                snapshots.add(chunk.getChunkSnapshot(false, false, false));
            }
        }));
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenApplyAsync(v -> {
            PlotBlockData data = new PlotBlockData(townBlock);
            data.initialize(snapshots);
            return data;
        });
    }
}

