/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.regen;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.WorldCoord;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.Nullable;

public class WorldCoordEntityRemover {
    private static final List<WorldCoord> worldCoordQueue = new ArrayList<WorldCoord>();
    private static final List<WorldCoord> activeQueue = new ArrayList<WorldCoord>();

    public static boolean hasQueue() {
        return !worldCoordQueue.isEmpty();
    }

    public static boolean isQueued(WorldCoord worldCoord) {
        return worldCoordQueue.contains(worldCoord);
    }

    public static int getQueueSize() {
        return worldCoordQueue.size();
    }

    public static void addToQueue(WorldCoord worldCoord) {
        if (!worldCoordQueue.contains(worldCoord)) {
            worldCoordQueue.add(worldCoord);
        }
    }

    @Nullable
    public static WorldCoord getWorldCoordFromQueue() {
        if (!worldCoordQueue.isEmpty()) {
            for (WorldCoord wc : worldCoordQueue) {
                if (WorldCoordEntityRemover.isActiveQueue(wc)) continue;
                return wc;
            }
        }
        return null;
    }

    public static boolean isActiveQueue(WorldCoord worldCoord) {
        return activeQueue.contains(worldCoord);
    }

    public static int getActiveQueueSize() {
        return activeQueue.size();
    }

    public static void addToActiveQueue(WorldCoord worldCoord) {
        if (!activeQueue.contains(worldCoord)) {
            activeQueue.add(worldCoord);
        }
    }

    public static void doDeleteTownBlockEntities(WorldCoord worldCoord) {
        TownyWorld world = worldCoord.getTownyWorld();
        if (world == null || !world.isUsingTowny() || !world.isDeletingEntitiesOnUnclaim()) {
            worldCoordQueue.remove(worldCoord);
            return;
        }
        WorldCoordEntityRemover.addToActiveQueue(worldCoord);
        Towny.getPlugin().getScheduler().run(worldCoord.getLowerMostCornerLocation(), () -> {
            try {
                World bukkitWorld = world.getBukkitWorld();
                if (bukkitWorld == null) {
                    return;
                }
                for (Entity entity : bukkitWorld.getNearbyEntities(worldCoord.getBoundingBox())) {
                    if (!world.getUnclaimDeleteEntityTypes().contains(entity.getType())) continue;
                    entity.remove();
                }
            }
            finally {
                worldCoordQueue.remove(worldCoord);
                activeQueue.remove(worldCoord);
            }
        });
    }
}

