/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.regen.block;

import java.util.Objects;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;

public class BlockLocation {
    protected int x;
    protected int z;
    protected int y;
    protected Chunk chunk;
    protected World world;

    public void setY(int y) {
        this.y = y;
    }

    public BlockLocation(Location loc) {
        this.x = loc.getBlockX();
        this.z = loc.getBlockZ();
        this.y = loc.getBlockY();
        this.chunk = loc.getChunk();
        this.world = loc.getWorld();
    }

    public Chunk getChunk() {
        return this.chunk;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public int getY() {
        return this.y;
    }

    public World getWorld() {
        return this.world;
    }

    public boolean isLocation(Location loc) {
        return loc.getWorld() == this.getWorld() && loc.getBlockX() == this.getX() && loc.getBlockY() == this.getY() && loc.getBlockZ() == this.getZ();
    }

    public Location getLocation() {
        return new Location(this.world, (double)this.x, (double)this.y, (double)this.z);
    }

    public Block getBlock() {
        return this.world.getBlockAt(this.getLocation());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockLocation that = (BlockLocation)o;
        return this.x == that.x && this.z == that.z && this.y == that.y && Objects.equals(this.chunk, that.chunk) && Objects.equals(this.world, that.world);
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + this.x;
        hash = 31 * hash + this.y;
        hash = 31 * hash + this.z;
        hash = hash * 31 + (this.chunk != null ? this.chunk.hashCode() : 0);
        hash = hash * 31 + (this.world != null ? this.world.hashCode() : 0);
        return hash;
    }
}

