/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.scheduling;

import com.palmergames.bukkit.towny.scheduling.ScheduledTask;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.ApiStatus;

public interface TaskScheduler {
    public boolean isGlobalThread();

    public boolean isTickThread();

    public boolean isEntityThread(Entity var1);

    public boolean isRegionThread(Location var1);

    public ScheduledTask run(Consumer<ScheduledTask> var1);

    default public ScheduledTask run(Entity entity, Consumer<ScheduledTask> task) {
        return this.run(task);
    }

    default public ScheduledTask run(Location location, Consumer<ScheduledTask> task) {
        return this.run(task);
    }

    public ScheduledTask runLater(Consumer<ScheduledTask> var1, long var2);

    default public ScheduledTask runLater(Entity entity, Consumer<ScheduledTask> task, long delay) {
        return this.runLater(task, delay);
    }

    default public ScheduledTask runLater(Location location, Consumer<ScheduledTask> task, long delay) {
        return this.runLater(task, delay);
    }

    public ScheduledTask runRepeating(Consumer<ScheduledTask> var1, long var2, long var4);

    default public ScheduledTask runRepeating(Entity entity, Consumer<ScheduledTask> task, long delay, long period) {
        return this.runRepeating(task, delay, period);
    }

    default public ScheduledTask runRepeating(Location location, Consumer<ScheduledTask> task, long delay, long period) {
        return this.runRepeating(task, delay, period);
    }

    public ScheduledTask runAsync(Consumer<ScheduledTask> var1);

    public ScheduledTask runAsyncLater(Consumer<ScheduledTask> var1, long var2, TimeUnit var4);

    public ScheduledTask runAsyncRepeating(Consumer<ScheduledTask> var1, long var2, long var4, TimeUnit var6);

    @ApiStatus.Experimental
    default public ScheduledTask runGlobal(Consumer<ScheduledTask> task) {
        return this.run(task);
    }

    @ApiStatus.Experimental
    default public ScheduledTask runGlobalLater(Consumer<ScheduledTask> task, long delay) {
        return this.runLater(task, delay);
    }

    @ApiStatus.Experimental
    default public ScheduledTask runGlobalRepeating(Consumer<ScheduledTask> task, long delay, long period) {
        return this.runRepeating(task, delay, period);
    }

    default public ScheduledTask run(Runnable runnable) {
        return this.run((ScheduledTask task) -> runnable.run());
    }

    default public ScheduledTask run(Entity entity, Runnable runnable) {
        return this.run(entity, (ScheduledTask task) -> runnable.run());
    }

    default public ScheduledTask run(Location location, Runnable runnable) {
        return this.run(location, (ScheduledTask task) -> runnable.run());
    }

    default public ScheduledTask runLater(Runnable runnable, long delay) {
        return this.runLater((ScheduledTask task) -> runnable.run(), delay);
    }

    default public ScheduledTask runLater(Entity entity, Runnable runnable, long delay) {
        return this.runLater(entity, (ScheduledTask task) -> runnable.run(), delay);
    }

    default public ScheduledTask runLater(Location location, Runnable runnable, long delay) {
        return this.runLater(location, (ScheduledTask task) -> runnable.run(), delay);
    }

    default public ScheduledTask runRepeating(Runnable runnable, long delay, long period) {
        return this.runRepeating((ScheduledTask task) -> runnable.run(), delay, period);
    }

    default public ScheduledTask runRepeating(Entity entity, Runnable runnable, long delay, long period) {
        return this.runRepeating(entity, (ScheduledTask task) -> runnable.run(), delay, period);
    }

    default public ScheduledTask runRepeating(Location location, Runnable runnable, long delay, long period) {
        return this.runRepeating(location, (ScheduledTask task) -> runnable.run(), delay, period);
    }

    default public ScheduledTask runAsync(Runnable runnable) {
        return this.runAsync((ScheduledTask task) -> runnable.run());
    }

    default public ScheduledTask runAsyncLater(Runnable runnable, long delay) {
        return this.runAsyncLater(task -> runnable.run(), delay * 50L, TimeUnit.MILLISECONDS);
    }

    default public ScheduledTask runAsyncRepeating(Runnable runnable, long delay, long period) {
        return this.runAsyncRepeating(task -> runnable.run(), delay * 50L, period * 50L, TimeUnit.MILLISECONDS);
    }
}

