/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.scheduling.impl;

import com.palmergames.bukkit.towny.scheduling.ScheduledTask;
import com.palmergames.bukkit.towny.scheduling.TaskScheduler;
import com.palmergames.bukkit.towny.scheduling.impl.FoliaScheduledTask;
import io.papermc.paper.threadedregions.scheduler.AsyncScheduler;
import io.papermc.paper.threadedregions.scheduler.GlobalRegionScheduler;
import io.papermc.paper.threadedregions.scheduler.RegionScheduler;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

public class FoliaTaskScheduler
implements TaskScheduler {
    private static final long MS_PER_TICK = 50L;
    private final RegionScheduler regionScheduler = Bukkit.getServer().getRegionScheduler();
    final GlobalRegionScheduler globalRegionScheduler = Bukkit.getServer().getGlobalRegionScheduler();
    private final AsyncScheduler asyncScheduler = Bukkit.getServer().getAsyncScheduler();
    final Plugin plugin;

    public FoliaTaskScheduler(Plugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean isGlobalThread() {
        return Bukkit.getServer().isGlobalTickThread();
    }

    @Override
    public boolean isTickThread() {
        return Bukkit.getServer().isPrimaryThread();
    }

    @Override
    public boolean isEntityThread(Entity entity) {
        return Bukkit.getServer().isOwnedByCurrentRegion(entity);
    }

    @Override
    public boolean isRegionThread(Location location) {
        return Bukkit.getServer().isOwnedByCurrentRegion(location);
    }

    @Override
    public ScheduledTask run(Consumer<ScheduledTask> task) {
        return this.runAsync(task);
    }

    @Override
    public ScheduledTask run(Entity entity, Consumer<ScheduledTask> task) {
        FoliaScheduledTask ret = new FoliaScheduledTask(null);
        ret.setTask(entity.getScheduler().run(this.plugin, t -> task.accept(ret), null));
        return ret;
    }

    @Override
    public ScheduledTask run(Location location, Consumer<ScheduledTask> task) {
        FoliaScheduledTask ret = new FoliaScheduledTask(null);
        ret.setTask(this.regionScheduler.run(this.plugin, location, t -> task.accept(ret)));
        return ret;
    }

    @Override
    public ScheduledTask runLater(Consumer<ScheduledTask> task, long delay) {
        if (delay == 0L) {
            return this.run(task);
        }
        return this.runAsyncLater(task, delay * 50L, TimeUnit.MILLISECONDS);
    }

    @Override
    public ScheduledTask runLater(Entity entity, Consumer<ScheduledTask> task, long delay) {
        if (delay == 0L) {
            return this.run(entity, task);
        }
        FoliaScheduledTask ret = new FoliaScheduledTask(null);
        ret.setTask(entity.getScheduler().runDelayed(this.plugin, t -> task.accept(ret), null, delay));
        return ret;
    }

    @Override
    public ScheduledTask runLater(Location location, Consumer<ScheduledTask> task, long delay) {
        if (delay == 0L) {
            return this.run(location, task);
        }
        FoliaScheduledTask ret = new FoliaScheduledTask(null);
        ret.setTask(this.regionScheduler.runDelayed(this.plugin, location, t -> task.accept(ret), delay));
        return ret;
    }

    @Override
    public ScheduledTask runRepeating(Consumer<ScheduledTask> task, long delay, long period) {
        return this.runAsyncRepeating(task, delay * 50L, period * 50L, TimeUnit.MILLISECONDS);
    }

    @Override
    public ScheduledTask runRepeating(Entity entity, Consumer<ScheduledTask> task, long delay, long period) {
        FoliaScheduledTask ret = new FoliaScheduledTask(null);
        ret.setTask(entity.getScheduler().runAtFixedRate(this.plugin, t -> task.accept(ret), null, delay, period));
        return ret;
    }

    @Override
    public ScheduledTask runRepeating(Location location, Consumer<ScheduledTask> task, long delay, long period) {
        FoliaScheduledTask ret = new FoliaScheduledTask(null);
        ret.setTask(this.regionScheduler.runAtFixedRate(this.plugin, location, t -> task.accept(ret), delay, period));
        return ret;
    }

    @Override
    public ScheduledTask runAsync(Consumer<ScheduledTask> task) {
        FoliaScheduledTask ret = new FoliaScheduledTask(null);
        ret.setTask(this.asyncScheduler.runNow(this.plugin, t -> task.accept(ret)));
        return ret;
    }

    @Override
    public ScheduledTask runAsyncLater(Consumer<ScheduledTask> task, long delay, TimeUnit timeUnit) {
        if (delay == 0L) {
            return this.runAsync(task);
        }
        FoliaScheduledTask ret = new FoliaScheduledTask(null);
        ret.setTask(this.asyncScheduler.runDelayed(this.plugin, t -> task.accept(ret), delay, timeUnit));
        return ret;
    }

    @Override
    public ScheduledTask runAsyncRepeating(Consumer<ScheduledTask> task, long delay, long period, TimeUnit timeUnit) {
        FoliaScheduledTask ret = new FoliaScheduledTask(null);
        ret.setTask(this.asyncScheduler.runAtFixedRate(this.plugin, t -> task.accept(ret), delay, period, timeUnit));
        return ret;
    }

    @Override
    public ScheduledTask runGlobal(Consumer<ScheduledTask> task) {
        FoliaScheduledTask ret = new FoliaScheduledTask(null);
        ret.setTask(this.globalRegionScheduler.run(this.plugin, t -> task.accept(ret)));
        return ret;
    }

    @Override
    public ScheduledTask runGlobalLater(Consumer<ScheduledTask> task, long delay) {
        FoliaScheduledTask ret = new FoliaScheduledTask(null);
        ret.setTask(this.globalRegionScheduler.runDelayed(this.plugin, t -> task.accept(ret), delay));
        return ret;
    }

    @Override
    public ScheduledTask runGlobalRepeating(Consumer<ScheduledTask> task, long delay, long period) {
        FoliaScheduledTask ret = new FoliaScheduledTask(null);
        ret.setTask(this.globalRegionScheduler.runAtFixedRate(this.plugin, t -> task.accept(ret), delay, period));
        return ret;
    }

    public void cancelTasks() {
        this.asyncScheduler.cancelTasks(this.plugin);
        this.globalRegionScheduler.cancelTasks(this.plugin);
    }
}

