/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.tasks;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.tasks.TownyTimerTask;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class CooldownTimerTask
extends TownyTimerTask {
    private static final Map<String, Long> COOLDOWNS = new ConcurrentHashMap<String, Long>();

    public CooldownTimerTask(Towny plugin) {
        super(plugin);
    }

    @Override
    public void run() {
        long currentTime = System.currentTimeMillis();
        COOLDOWNS.entrySet().removeIf(entry -> (Long)entry.getValue() <= currentTime);
    }

    public static void addCooldownTimer(String object, CooldownType type) {
        CooldownTimerTask.addCooldownTimer(object, type.name(), type.getSeconds());
    }

    public static void addCooldownTimer(String object, String cooldownTypeName, int coolDownSeconds) {
        COOLDOWNS.put(CooldownTimerTask.key(object, cooldownTypeName), CooldownTimerTask.getCooldownEndTime(coolDownSeconds));
    }

    public static boolean hasCooldown(String object, CooldownType type) {
        return CooldownTimerTask.hasCooldown(object, type.name());
    }

    public static boolean hasCooldown(String object, String cooldownTypeName) {
        Long endTime = COOLDOWNS.get(CooldownTimerTask.key(object, cooldownTypeName));
        if (endTime == null) {
            return false;
        }
        return endTime > System.currentTimeMillis();
    }

    public static int getCooldownRemaining(String object, CooldownType type) {
        return CooldownTimerTask.getCooldownRemaining(object, type.name());
    }

    public static int getCooldownRemaining(String object, String cooldownTypeName) {
        return CooldownTimerTask.getSecondsRemaining(CooldownTimerTask.key(object, cooldownTypeName));
    }

    private static String key(String object, String cooldownTypeName) {
        String key = object + ":" + cooldownTypeName.toLowerCase(Locale.ROOT);
        if (key.length() > 200) {
            throw new IllegalArgumentException("Cooldown key length cannot exceed 200 characters, got '" + key + "'.");
        }
        return key;
    }

    private static long getCooldownEndTime(int coolDownSeconds) {
        return System.currentTimeMillis() + (long)coolDownSeconds * 1000L;
    }

    private static int getSecondsRemaining(String key) {
        Long endTime = COOLDOWNS.get(key);
        if (endTime == null) {
            return 0;
        }
        return (int)TimeUnit.MILLISECONDS.toSeconds(endTime - System.currentTimeMillis());
    }

    public static Map<String, Long> getCooldowns() {
        return COOLDOWNS;
    }

    public static enum CooldownType {
        PVP(TownySettings.getPVPCoolDownTime()),
        NEUTRALITY(TownySettings.getPeacefulCoolDownTime()),
        TELEPORT(TownySettings.getSpawnCooldownTime()),
        TOWN_RENAME(60),
        TOWN_DELETE(TownySettings.getTownDeleteCoolDownTime()),
        TOWNBLOCK_UNCLAIM(TownySettings.getTownUnclaimCoolDownTime()),
        OUTLAW_WARNING(TownySettings.getOutlawWarningMessageCooldown());

        private final int seconds;

        private int getSeconds() {
            return this.seconds;
        }

        private CooldownType(int seconds) {
            this.seconds = seconds;
        }
    }
}

