/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.tasks;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyTimerHandler;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.tasks.TownyTimerTask;
import com.palmergames.bukkit.towny.utils.CombatUtil;
import com.palmergames.bukkit.towny.utils.MinecraftVersion;
import com.palmergames.bukkit.util.BukkitTools;
import java.util.Objects;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Server;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRegainHealthEvent;

public class HealthRegenTimerTask
extends TownyTimerTask {
    private static final boolean ATTRIBUTE_PREFIX = MinecraftVersion.CURRENT_VERSION.isOlderThan(MinecraftVersion.MINECRAFT_1_21_2);
    private static final Attribute MAX_HEALTH = Objects.requireNonNull((Attribute)Registry.ATTRIBUTE.get(NamespacedKey.minecraft((String)((ATTRIBUTE_PREFIX ? "generic." : "") + "max_health"))), "max health attribute");
    private final Server server;

    public HealthRegenTimerTask(Towny plugin, Server server) {
        super(plugin);
        this.server = server;
    }

    @Override
    public void run() {
        if (this.plugin.isFolia()) {
            for (Player player : this.server.getOnlinePlayers()) {
                this.plugin.getScheduler().run((Entity)player, () -> this.evaluatePlayer(player));
            }
        } else {
            for (Player player : this.server.getOnlinePlayers()) {
                this.evaluatePlayer(player);
            }
        }
    }

    public void evaluatePlayer(Player player) {
        if (player.getHealth() <= 0.0) {
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(player.getWorld())) {
            return;
        }
        Town town = TownyAPI.getInstance().getTown(player);
        if (town == null) {
            return;
        }
        if (this.playerAllowedToHealHere(town, TownyAPI.getInstance().getTownBlock(player))) {
            this.evaluateHealth(player);
        }
    }

    private boolean playerAllowedToHealHere(Town playersTown, TownBlock tbAtPlayer) {
        if (tbAtPlayer == null) {
            return false;
        }
        Town townAtPlayer = tbAtPlayer.getTownOrNull();
        return townAtPlayer != null && !townAtPlayer.hasActiveWar() && CombatUtil.isAlly(townAtPlayer, playersTown) && !tbAtPlayer.getType().equals(TownBlockType.ARENA);
    }

    private void evaluateHealth(Player player) {
        double gained;
        double currentHP = player.getHealth();
        double futureHP = currentHP + 1.0;
        AttributeInstance maxHealth = player.getAttribute(MAX_HEALTH);
        if (maxHealth == null) {
            return;
        }
        double maxHP = maxHealth.getValue();
        double d = gained = futureHP > maxHP ? 1.0 - (futureHP - maxHP) : 1.0;
        if (gained <= 0.0) {
            return;
        }
        this.plugin.getScheduler().run((Entity)player, () -> this.tryIncreaseHealth(player, currentHP, maxHP, gained));
    }

    private void tryIncreaseHealth(Player player, double currentHealth, double maxHealth, double gained) {
        EntityRegainHealthEvent event = new EntityRegainHealthEvent((Entity)player, gained, EntityRegainHealthEvent.RegainReason.REGEN);
        if (BukkitTools.isEventCancelled((Event)event)) {
            return;
        }
        player.setHealth(Math.min(maxHealth, event.getAmount() + currentHealth));
    }

    static {
        TownySettings.addReloadListener(NamespacedKey.fromString((String)"towny:health-regen-task"), () -> TownyTimerHandler.toggleHealthRegen(TownySettings.hasHealthRegen()));
    }
}

