/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.tasks;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.event.time.NewHourEvent;
import com.palmergames.bukkit.towny.invites.InviteHandler;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.jail.UnJailReason;
import com.palmergames.bukkit.towny.tasks.TownyTimerTask;
import com.palmergames.bukkit.towny.utils.JailUtil;
import com.palmergames.bukkit.towny.utils.TownRuinUtil;
import com.palmergames.bukkit.util.BukkitTools;
import java.util.ArrayList;

public class HourlyTimerTask
extends TownyTimerTask {
    public HourlyTimerTask(Towny plugin) {
        super(plugin);
    }

    @Override
    public void run() {
        if (TownySettings.getTownRuinsEnabled()) {
            TownRuinUtil.evaluateRuinedTownRemovals();
        }
        if (TownySettings.getInviteExpirationTime() > 0L) {
            InviteHandler.searchForExpiredInvites();
        }
        if (!this.universe.getJailedResidentMap().isEmpty()) {
            this.decrementJailedHoursAndIncurJailFees();
        }
        BukkitTools.fireEvent(new NewHourEvent(System.currentTimeMillis()));
    }

    private void decrementJailedHoursAndIncurJailFees() {
        double hourlyJailFee = TownyEconomyHandler.isActive() && TownySettings.hourlyJailFee() > 0.0 ? TownySettings.hourlyJailFee() : 0.0;
        for (Resident resident : new ArrayList<Resident>(this.universe.getJailedResidentMap())) {
            if (!resident.hasJailTime()) continue;
            if (resident.getJailHours() <= 1) {
                this.plugin.getScheduler().runLater(() -> JailUtil.unJailResident(resident, UnJailReason.SENTENCE_SERVED), 20L);
                continue;
            }
            if (hourlyJailFee > 0.0) {
                Town jailTown = resident.getJailTown();
                if (!jailTown.getAccount().withdraw(hourlyJailFee, "Jailee Hourly Fee for " + resident.getName())) {
                    this.plugin.getScheduler().runLater(() -> JailUtil.unJailResident(resident, UnJailReason.INSUFFICIENT_FUNDS), 20L);
                    continue;
                }
                TownyMessaging.sendPrefixedTownMessage(jailTown, Translatable.of("msg_x_has_been_withdrawn_for_upkeep_of_prisoner_x", hourlyJailFee, resident));
            }
            resident.setJailHours(resident.getJailHours() - 1);
            resident.save();
        }
    }
}

