/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.tasks;

import com.palmergames.bukkit.config.ConfigNodes;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.event.MobRemovalEvent;
import com.palmergames.bukkit.towny.hooks.PluginIntegrations;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.tasks.TownyTimerTask;
import com.palmergames.bukkit.towny.utils.EntityTypeUtil;
import com.palmergames.bukkit.util.BukkitTools;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Rabbit;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MobRemovalTimerTask
extends TownyTimerTask {
    public static Set<EntityType> typesOfWorldMobsToRemove = new HashSet<EntityType>();
    public static Set<EntityType> typesOfWildernessMobsToRemove = new HashSet<EntityType>();
    public static Set<EntityType> typesOfTownMobsToRemove = new HashSet<EntityType>();
    private static final Set<String> ignoredSpawnReasons = new HashSet<String>();
    private static boolean isRemovingKillerBunny;

    public MobRemovalTimerTask(Towny plugin) {
        super(plugin);
        MobRemovalTimerTask.populateFields();
    }

    public static boolean isRemovingWorldEntity(LivingEntity livingEntity) {
        return typesOfWorldMobsToRemove.contains(livingEntity.getType());
    }

    public static boolean isRemovingWildernessEntity(LivingEntity livingEntity) {
        return typesOfWildernessMobsToRemove.contains(livingEntity.getType());
    }

    public static boolean isRemovingTownEntity(LivingEntity livingEntity) {
        return typesOfTownMobsToRemove.contains(livingEntity.getType());
    }

    public static boolean isSpawnReasonIgnored(@NotNull Entity entity) {
        return MobRemovalTimerTask.isSpawnReasonIgnored(entity, null);
    }

    public static boolean isSpawnReasonIgnored(@NotNull Entity entity, @Nullable CreatureSpawnEvent.SpawnReason spawnReason) {
        if (spawnReason != null && ignoredSpawnReasons.contains(spawnReason.name())) {
            return true;
        }
        return ignoredSpawnReasons.contains(entity.getEntitySpawnReason().name());
    }

    @Override
    public void run() {
        for (World world : Bukkit.getWorlds()) {
            TownyWorld townyWorld = TownyAPI.getInstance().getTownyWorld(world);
            if (!MobRemovalTimerTask.isRemovingEntities(townyWorld)) continue;
            for (LivingEntity entity : world.getLivingEntities()) {
                MobRemovalTimerTask.checkEntity(this.plugin, townyWorld, (Entity)entity);
            }
        }
    }

    public static boolean isRemovingEntities(@Nullable TownyWorld world) {
        if (world == null || !world.isUsingTowny()) {
            return false;
        }
        return !world.isForceTownMobs() || !world.hasWorldMobs();
    }

    public static void checkEntity(@NotNull Towny plugin, @NotNull TownyWorld townyWorld, @NotNull Entity ent) {
        if (!(ent instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity = (LivingEntity)ent;
        if (entity instanceof Player || PluginIntegrations.getInstance().isNPC((Entity)entity)) {
            return;
        }
        if (!townyWorld.hasWorldMobs() && MobRemovalTimerTask.isRemovingWorldEntity(entity)) {
            MobRemovalTimerTask.removeEntity(plugin, (Entity)entity);
            return;
        }
        Runnable runnable = () -> {
            Location livingEntityLoc = entity.getLocation();
            TownBlock townBlock = TownyAPI.getInstance().getTownBlock(livingEntityLoc);
            if (townBlock == null) {
                if (townyWorld.hasWildernessMobs() || !MobRemovalTimerTask.isRemovingWildernessEntity(entity)) {
                    return;
                }
            } else {
                if (townyWorld.isForceTownMobs() || townBlock.getPermissions().mobs || townBlock.getTownOrNull() != null && townBlock.getTownOrNull().isAdminEnabledMobs()) {
                    return;
                }
                if (!MobRemovalTimerTask.isRemovingTownEntity(entity)) {
                    return;
                }
            }
            if (PluginIntegrations.getInstance().checkHostileEliteMobs((Entity)entity)) {
                MobRemovalTimerTask.removeEntity(plugin, (Entity)entity);
                return;
            }
            if (entity instanceof Rabbit) {
                Rabbit rabbit = (Rabbit)entity;
                if (isRemovingKillerBunny && rabbit.getRabbitType() == Rabbit.Type.THE_KILLER_BUNNY) {
                    MobRemovalTimerTask.removeEntity(plugin, (Entity)entity);
                    return;
                }
            }
            if (TownySettings.isSkippingRemovalOfNamedMobs() && entity.getCustomName() != null) {
                return;
            }
            if (MobRemovalTimerTask.isSpawnReasonIgnored((Entity)entity)) {
                return;
            }
            MobRemovalTimerTask.removeEntity(plugin, (Entity)entity);
        };
        if (plugin.getScheduler().isEntityThread((Entity)entity)) {
            runnable.run();
        } else {
            plugin.getScheduler().run((Entity)entity, runnable);
        }
    }

    private static void removeEntity(@NotNull Towny plugin, @NotNull Entity entity) {
        if (MobRemovalEvent.getHandlerList().getRegisteredListeners().length > 0 && BukkitTools.isEventCancelled(new MobRemovalEvent(entity))) {
            return;
        }
        if (!plugin.getScheduler().isEntityThread(entity)) {
            plugin.getScheduler().run(entity, () -> ((Entity)entity).remove());
        } else {
            entity.remove();
        }
    }

    private static void populateFields() {
        typesOfWorldMobsToRemove = MobRemovalTimerTask.entityClassesToTypes(EntityTypeUtil.parseLivingEntityClassNames(TownySettings.getWorldMobRemovalEntities(), "WorldMob: "));
        typesOfWildernessMobsToRemove = MobRemovalTimerTask.entityClassesToTypes(EntityTypeUtil.parseLivingEntityClassNames(TownySettings.getWildernessMobRemovalEntities(), "WildernessMob: "));
        typesOfTownMobsToRemove = MobRemovalTimerTask.entityClassesToTypes(EntityTypeUtil.parseLivingEntityClassNames(TownySettings.getTownMobRemovalEntities(), "TownMob: "));
        isRemovingKillerBunny = TownySettings.isRemovingKillerBunny();
        ignoredSpawnReasons.clear();
        for (String cause : TownySettings.getStrArr(ConfigNodes.PROT_MOB_REMOVE_IGNORED_SPAWN_CAUSES)) {
            ignoredSpawnReasons.add(cause.toUpperCase(Locale.ROOT));
        }
    }

    private static Set<EntityType> entityClassesToTypes(List<Class<?>> classes) {
        HashSet<EntityType> types = new HashSet<EntityType>();
        block0: for (EntityType entityType : Registry.ENTITY_TYPE) {
            if (entityType.getEntityClass() == null) continue;
            for (Class<?> clazz : classes) {
                if (!clazz.isAssignableFrom(entityType.getEntityClass())) continue;
                types.add(entityType);
                continue block0;
            }
        }
        return types;
    }

    static {
        MobRemovalTimerTask.populateFields();
        TownySettings.addReloadListener(NamespacedKey.fromString((String)"towny:mob-removal-task"), config -> MobRemovalTimerTask.populateFields());
    }
}

