/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.tasks;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.TownyUpdateChecker;
import com.palmergames.bukkit.towny.event.resident.NewResidentEvent;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.resident.mode.ResidentModeHandler;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.permissions.TownyPerms;
import com.palmergames.bukkit.towny.utils.ResidentUtil;
import com.palmergames.bukkit.towny.utils.TownRuinUtil;
import com.palmergames.bukkit.util.BukkitTools;
import java.util.logging.Level;
import net.kyori.adventure.text.event.ClickEvent;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;

public class OnPlayerLogin
implements Runnable {
    private final Towny plugin;
    private final TownyUniverse universe = TownyUniverse.getInstance();
    private final Player player;
    private final long inviteNotificationTicksDelay = 200L;

    public OnPlayerLogin(Towny plugin, Player player) {
        this.plugin = plugin;
        this.player = player;
    }

    @Override
    public void run() {
        ClickEvent clickEvent;
        Town insideTown;
        Resident resident = this.getResidentReadyToLogIn();
        if (resident == null) {
            return;
        }
        this.loginExistingResident(resident);
        TownyPerms.assignPermissions(resident, this.player);
        Town town = resident.getTownOrNull();
        if (town != null) {
            Nation nation = resident.getNationOrNull();
            if (TownySettings.getShowTownBoardOnLogin() && !town.getBoard().isEmpty()) {
                TownyMessaging.sendTownBoard((CommandSender)this.player, town);
            }
            if (TownySettings.getShowNationBoardOnLogin() && nation != null && !nation.getBoard().isEmpty()) {
                TownyMessaging.sendNationBoard((CommandSender)this.player, nation);
            }
            if (TownyEconomyHandler.isActive() && TownySettings.isTaxingDaily()) {
                Resident finalResident = resident;
                TownyEconomyHandler.economyExecutor().execute(() -> this.bankWarningMessage(finalResident, town, nation));
            }
            if (TownySettings.isOverClaimingAllowingStolenLand() && town.isOverClaimed()) {
                TownyMessaging.sendMsg(resident, Translatable.literal("\u00a74").append(Translatable.of("msg_warning_your_town_is_overclaimed")));
            }
            if (town.isRuined()) {
                TownyMessaging.sendMsg(resident, Translatable.of("msg_warning_your_town_is_ruined_for_x_more_hours", TownySettings.getTownRuinsMaxDurationHours() - TownRuinUtil.getTimeSinceRuining(town)));
            }
            if (this.townHasPendingNationInvites(town)) {
                this.plugin.getScheduler().runLater((Entity)this.player, () -> TownyMessaging.sendMsg((CommandSender)this.player, Translatable.of("msg_your_town_has_pending_nation_invites")), 200L);
            } else if (this.nationHasPendingAllyInvites(nation)) {
                this.plugin.getScheduler().runLater((Entity)this.player, () -> TownyMessaging.sendMsg((CommandSender)this.player, Translatable.of("msg_your_nation_has_pending_ally_invites")), 200L);
            }
        }
        if (this.residentHasPendingTownInvites(resident)) {
            this.plugin.getScheduler().runLater((Entity)this.player, () -> TownyMessaging.sendMsg((CommandSender)this.player, Translatable.of("msg_you_have_pending_town_invites")), 200L);
        }
        if ((insideTown = TownyAPI.getInstance().getTown(this.player.getLocation())) != null && insideTown.hasOutlaw(resident)) {
            ResidentUtil.outlawEnteredTown(resident, insideTown, this.player.getLocation());
        }
        this.plugin.getScheduler().runLater((Entity)this.player, () -> ResidentModeHandler.applyDefaultModes(resident, false), 1L);
        if (TownyUpdateChecker.shouldShowNotification() && this.player.hasPermission(PermissionNodes.TOWNY_ADMIN_UPDATEALERTS.getNode())) {
            clickEvent = ClickEvent.openUrl((String)TownyUpdateChecker.getUpdateURL());
            this.player.sendMessage(Translatable.of("default_towny_prefix").append(Translatable.of("msg_new_update_available", TownyUpdateChecker.getNewVersion(), Towny.getPlugin().getVersion())).locale((CommandSender)this.player).component().clickEvent(clickEvent));
            this.player.sendMessage(Translatable.of("default_towny_prefix").append(Translatable.of("msg_click_to_download")).locale((CommandSender)this.player).component().clickEvent(clickEvent));
        }
        if (TownyEconomyHandler.isActive() && TownyEconomyHandler.getProvider().isLegacy() && this.player.hasPermission(PermissionNodes.TOWNY_ADMIN_UPDATEALERTS.getNode())) {
            clickEvent = ClickEvent.runCommand((String)"/townyadmin eco convert modern");
            this.player.sendMessage(Translatable.of("default_towny_prefix").append(Translatable.of("msg_legacy_economy_detected")).locale((CommandSender)this.player).component().clickEvent(clickEvent));
            this.player.sendMessage(Translatable.of("default_towny_prefix").append(Translatable.of("msg_click_to_convert_to_modern_economy")).locale((CommandSender)this.player).component().clickEvent(clickEvent));
        }
    }

    private Resident getResidentReadyToLogIn() {
        Resident resident = this.universe.getResident(this.player.getUniqueId());
        if (resident != null) {
            this.checkForNameChangeSinceLastLogIn(resident);
            return this.universe.getResident(this.player.getUniqueId());
        }
        resident = this.universe.getResident(this.player.getName());
        if (resident != null && !resident.hasUUID()) {
            return resident;
        }
        if (resident != null && !resident.getUUID().equals(this.player.getUniqueId())) {
            try {
                this.universe.unregisterResident(resident);
                resident.setUUID(this.player.getUniqueId());
                this.universe.registerResident(resident);
            }
            catch (AlreadyRegisteredException | NotRegisteredException townyException) {
                // empty catch block
            }
            return resident;
        }
        return this.createNewResident(resident);
    }

    private void checkForNameChangeSinceLastLogIn(Resident resident) {
        if (!resident.getName().equals(this.player.getName())) {
            try {
                this.universe.getDataSource().renamePlayer(resident, this.player.getName());
            }
            catch (AlreadyRegisteredException | NotRegisteredException e) {
                this.plugin.getLogger().log(Level.WARNING, "An exception occurred when trying to rename " + resident.getName() + " to " + this.player.getName(), e);
            }
        }
    }

    private Resident createNewResident(Resident resident) {
        try {
            resident = this.universe.getDataSource().newResident(this.player.getName(), this.player.getUniqueId());
            resident.setRegistered(System.currentTimeMillis());
            Resident finalResident = resident;
            this.universe.getDataSource().getHibernatedResidentRegistered(this.player.getUniqueId()).thenAccept(registered -> {
                if (registered.isPresent()) {
                    finalResident.setRegistered((Long)registered.get());
                    finalResident.save();
                }
            });
            resident.setLastOnline(System.currentTimeMillis());
            this.assignDefaultTownIfRequired(resident);
            resident.save();
            this.plugin.getScheduler().run((Entity)this.player, () -> BukkitTools.fireEvent(new NewResidentEvent(finalResident)));
        }
        catch (NotRegisteredException e) {
            this.plugin.getLogger().log(Level.WARNING, "Could not register resident '" + this.player.getName() + "' (" + String.valueOf(this.player.getUniqueId()) + ") due to an error, Towny features might be limited for this player until it is resolved", e);
        }
        catch (AlreadyRegisteredException alreadyRegisteredException) {
            // empty catch block
        }
        return resident;
    }

    private void assignDefaultTownIfRequired(Resident resident) {
        Town town = TownyUniverse.getInstance().getTown(TownySettings.getDefaultTownName());
        if (town == null) {
            return;
        }
        try {
            resident.setTown(town);
        }
        catch (AlreadyRegisteredException alreadyRegisteredException) {
            // empty catch block
        }
    }

    private void loginExistingResident(Resident resident) {
        this.plugin.getScheduler().runLater((Entity)this.player, () -> {
            if (this.player.getMetadata("vanished").stream().noneMatch(MetadataValue::asBoolean)) {
                resident.setLastOnline(System.currentTimeMillis());
            }
            if (!resident.hasUUID()) {
                resident.setUUID(this.player.getUniqueId());
                try {
                    TownyUniverse.getInstance().registerResidentUUID(resident);
                }
                catch (AlreadyRegisteredException e) {
                    this.plugin.getLogger().log(Level.WARNING, "uuid for resident " + resident.getName() + " was already registered! (" + String.valueOf(this.player.getUniqueId()) + ")", e);
                }
            }
            resident.save();
        }, 5L);
    }

    private void bankWarningMessage(Resident resident, Town town, Nation nation) {
        double upkeep;
        if (town.hasUpkeep() && (upkeep = TownySettings.getTownUpkeepCost(town)) > 0.0 && !town.getAccount().canPayFromHoldings(upkeep)) {
            if (TownySettings.isTownBankruptcyEnabled()) {
                Translatable msg = !town.isBankrupt() ? Translatable.of("msg_warning_bankrupt", town.getName()) : Translatable.of("msg_your_town_is_bankrupt");
                TownyMessaging.sendMsg(resident, msg);
            } else {
                TownyMessaging.sendMsg(resident, Translatable.of("msg_warning_delete", town.getName()));
            }
            TownyMessaging.sendMsg(resident, Translatable.of("msg_warning_town_deposit_hint"));
        }
        if (nation != null && (upkeep = TownySettings.getNationUpkeepCost(nation)) > 0.0 && !nation.getAccount().canPayFromHoldings(upkeep)) {
            TownyMessaging.sendMsg(resident, Translatable.of("msg_warning_delete", nation.getName()));
            TownyMessaging.sendMsg(resident, Translatable.of("msg_warning_nation_deposit_hint"));
        }
    }

    private boolean nationHasPendingAllyInvites(Nation nation) {
        return nation != null && !nation.getReceivedInvites().isEmpty() && this.universe.getPermissionSource().testPermission((Permissible)this.player, PermissionNodes.TOWNY_COMMAND_NATION_ALLY_ACCEPT.getNode());
    }

    private boolean townHasPendingNationInvites(Town town) {
        return !town.hasNation() && !town.getReceivedInvites().isEmpty() && this.universe.getPermissionSource().testPermission((Permissible)this.player, PermissionNodes.TOWNY_COMMAND_TOWN_INVITE_ACCEPT.getNode());
    }

    private boolean residentHasPendingTownInvites(Resident resident) {
        return !resident.hasTown() && !resident.getReceivedInvites().isEmpty() && this.universe.getPermissionSource().testPermission((Permissible)this.player, PermissionNodes.TOWNY_TOWN_RESIDENT.getNode());
    }
}

