/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.tasks;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.EconomyHandler;
import com.palmergames.bukkit.towny.object.PlotGroup;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.WorldCoord;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class PlotClaim
implements Runnable {
    Towny plugin;
    private final Player player;
    private final Resident resident;
    private final List<WorldCoord> selection;
    private final boolean claim;
    private final boolean admin;
    private final boolean groupClaim;

    public PlotClaim(Towny plugin, Player player, Resident resident, List<WorldCoord> selection, boolean claim, boolean admin, boolean groupClaim) {
        this.plugin = plugin;
        this.player = player;
        this.resident = resident;
        this.selection = selection;
        this.claim = claim;
        this.admin = admin;
        this.groupClaim = groupClaim;
    }

    @Override
    public void run() {
        if (this.player != null) {
            if (this.claim) {
                TownyMessaging.sendMsg((CommandSender)this.player, Translatable.of("msg_process_claim"));
            } else {
                TownyMessaging.sendMsg((CommandSender)this.player, Translatable.of("msg_process_unclaim"));
            }
        }
        if (this.selection == null && !this.claim) {
            this.residentUnclaimAll();
            return;
        }
        if (this.groupClaim) {
            this.handleGroupClaim(this.selection.get(0));
            return;
        }
        if (this.admin) {
            this.adminClaim(this.selection);
            return;
        }
        if (!this.claim) {
            this.residentUnclaim(this.selection);
            return;
        }
        if (this.claim) {
            this.residentClaim(this.selection);
            return;
        }
    }

    private void handleGroupClaim(WorldCoord worldCoord) {
        TownBlock townBlock = worldCoord.getTownBlockOrNull();
        if (townBlock == null || !townBlock.hasPlotObjectGroup()) {
            return;
        }
        PlotGroup group = townBlock.getPlotObjectGroup();
        try {
            this.testMaxPlotsOrThrow(group.getTownBlocks().size());
            double groupPrice = group.getPrice();
            if (TownyEconomyHandler.isActive() && groupPrice > 0.0) {
                Town town;
                double bankcap;
                TownyObject seller = group.hasResident() ? group.getResident() : group.getTown();
                String message = String.format("Plot Group - Buy From %s: %s", group.hasResident() ? "Seller" : "Town", seller.getName());
                if (seller instanceof Town && (bankcap = (town = (Town)seller).getBankCap()) > 0.0 && groupPrice + town.getAccount().getHoldingBalance() > bankcap) {
                    throw new TownyException(Translatable.of("msg_err_deposit_capped", bankcap));
                }
                if (!this.resident.getAccount().payTo(groupPrice, (EconomyHandler)((Object)seller), message)) {
                    throw new TownyException(Translatable.of("msg_no_money_purchase_plot"));
                }
            }
        }
        catch (TownyException e) {
            TownyMessaging.sendErrorMsg(this.player, e.getMessage((CommandSender)this.player));
            return;
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg(this.player, e.getMessage());
            return;
        }
        this.residentGroupClaim(group);
        group.setResident(this.resident);
        group.setPrice(-1.0);
        TownyMessaging.sendPrefixedTownMessage(townBlock.getTownOrNull(), Translatable.of("msg_player_successfully_bought_group_x", this.player.getName(), group.getName()));
        group.save();
        this.finishWithMessage();
    }

    private void residentGroupClaim(PlotGroup group) {
        Town town = group.getTown();
        @Nullable Resident owner = group.getResident();
        if (owner != null && group.getPrice() > 0.0) {
            TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_buy_resident_plot_group", this.resident.getName(), owner.getName(), group.getPrice()));
        }
        for (TownBlock townBlock : group.getTownBlocks()) {
            this.claimTownBlockForResident(townBlock);
        }
    }

    private void residentClaim(List<WorldCoord> selection) {
        for (int i = 0; i < selection.size(); ++i) {
            WorldCoord worldCoord = selection.get(i);
            try {
                if (this.residentClaim(worldCoord)) continue;
                selection.remove(i);
                --i;
                continue;
            }
            catch (TownyException e) {
                TownyMessaging.sendErrorMsg(this.player, e.getMessage((CommandSender)this.player));
            }
        }
        this.finishWithMessage();
    }

    private boolean residentClaim(WorldCoord worldCoord) throws TownyException {
        Resident owner;
        TownBlock townBlock = worldCoord.getTownBlockOrNull();
        if (townBlock == null) {
            throw new TownyException(Translatable.of("msg_err_not_part_town"));
        }
        if (townBlock.getPlotPrice() == -1.0) {
            throw new TownyException(Translatable.of("msg_err_plot_nfs"));
        }
        Town town = townBlock.getTownOrNull();
        if (!townBlock.getType().equals(TownBlockType.EMBASSY) && !town.hasResident(this.resident)) {
            throw new TownyException(Translatable.of("msg_err_not_part_town"));
        }
        this.testMaxPlotsOrThrow(1);
        double price = townBlock.getPlotPrice();
        if (TownyEconomyHandler.isActive() && price > 0.0) {
            double bankcap;
            TownyObject seller = townBlock.hasResident() ? townBlock.getResidentOrNull() : townBlock.getTownOrNull();
            String message = String.format("Plot - Buy From %s: %s", townBlock.hasResident() ? "Seller" : "Town", seller.getName());
            if (seller instanceof Town && (bankcap = town.getBankCap()) > 0.0 && price + town.getAccount().getHoldingBalance() > bankcap) {
                throw new TownyException(Translatable.of("msg_err_deposit_capped", bankcap));
            }
            if (!this.resident.getAccount().payTo(price, (EconomyHandler)((Object)seller), message)) {
                throw new TownyException(Translatable.of("msg_no_money_purchase_plot"));
            }
        }
        if ((owner = townBlock.getResidentOrNull()) != null && price > 0.0) {
            TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_buy_resident_plot", this.resident.getName(), owner.getName(), townBlock.getPlotPrice()));
        }
        return this.claimTownBlockForResident(townBlock);
    }

    private boolean claimTownBlockForResident(TownBlock townBlock) {
        if (!townBlock.setResident(this.resident)) {
            return false;
        }
        townBlock.setPlotPrice(-1.0);
        townBlock.setType(townBlock.getType());
        townBlock.save();
        this.plugin.updateCache(townBlock.getWorldCoord());
        return true;
    }

    private void residentUnclaimAll() {
        this.residentUnclaim(new ArrayList<TownBlock>(this.resident.getTownBlocks()).stream().map(TownBlock::getWorldCoord).collect(Collectors.toList()));
    }

    private void residentUnclaim(List<WorldCoord> selection) {
        for (int i = 0; i < selection.size(); ++i) {
            WorldCoord coord = selection.get(i);
            if (!TownyAPI.getInstance().isTownyWorld(coord.getBukkitWorld()) || this.residentUnclaim(coord)) continue;
            TownyMessaging.sendErrorMsg((CommandSender)this.player, Translatable.of("msg_not_own_place"));
            selection.remove(i);
            --i;
        }
        this.finishWithMessage();
    }

    private boolean residentUnclaim(WorldCoord worldCoord) {
        if (worldCoord.isWilderness()) {
            return false;
        }
        TownBlock townBlock = worldCoord.getTownBlockOrNull();
        if (!townBlock.removeResident()) {
            return false;
        }
        townBlock.setPlotPrice(townBlock.getTownOrNull().getPlotTypePrice(townBlock.getType()));
        townBlock.setType(townBlock.getType());
        townBlock.save();
        this.plugin.updateCache(worldCoord);
        return true;
    }

    private void adminClaim(List<WorldCoord> selection) {
        for (WorldCoord wc : new ArrayList<WorldCoord>(selection)) {
            if (this.adminClaim(wc)) continue;
            TownyMessaging.sendErrorMsg((CommandSender)this.player, Translatable.of("msg_not_claimed", wc.toString()));
            this.selection.remove(wc);
        }
        this.finishWithMessage();
    }

    private boolean adminClaim(WorldCoord worldCoord) {
        if (worldCoord.isWilderness()) {
            return false;
        }
        TownBlock townBlock = worldCoord.getTownBlockOrNull();
        townBlock.setPlotPrice(-1.0);
        if (!townBlock.setResident(this.resident)) {
            return false;
        }
        townBlock.setType(townBlock.getType());
        townBlock.save();
        this.plugin.updateCache(worldCoord);
        TownyMessaging.sendMsg(this.resident, Translatable.of("msg_admin_has_given_you_a_plot", worldCoord.toString()));
        return true;
    }

    private void finishWithMessage() {
        if (this.player == null) {
            return;
        }
        if (this.claim) {
            if (this.selection != null && this.selection.size() > 0) {
                TownyMessaging.sendMsg((CommandSender)this.player, Translatable.of("msg_claimed").append(" ").append((String)(this.selection.size() > 5 ? Translatable.of("msg_total_townblocks").forLocale((CommandSender)this.player) + this.selection.size() : Arrays.toString(this.selection.toArray(new WorldCoord[0])))));
            } else {
                TownyMessaging.sendMsg((CommandSender)this.player, Translatable.of("msg_not_claimed_1"));
            }
        } else if (this.selection != null) {
            TownyMessaging.sendMsg((CommandSender)this.player, Translatable.of("msg_unclaimed").append(" ").append((String)(this.selection.size() > 5 ? Translatable.of("msg_total_townblocks").forLocale((CommandSender)this.player) + this.selection.size() : Arrays.toString(this.selection.toArray(new WorldCoord[0])))));
        } else {
            TownyMessaging.sendMsg((CommandSender)this.player, Translatable.of("msg_unclaimed"));
        }
    }

    private void testMaxPlotsOrThrow(int plotsToBuy) throws TownyException {
        int maxPlots = TownySettings.getMaxResidentPlots(this.resident);
        int extraPlots = TownySettings.getMaxResidentExtraPlots(this.resident);
        if (maxPlots != -1) {
            maxPlots += extraPlots;
        }
        if (maxPlots >= 0 && this.resident.getTownBlocks().size() + plotsToBuy > maxPlots) {
            throw new TownyException(Translatable.of("msg_max_plot_own", maxPlots));
        }
    }
}

