/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.tasks;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.hooks.PluginIntegrations;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.regen.TownyRegenAPI;
import com.palmergames.bukkit.towny.regen.block.BlockLocation;
import com.palmergames.bukkit.towny.scheduling.ScheduledTask;
import com.palmergames.bukkit.towny.tasks.TownyTimerTask;
import net.coreprotect.CoreProtect;
import org.bukkit.Material;
import org.bukkit.block.Banner;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.BlockInventoryHolder;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class ProtectionRegenTask
extends TownyTimerTask {
    private final BlockState state;
    private BlockLocation blockLocation;
    private ScheduledTask task;
    private ItemStack[] contents;

    public ProtectionRegenTask(Towny plugin, Block block) {
        super(plugin);
        this.state = block.getState();
        this.setBlockLocation(new BlockLocation(block.getLocation()));
        if (this.state instanceof BlockInventoryHolder) {
            BlockInventoryHolder container = (BlockInventoryHolder)this.state;
            Inventory inventory = container.getInventory();
            if (this.state instanceof Chest) {
                inventory = ((Chest)this.state).getBlockInventory();
            }
            this.contents = (ItemStack[])inventory.getContents().clone();
            inventory.clear();
        }
    }

    @Override
    public void run() {
        this.state.getWorld().getChunkAtAsync(this.state.getLocation()).thenRun(() -> this.plugin.getScheduler().run(this.state.getLocation(), this::replaceProtections));
        TownyRegenAPI.removeProtectionRegenTask(this);
    }

    public void replaceProtections() {
        boolean logWithCoreProtect;
        if (this.unreplaceableBlockHasAppeared()) {
            return;
        }
        Block block = this.state.getBlock();
        boolean bl = logWithCoreProtect = TownySettings.coreProtectSupport() && PluginIntegrations.getInstance().isPluginEnabled("CoreProtect");
        if (logWithCoreProtect && !block.getType().isAir()) {
            CoreProtect.getInstance().getAPI().logRemoval("#towny", block.getLocation(), block.getType(), block.getBlockData());
        }
        BlockData blockData = this.state.getBlockData().clone();
        block.setType(this.state.getType(), false);
        block.setBlockData(blockData);
        if (logWithCoreProtect && !this.state.getType().isAir()) {
            CoreProtect.getInstance().getAPI().logPlacement("#towny", this.state.getLocation(), this.state.getType(), blockData);
        }
        if (this.state instanceof CreatureSpawner) {
            CreatureSpawner spawner = (CreatureSpawner)this.state;
            EntityType type = spawner.getSpawnedType();
            ((CreatureSpawner)this.state).setSpawnedType(type);
            this.state.update();
        }
        if (this.state instanceof BlockInventoryHolder) {
            BlockInventoryHolder container = (BlockInventoryHolder)this.state;
            if (container instanceof Chest) {
                ((Chest)this.state).getBlockInventory().setContents(this.contents);
            } else {
                ((BlockInventoryHolder)this.state).getInventory().setContents(this.contents);
            }
            this.state.update();
        }
        if (this.state instanceof Banner) {
            Banner banner = (Banner)this.state;
            ((Banner)this.state).setPatterns(banner.getPatterns());
            this.state.update();
        }
    }

    private boolean unreplaceableBlockHasAppeared() {
        Block block = this.blockLocation.getBlock();
        if (block.getType() == Material.AIR || !TownyAPI.getInstance().isWilderness(block)) {
            return false;
        }
        TownyWorld world = TownyAPI.getInstance().getTownyWorld(this.blockLocation.getWorld());
        return world != null && world.isMaterialNotAllowedToBeOverwrittenByWildRevert(block.getType());
    }

    public BlockLocation getBlockLocation() {
        return this.blockLocation;
    }

    private void setBlockLocation(BlockLocation blockLocation) {
        this.blockLocation = blockLocation;
    }

    public BlockState getState() {
        return this.state;
    }

    public ScheduledTask getTask() {
        return this.task;
    }

    public void setTask(ScheduledTask task) {
        this.task = task;
    }
}

