/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.tasks;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.regen.PlotBlockData;
import com.palmergames.bukkit.towny.regen.TownyRegenAPI;
import com.palmergames.bukkit.towny.regen.WorldCoordEntityRemover;
import com.palmergames.bukkit.towny.regen.WorldCoordMaterialRemover;
import com.palmergames.bukkit.towny.tasks.TownyTimerTask;

public class RepeatingTimerTask
extends TownyTimerTask {
    private Long timerCounter = 0L;

    public RepeatingTimerTask(Towny plugin) {
        super(plugin);
    }

    @Override
    public void run() {
        if (TownyRegenAPI.hasActiveRegenerations()) {
            this.revertAnotherBlockToWilderness();
        }
        if (WorldCoordEntityRemover.hasQueue()) {
            this.tryDeleteTownBlockEntityQueue();
        }
        if (WorldCoordMaterialRemover.hasQueue()) {
            this.tryDeleteTownBlockMaterials();
        }
    }

    private void revertAnotherBlockToWilderness() {
        this.timerCounter = this.timerCounter + 1L;
        if (Math.max(1L, TownySettings.getPlotManagementSpeed()) > this.timerCounter) {
            return;
        }
        for (PlotBlockData plotBlockData : TownyRegenAPI.getActivePlotBlockDatas()) {
            if (plotBlockData == null) continue;
            this.plugin.getScheduler().run(plotBlockData.getWorldCoord().getLowerMostCornerLocation(), () -> {
                if (!plotBlockData.restoreNextBlock()) {
                    TownyRegenAPI.finishPlotBlockData(plotBlockData);
                }
            });
        }
        this.timerCounter = 0L;
    }

    private void tryDeleteTownBlockEntityQueue() {
        if (WorldCoordEntityRemover.getActiveQueueSize() >= 10) {
            return;
        }
        WorldCoord wc = WorldCoordEntityRemover.getWorldCoordFromQueue();
        if (wc == null) {
            return;
        }
        WorldCoordEntityRemover.doDeleteTownBlockEntities(wc);
    }

    private void tryDeleteTownBlockMaterials() {
        if (WorldCoordMaterialRemover.getActiveQueueSize() >= 10) {
            return;
        }
        WorldCoord wc = WorldCoordMaterialRemover.getWorldCoordFromQueue();
        if (wc == null) {
            return;
        }
        this.plugin.getScheduler().runAsync(() -> WorldCoordMaterialRemover.queueUnclaimMaterialsDeletion(wc));
    }
}

