/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.tasks;

import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.util.BukkitTools;
import java.util.ArrayList;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.Nullable;

public class ResidentPurge
implements Runnable {
    private final CommandSender sender;
    private final long deleteTime;
    private final boolean townless;
    private final Town town;
    private final boolean removeTown;

    public ResidentPurge(CommandSender sender, long deleteTime, boolean townless, @Nullable Town town, boolean removeTown) {
        this.deleteTime = deleteTime;
        this.townless = townless;
        this.sender = sender;
        this.town = town;
        this.removeTown = removeTown;
    }

    public ResidentPurge(CommandSender sender, long deleteTime, boolean townless, @Nullable Town town) {
        this(sender, deleteTime, townless, town, TownySettings.isDeletingOldResidentsRemovingTownOnly());
    }

    @Override
    public void run() {
        int count = 0;
        this.message(Translatable.of("msg_scanning_for_old_residents"));
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        ArrayList<Resident> residentList = this.town != null ? new ArrayList(this.town.getResidents()) : new ArrayList<Resident>(townyUniverse.getResidents());
        for (Resident resident : residentList) {
            if (resident.isNPC() || System.currentTimeMillis() - resident.getLastOnline() <= this.deleteTime || BukkitTools.isOnline(resident.getName()) || this.townless && resident.hasTown()) continue;
            if (this.removeTown && resident.hasTown()) {
                resident.removeTown();
                ++count;
                continue;
            }
            townyUniverse.getDataSource().removeResident(resident);
            if (++count < 50) {
                this.message(Translatable.of("msg_deleting_resident", resident.getName()));
            }
            if (count != 50) continue;
            this.message(Translatable.of("msg_purge_reached_50_residents"));
        }
        this.message(Translatable.of(this.townless ? "msg_purge_complete_x_removed_from_towns" : "msg_purge_complete", count));
    }

    private void message(Translatable msg) {
        if (this.sender != null) {
            TownyMessaging.sendMsg(this.sender, msg);
        } else {
            TownyMessaging.sendMsg(msg);
        }
    }
}

