/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.tasks;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyTimerHandler;
import com.palmergames.bukkit.towny.event.teleport.CancelledTownyTeleportEvent;
import com.palmergames.bukkit.towny.event.teleport.SuccessfulTownyTeleportEvent;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.TeleportRequest;
import com.palmergames.bukkit.towny.object.TeleportWarmupParticle;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.object.economy.Account;
import com.palmergames.bukkit.towny.tasks.CooldownTimerTask;
import com.palmergames.bukkit.towny.tasks.TownyTimerTask;
import com.palmergames.bukkit.towny.utils.SpawnUtil;
import com.palmergames.bukkit.util.BukkitTools;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TeleportWarmupTimerTask
extends TownyTimerTask {
    private static final Map<Resident, TeleportRequest> TELEPORT_QUEUE = new ConcurrentHashMap<Resident, TeleportRequest>();

    public TeleportWarmupTimerTask(Towny plugin) {
        super(plugin);
    }

    @Override
    public void run() {
        long currentTime = System.currentTimeMillis();
        int teleportWarmupTime = TownySettings.getTeleportWarmupTime();
        Iterator<Map.Entry<Resident, TeleportRequest>> iterator = TELEPORT_QUEUE.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Resident, TeleportRequest> next = iterator.next();
            Resident resident = next.getKey();
            TeleportRequest request = next.getValue();
            long teleportTime = request.requestTime() + (long)teleportWarmupTime * 1000L;
            if (currentTime > teleportTime) {
                iterator.remove();
                Player player = resident.getPlayer();
                if (player == null) continue;
                SpawnUtil.addAndRemoveChunkTicket(WorldCoord.parseWorldCoord(player.getLocation()));
                Location prior = player.getLocation();
                player.teleportAsync(request.destinationLocation(), PlayerTeleportEvent.TeleportCause.COMMAND).thenAccept(successfulTeleport -> {
                    if (successfulTeleport.booleanValue()) {
                        BukkitTools.fireEvent(new SuccessfulTownyTeleportEvent(resident, request.destinationLocation(), request.teleportCost(), prior));
                    }
                });
                if (request.cooldown() <= 0) continue;
                CooldownTimerTask.addCooldownTimer(resident.getName(), "teleport", request.cooldown());
                continue;
            }
            long millis = teleportTime - currentTime;
            int seconds = (int)Math.max(1L, millis / 1000L);
            if (TownySettings.isTeleportWarmupUsingTitleMessage() && millis >= 1000L) {
                String title = TownySettings.isMovementCancellingSpawnWarmup() ? Translatable.of("teleport_warmup_title_dont_move").forLocale(resident) : "";
                String subtitle = Translatable.of("teleport_warmup_subtitle_seconds_remaining", seconds).forLocale(resident);
                resident.getPlayer().sendTitle(title, subtitle, 0, 25, seconds == 1 ? 15 : 0);
            }
            if (!TownySettings.isTeleportWarmupShowingParticleEffect()) continue;
            double progress = (double)(teleportWarmupTime - seconds) / (double)teleportWarmupTime;
            double yOffset = 2.0 + progress * -2.0;
            TeleportWarmupParticle.drawParticles(resident.getPlayer(), yOffset);
        }
    }

    public static void requestTeleport(Resident resident, Location spawnLoc) {
        TeleportWarmupTimerTask.requestTeleport(resident, spawnLoc, 0);
    }

    public static void requestTeleport(Resident resident, Location spawnLoc, int cooldown) {
        TeleportWarmupTimerTask.requestTeleport(resident, spawnLoc, cooldown, null, 0.0);
    }

    public static void requestTeleport(@NotNull Resident resident, @NotNull Location destination, int cooldown, @Nullable Account teleportAccount, double teleportCost) {
        TeleportRequest request = TeleportRequest.teleportRequest(System.currentTimeMillis(), destination, cooldown, teleportCost, teleportAccount);
        TELEPORT_QUEUE.put(resident, request);
    }

    @Contract(value="null -> false")
    public static boolean abortTeleportRequest(@Nullable Resident resident) {
        return TeleportWarmupTimerTask.abortTeleportRequest(resident, CancelledTownyTeleportEvent.CancelledTeleportReason.UNKNOWN);
    }

    @Contract(value="null, _ -> false")
    public static boolean abortTeleportRequest(@Nullable Resident resident, CancelledTownyTeleportEvent.CancelledTeleportReason reason) {
        if (resident == null) {
            return false;
        }
        TeleportRequest request = TELEPORT_QUEUE.remove(resident);
        if (request == null) {
            return false;
        }
        if (request.teleportCost() != 0.0 && TownyEconomyHandler.isActive() && request.teleportAccount() != null) {
            TownyEconomyHandler.economyExecutor().execute(() -> request.teleportAccount().payTo(request.teleportCost(), resident, Translation.of("msg_cost_spawn_refund")));
            TownyMessaging.sendMsg(resident, Translatable.of("msg_cost_spawn_refund"));
        }
        BukkitTools.fireEvent(new CancelledTownyTeleportEvent(resident, request.destinationLocation(), request.teleportCost(), reason));
        return true;
    }

    public static boolean hasTeleportRequest(@NotNull Resident resident) {
        return TELEPORT_QUEUE.containsKey(resident);
    }

    public static TeleportRequest getTeleportRequest(@NotNull Resident resident) {
        return TELEPORT_QUEUE.get(resident);
    }

    static {
        TownySettings.addReloadListener(NamespacedKey.fromString((String)"towny:warmup-task"), () -> TownyTimerHandler.toggleTeleportWarmup(TownySettings.getTeleportWarmupTime() > 0));
    }
}

