/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.tasks;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.confirmations.Confirmation;
import com.palmergames.bukkit.towny.event.TownClaimEvent;
import com.palmergames.bukkit.towny.event.town.TownPreUnclaimEvent;
import com.palmergames.bukkit.towny.event.town.TownUnclaimEvent;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.regen.PlotBlockData;
import com.palmergames.bukkit.towny.regen.TownyRegenAPI;
import com.palmergames.bukkit.towny.tasks.CooldownTimerTask;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.util.TimeMgmt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TownClaim
implements Runnable {
    private static final Lock lock = new ReentrantLock(true);
    private final Towny plugin;
    private final Player player;
    private Location outpostLocation;
    private final Town town;
    private final List<WorldCoord> selection;
    private boolean outpost;
    private final boolean claim;
    private final boolean forced;
    private double runningRefund = 0.0;
    private double insufficientFunds = 0.0;
    private boolean successfulRun = false;
    private boolean isOverClaim = false;

    public TownClaim(Towny plugin, Player player, Town town, List<WorldCoord> selection, boolean isOutpost, boolean claim, boolean forced) {
        this.plugin = plugin;
        this.player = player;
        if (this.player != null) {
            this.outpostLocation = player.getLocation();
        }
        this.town = town;
        this.selection = selection;
        this.outpost = isOutpost;
        this.claim = claim;
        this.forced = forced;
        this.runningRefund = 0.0;
    }

    public TownClaim(Towny plugin, Player player, Town town, List<WorldCoord> selection, boolean isOutpost, boolean claim, boolean forced, boolean isOverClaim) {
        this.plugin = plugin;
        this.player = player;
        if (this.player != null) {
            this.outpostLocation = player.getLocation();
        }
        this.town = town;
        this.selection = selection;
        this.outpost = isOutpost;
        this.claim = claim;
        this.forced = forced;
        this.runningRefund = 0.0;
        this.isOverClaim = isOverClaim;
    }

    @Override
    public void run() {
        lock.lock();
        try {
            if (this.player != null) {
                TownyMessaging.sendMsg((CommandSender)this.player, this.claim ? Translatable.of("msg_process_town_claim") : Translatable.of("msg_process_town_unclaim"));
            }
            if (this.selection != null) {
                this.processSelection();
            } else if (!this.claim) {
                this.runUnclaimAll();
            }
            if (this.successfulRun) {
                if (this.town != null) {
                    this.town.save();
                }
                this.plugin.resetCache();
                this.sendFeedback();
            }
        }
        finally {
            lock.unlock();
        }
    }

    private void processSelection() {
        ArrayList<WorldCoord> disallowedWorldCoords = new ArrayList<WorldCoord>();
        for (WorldCoord worldCoord : this.selection) {
            try {
                if (this.claim) {
                    this.townClaim(worldCoord);
                } else {
                    this.townUnclaim(worldCoord);
                }
                this.successfulRun = true;
            }
            catch (TownyException x) {
                TownyMessaging.sendErrorMsg(this.player, x.getMessage((CommandSender)this.player));
                disallowedWorldCoords.add(worldCoord);
            }
        }
        if (!disallowedWorldCoords.isEmpty()) {
            if (this.insufficientFunds != 0.0) {
                TownyMessaging.sendErrorMsg((CommandSender)this.player, Translatable.of("msg_err_your_town_cannot_afford_unclaim", TownyEconomyHandler.getFormattedBalance(this.insufficientFunds)));
            }
            for (WorldCoord remove : disallowedWorldCoords) {
                this.selection.remove(remove);
            }
        }
        if (!this.claim && this.selection.size() > 0 && this.runningRefund != 0.0) {
            TownyEconomyHandler.economyExecutor().execute(() -> this.refundForUnclaim(this.runningRefund, this.selection.size()));
        }
    }

    private void runUnclaimAll() {
        if (this.town == null) {
            TownyMessaging.sendErrorMsg((CommandSender)this.player, Translatable.of("msg_err_nothing_to_unclaim"));
            return;
        }
        Confirmation.runOnAccept(() -> {
            try {
                this.townUnclaimAll(this.town);
            }
            catch (TownyException e) {
                TownyMessaging.sendErrorMsg(this.player, e.getMessage((CommandSender)this.player));
                return;
            }
            if (TownyEconomyHandler.isActive() && this.runningRefund != 0.0) {
                TownyEconomyHandler.economyExecutor().execute(() -> this.refundForUnclaim(this.runningRefund, this.town.getTownBlocks().size() - 1));
            }
            this.successfulRun = true;
            TownyMessaging.sendMsg((CommandSender)this.player, Translatable.of("msg_you_have_unclaimed_everything_but_your_homeblock"));
        }).setTitle(Translatable.of("confirmation_did_you_want_to_unclaim_all")).sendTo((CommandSender)this.player);
    }

    private void sendFeedback() {
        if (this.player != null && this.selection.size() > 0) {
            String feedbackSlug;
            String string = feedbackSlug = this.selection.size() > 5 ? "Total TownBlocks: " + this.selection.size() : Arrays.toString(this.selection.toArray(new WorldCoord[0]));
            if (this.claim) {
                TownyMessaging.sendMsg((CommandSender)this.player, Translatable.of("msg_annexed_area", feedbackSlug));
            } else if (this.forced) {
                TownyMessaging.sendMsg((CommandSender)this.player, Translatable.of("msg_admin_unclaim_area", feedbackSlug));
            } else {
                TownyMessaging.sendMsg((CommandSender)this.player, Translatable.of("msg_abandoned_area", feedbackSlug));
            }
        } else if (this.town != null && this.selection == null) {
            TownyMessaging.sendPrefixedTownMessage(this.town, Translatable.of("msg_abandoned_area_1"));
        }
    }

    private void townClaim(WorldCoord worldCoord) throws TownyException {
        TownBlock townBlock;
        boolean alreadyClaimed = worldCoord.hasTownBlock();
        if (alreadyClaimed && !worldCoord.canBeStolen()) {
            throw new TownyException(Translatable.of("msg_already_claimed", worldCoord.getTownOrNull().getName()));
        }
        TownBlock townBlock2 = townBlock = !alreadyClaimed ? new TownBlock(worldCoord) : worldCoord.getTownBlockOrNull();
        if (alreadyClaimed) {
            if (TownySettings.getOverclaimingCommandCooldownInSeconds() > 0 && CooldownTimerTask.hasCooldown(this.town.getUUID().toString(), "overclaimingcooldown")) {
                long req = CooldownTimerTask.getCooldownRemaining(this.town.getUUID().toString(), "overclaimingcooldown") * 1000;
                throw new TownyException(Translatable.of("msg_err_your_cannot_overclaim_for_another", TimeMgmt.getFormattedTimeValue(req)));
            }
            Town oldTown = worldCoord.getTownOrNull();
            BukkitTools.fireEvent(new TownUnclaimEvent(oldTown, worldCoord, this.isOverClaim));
            if (townBlock.hasResident()) {
                townBlock.setResident(null, false);
            }
            oldTown.save();
            if (TownySettings.getOverclaimingCommandCooldownInSeconds() > 0) {
                CooldownTimerTask.addCooldownTimer(this.town.getUUID().toString(), "overclaimingcooldown", TownySettings.getOverclaimingCommandCooldownInSeconds());
            }
        }
        townBlock.setTown(this.town);
        townBlock.setType(!alreadyClaimed ? townBlock.getType() : TownBlockType.RESIDENTIAL);
        if (this.outpost) {
            townBlock.setOutpost(true);
            this.town.addOutpostSpawn(this.outpostLocation);
            this.outpost = false;
        }
        if (!alreadyClaimed) {
            this.handleRevertOnUnclaimPossiblities(worldCoord, townBlock);
        }
        townBlock.save();
        BukkitTools.fireEvent(new TownClaimEvent(townBlock, this.player, this.isOverClaim));
    }

    private void handleRevertOnUnclaimPossiblities(WorldCoord worldCoord, TownBlock townBlock) {
        if (!worldCoord.getTownyWorld().isUsingPlotManagementRevert() || TownySettings.getPlotManagementSpeed() == 0L) {
            return;
        }
        if (TownyRegenAPI.getRegenQueueList().contains(worldCoord)) {
            PlotBlockData plotChunk = TownyRegenAPI.getPlotChunk(townBlock);
            if (plotChunk != null) {
                TownyRegenAPI.removeFromActiveRegeneration(plotChunk);
            }
            TownyRegenAPI.removeFromRegenQueueList(worldCoord);
        }
        if (!TownyUniverse.getInstance().getDataSource().hasPlotData(townBlock)) {
            this.plugin.getScheduler().runAsync(() -> TownyRegenAPI.handleNewSnapshot(townBlock));
        }
    }

    private void townUnclaim(WorldCoord worldCoord) throws TownyException {
        if (worldCoord.isWilderness()) {
            throw new TownyException(Translatable.of("msg_not_claimed_1"));
        }
        if (!this.forced && this.town != null && !worldCoord.hasTown(this.town)) {
            throw new TownyException(Translatable.of("msg_area_not_own"));
        }
        this.unclaimTownBlock(worldCoord.getTownBlockOrNull());
        double unclaimRefund = TownySettings.getClaimRefundPrice();
        if (TownyEconomyHandler.isActive() && unclaimRefund != 0.0) {
            this.runningRefund += unclaimRefund;
            if (unclaimRefund < 0.0 && this.town != null && !this.town.getAccount().canPayFromHoldings(Math.abs(this.runningRefund))) {
                this.runningRefund -= unclaimRefund;
                this.insufficientFunds += Math.abs(unclaimRefund);
                throw new TownyException("");
            }
        }
    }

    private void townUnclaimAll(Town town) throws TownyException {
        for (TownBlock tb : new ArrayList<TownBlock>(town.getTownBlocks())) {
            if (town.hasHomeBlock() && tb.equals(town.getHomeBlockOrNull())) continue;
            try {
                this.townUnclaim(tb.getWorldCoord());
            }
            catch (TownyException e) {
                throw new TownyException(e.getMessage((CommandSender)this.player));
            }
        }
    }

    private void unclaimTownBlock(TownBlock townBlock) throws TownyException {
        TownPreUnclaimEvent.Cause cause = this.forced ? TownPreUnclaimEvent.Cause.ADMIN_COMMAND : TownPreUnclaimEvent.Cause.COMMAND;
        TownyUniverse.getInstance().getDataSource().removeTownBlock(townBlock, cause);
    }

    private void refundForUnclaim(double unclaimRefund, int numUnclaimed) {
        if (unclaimRefund > 0.0 && this.town.getAccount().deposit(unclaimRefund, "Town Unclaim Refund")) {
            TownyMessaging.sendMsg((CommandSender)this.player, Translatable.of("refund_message", TownyEconomyHandler.getFormattedBalance(unclaimRefund), numUnclaimed));
        }
        if (unclaimRefund < 0.0 && this.town.getAccount().withdraw(unclaimRefund, "Town Unclaim Cost")) {
            TownyMessaging.sendMsg((CommandSender)this.player, Translatable.of("msg_your_town_paid_x_to_unclaim", TownyEconomyHandler.getFormattedBalance(unclaimRefund)));
        }
    }
}

