/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.utils;

import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.PlotGroup;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockOwner;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.util.BiomeUtil;
import com.palmergames.util.MathUtil;
import com.palmergames.util.StringMgmt;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AreaSelectionUtil {
    private static final int MAX_RECT_RADIUS = 15;
    private static final int MAX_CIRC_RADIUS = 18;
    private static final int MAX_SIZE = 1009;

    public static List<WorldCoord> selectWorldCoordArea(TownBlockOwner owner, WorldCoord pos, String[] args) throws TownyException {
        return AreaSelectionUtil.selectWorldCoordArea(owner, pos, args, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<WorldCoord> selectWorldCoordArea(TownBlockOwner owner, WorldCoord pos, String[] args, boolean claim) throws TownyException {
        List<WorldCoord> out = new ArrayList<WorldCoord>();
        if (args.length == 0) {
            out.add(pos);
            return out;
        } else {
            int maxSelectionSize;
            int n = maxSelectionSize = claim ? AreaSelectionUtil.getSelectionSize(args, owner) : 1009;
            if (args.length > 1) {
                if (args[0].equalsIgnoreCase("rect")) {
                    return AreaSelectionUtil.selectWorldCoordAreaRect(maxSelectionSize, pos, StringMgmt.remFirstArg(args), claim);
                }
                if (args[0].equalsIgnoreCase("circle")) {
                    return AreaSelectionUtil.selectWorldCoordAreaCircle(maxSelectionSize, pos, StringMgmt.remFirstArg(args), claim);
                }
                if (args.length != 3 || !args[1].startsWith("x") || !args[2].startsWith("z")) throw new TownyException(Translatable.of("msg_err_invalid_property", StringMgmt.join(args, " ")));
                out.add(new WorldCoord(args[0], Integer.parseInt(args[1].replace("x", "")), Integer.parseInt(args[2].replace("z", ""))));
                return out;
            } else {
                if (args[0].equalsIgnoreCase("auto")) {
                    return AreaSelectionUtil.selectWorldCoordAreaRect(maxSelectionSize, pos, args, claim);
                }
                try {
                    Integer.parseInt(args[0]);
                    return AreaSelectionUtil.selectWorldCoordAreaRect(maxSelectionSize, pos, args, claim);
                }
                catch (NumberFormatException e) {
                    throw new TownyException(Translatable.of("msg_err_invalid_property", args[0]));
                }
            }
        }
    }

    private static int getSelectionSize(String[] args, TownBlockOwner owner) {
        if (args.length == 1 && args[0].equalsIgnoreCase("auto") || args.length == 2 && args[1].equalsIgnoreCase("auto")) {
            return AreaSelectionUtil.getAvailableClaimsFrom(owner);
        }
        return 1009;
    }

    private static int getAvailableClaimsFrom(TownBlockOwner owner) {
        if (owner instanceof Town) {
            Town town = (Town)owner;
            return town.hasUnlimitedClaims() ? 1009 : town.availableTownBlocks();
        }
        if (owner instanceof Resident) {
            Resident resident = (Resident)owner;
            return TownySettings.getMaxResidentPlots(resident) - resident.getTownBlocks().size();
        }
        return 0;
    }

    private static List<WorldCoord> selectWorldCoordAreaRect(int maxSelectionSize, WorldCoord pos, String[] args, boolean claim) throws TownyException {
        ArrayList<WorldCoord> out = new ArrayList<WorldCoord>();
        if (args.length > 0) {
            int r = 15;
            if (args[0].equalsIgnoreCase("auto")) {
                if (TownySettings.getMaxClaimRadiusValue() > 0) {
                    r = Math.min(r, TownySettings.getMaxClaimRadiusValue());
                }
            } else {
                int claimRadius;
                try {
                    r = Integer.parseInt(args[0]);
                }
                catch (NumberFormatException e) {
                    throw new TownyException(Translatable.of("msg_err_invalid_radius"));
                }
                if (TownySettings.getMaxClaimRadiusValue() > 0 && r > TownySettings.getMaxClaimRadiusValue()) {
                    throw new TownyException(Translatable.of("msg_err_invalid_radius_number", TownySettings.getMaxClaimRadiusValue()));
                }
                int needed = pos.isWilderness() ? 1 : 0;
                for (claimRadius = 1; claimRadius <= r && needed < maxSelectionSize; needed += claimRadius * 8, ++claimRadius) {
                }
                r = claimRadius - 1;
                maxSelectionSize = needed + 1;
            }
            int halfSideLength = (r * 2 + 1) / 2;
            int x = 0;
            int z = 0;
            int dx = 0;
            int dz = -1;
            for (int i = 0; i <= maxSelectionSize; ++i) {
                if (-halfSideLength <= x && x <= halfSideLength && -halfSideLength <= z && z <= halfSideLength) {
                    out.add(pos.add(x, z));
                }
                if (x == z || x < 0 && x == -z || x > 0 && x == 1 - z) {
                    int swap = dx;
                    dx = -dz;
                    dz = swap;
                }
                x += dx;
                z += dz;
            }
        } else {
            throw new TownyException(Translatable.of("msg_err_invalid_radius"));
        }
        if (claim && !pos.isWilderness()) {
            out.remove(0);
        }
        return out;
    }

    private static List<WorldCoord> selectWorldCoordAreaCircle(int maxSelectionSize, WorldCoord pos, String[] args, boolean claim) throws TownyException {
        ArrayList<WorldCoord> out = new ArrayList<WorldCoord>();
        if (args.length > 0) {
            int r = 18;
            if (args[0].equalsIgnoreCase("auto")) {
                if (maxSelectionSize > 0) {
                    while ((double)maxSelectionSize - Math.ceil(Math.PI * (double)r * (double)r) >= 0.0) {
                        ++r;
                    }
                }
                if (TownySettings.getMaxClaimRadiusValue() > 0) {
                    r = Math.min(r, TownySettings.getMaxClaimRadiusValue());
                }
            } else {
                try {
                    r = Integer.parseInt(args[0]);
                }
                catch (NumberFormatException e) {
                    throw new TownyException(Translatable.of("msg_err_invalid_radius"));
                }
                if (r < 0) {
                    throw new TownyException(Translatable.of("msg_err_invalid_radius"));
                }
                if (TownySettings.getMaxClaimRadiusValue() > 0 && r > TownySettings.getMaxClaimRadiusValue()) {
                    throw new TownyException(Translatable.of("msg_err_invalid_radius_number", TownySettings.getMaxClaimRadiusValue()));
                }
                int radius = 0;
                if (maxSelectionSize > 0) {
                    while ((double)maxSelectionSize - Math.ceil(Math.PI * (double)radius * (double)radius) >= 0.0) {
                        ++radius;
                    }
                }
                r = Math.min(r, --radius);
            }
            int halfSideLength = (r * 2 + 1) / 2;
            int x = 0;
            int z = 0;
            int dx = 0;
            int dz = -1;
            for (int i = 0; i <= maxSelectionSize; ++i) {
                if (-halfSideLength <= x && x <= halfSideLength && -halfSideLength <= z && z <= halfSideLength && MathUtil.distanceSquared(x, z) <= MathUtil.sqr(r) && out.size() <= maxSelectionSize) {
                    out.add(pos.add(x, z));
                }
                if (x == z || x < 0 && x == -z || x > 0 && x == 1 - z) {
                    int swap = dx;
                    dx = -dz;
                    dz = swap;
                }
                x += dx;
                z += dz;
            }
        } else {
            throw new TownyException(Translatable.of("msg_err_invalid_radius"));
        }
        if (claim && !pos.isWilderness()) {
            out.remove(0);
        }
        return out;
    }

    public static List<WorldCoord> filterInvalidProximityTownBlocks(List<WorldCoord> selection, Town town) {
        ArrayList<WorldCoord> out = new ArrayList<WorldCoord>();
        for (WorldCoord worldCoord : selection) {
            if (worldCoord.getTownyWorld().getMinDistanceFromOtherTownsPlots(worldCoord, town) >= TownySettings.getMinDistanceFromTownPlotblocks()) {
                out.add(worldCoord);
                continue;
            }
            TownyMessaging.sendDebugMsg("AreaSelectionUtil:filterInvalidProximity - Coord: " + String.valueOf(worldCoord) + " too close to another town.");
        }
        return out;
    }

    public static List<WorldCoord> filterInvalidProximityToHomeblock(List<WorldCoord> selection, Town town) {
        ArrayList<WorldCoord> out = new ArrayList<WorldCoord>();
        for (WorldCoord worldCoord : selection) {
            if (!AreaSelectionUtil.isTooCloseToHomeBlock(worldCoord, town)) {
                out.add(worldCoord);
                continue;
            }
            TownyMessaging.sendDebugMsg("AreaSelectionUtil:filterInvalidProximity - Coord: " + String.valueOf(worldCoord) + " too close to another town's homeblock.");
        }
        return out;
    }

    public static boolean isTooCloseToHomeBlock(WorldCoord wc, Town town) {
        return wc.getTownyWorld().getMinDistanceFromOtherTownsHomeBlocks(wc, town) < TownySettings.getMinDistanceFromTownHomeblocks();
    }

    public static List<WorldCoord> filterOutTownOwnedBlocks(List<WorldCoord> selection) {
        return selection.stream().filter(WorldCoord::isWilderness).collect(Collectors.toList());
    }

    public static List<WorldCoord> filterOutWildernessBlocks(List<WorldCoord> selection) {
        return selection.stream().filter(WorldCoord::hasTownBlock).collect(Collectors.toList());
    }

    public static List<WorldCoord> filterOwnedBlocks(TownBlockOwner owner, List<WorldCoord> selection) {
        return AreaSelectionUtil.filterOutWildernessBlocks(selection).stream().filter(wc -> wc.getTownBlockOrNull().isOwner(owner)).collect(Collectors.toList());
    }

    public static List<WorldCoord> filterUnownedBlocks(TownBlockOwner owner, List<WorldCoord> selection) {
        return AreaSelectionUtil.filterOutWildernessBlocks(selection).stream().filter(wc -> !wc.getTownBlockOrNull().isOwner(owner)).collect(Collectors.toList());
    }

    public static boolean filterHomeBlock(Town town, List<WorldCoord> selection) {
        if (!town.hasHomeBlock()) {
            return false;
        }
        WorldCoord homeCoord = town.getHomeBlockOrNull().getWorldCoord();
        return selection.removeIf(worldCoord -> worldCoord.equals(homeCoord));
    }

    public static List<WorldCoord> filterPlotsByGroup(PlotGroup group, List<WorldCoord> selection) {
        return AreaSelectionUtil.filterOutWildernessBlocks(selection).stream().map(WorldCoord::getTownBlockOrNull).filter(TownBlock::hasPlotObjectGroup).filter(tb -> group.hasTownBlock((TownBlock)tb)).map(TownBlock::getWorldCoord).collect(Collectors.toList());
    }

    public static HashSet<PlotGroup> getPlotGroupsFromSelection(List<WorldCoord> selection) {
        HashSet<PlotGroup> seenGroups = new HashSet<PlotGroup>();
        for (WorldCoord coord : selection) {
            if (!coord.hasTownBlock() || !coord.getTownBlockOrNull().hasPlotObjectGroup()) continue;
            seenGroups.add(coord.getTownBlockOrNull().getPlotObjectGroup());
        }
        return seenGroups;
    }

    public static List<WorldCoord> filterPlotsForSale(Resident resident, List<WorldCoord> selection) {
        ArrayList<WorldCoord> out = new ArrayList<WorldCoord>();
        for (WorldCoord worldCoord : selection) {
            TownBlock townBlock = worldCoord.getTownBlockOrNull();
            if (townBlock == null || !AreaSelectionUtil.residentCanBuyTownBlock(resident, townBlock)) continue;
            if (townBlock.hasPlotObjectGroup()) {
                out.clear();
                out.add(worldCoord);
                return out;
            }
            out.add(worldCoord);
        }
        return out;
    }

    public static List<WorldCoord> filterPlotsForSale(List<WorldCoord> selection) {
        ArrayList<WorldCoord> out = new ArrayList<WorldCoord>();
        for (WorldCoord worldCoord : selection) {
            TownBlock townBlock = worldCoord.getTownBlockOrNull();
            if (townBlock == null || !AreaSelectionUtil.townBlockIsForSale(townBlock)) continue;
            if (townBlock.hasPlotObjectGroup()) {
                out.clear();
                out.add(worldCoord);
                return out;
            }
            out.add(worldCoord);
        }
        return out;
    }

    private static boolean residentCanBuyTownBlock(Resident resident, TownBlock townBlock) {
        try {
            townBlock.testTownMembershipAgePreventsThisClaimOrThrow(resident);
        }
        catch (TownyException e) {
            if (resident.isOnline()) {
                TownyMessaging.sendErrorMsg(resident.getPlayer(), e.getMessage((CommandSender)resident.getPlayer()));
            }
            return false;
        }
        Town town = townBlock.getTownOrNull();
        return town != null && AreaSelectionUtil.townBlockIsForSale(townBlock) && (town.hasResident(resident) || townBlock.getType().equals(TownBlockType.EMBASSY));
    }

    private static boolean townBlockIsForSale(TownBlock townBlock) {
        return townBlock.isForSale() || townBlock.hasPlotObjectGroup() && townBlock.getPlotObjectGroup().getPrice() != -1.0;
    }

    public static List<WorldCoord> filterPlotsNotForSale(List<WorldCoord> selection) {
        return selection.stream().filter(wc -> wc.hasTownBlock() && wc.getTownBlockOrNull().isForSale()).collect(Collectors.toList());
    }

    public static List<WorldCoord> filterOutResidentBlocks(Resident resident, List<WorldCoord> selection) {
        return selection.stream().filter(wc -> wc.hasTownBlock() && !wc.getTownBlockOrNull().hasResident() || !wc.getTownBlockOrNull().hasResident(resident)).collect(Collectors.toList());
    }

    public static List<WorldCoord> filterOutUnwantedBiomeWorldCoords(Player player, List<WorldCoord> selection) {
        if (!TownySettings.isUnwantedBiomeClaimingEnabled()) {
            return selection;
        }
        Predicate<WorldCoord> biomeThresholdTest = wc -> BiomeUtil.getWorldCoordUnwantedBiomePercent(wc) < TownySettings.getUnwantedBiomeThreshold();
        return AreaSelectionUtil.filterOutByBiome(player, selection, biomeThresholdTest, "msg_err_cannot_claim_the_following_worldcoords_because_of_unwanted_biome");
    }

    public static List<WorldCoord> filterOutOceanBiomeWorldCoords(Player player, List<WorldCoord> selection) {
        if (!TownySettings.isOceanClaimingBlocked()) {
            return selection;
        }
        Predicate<WorldCoord> biomeThresholdTest = wc -> BiomeUtil.getWorldCoordOceanBiomePercent(wc) < TownySettings.getOceanBlockThreshold();
        return AreaSelectionUtil.filterOutByBiome(player, selection, biomeThresholdTest, "msg_err_cannot_claim_the_following_worldcoords_because_of_ocean_biome");
    }

    public static List<WorldCoord> filterOutByBiome(Player player, List<WorldCoord> selection, Predicate<WorldCoord> biomeThresholdTest, String errorMsg) {
        Map<Boolean, List<WorldCoord>> worldCoords = selection.stream().collect(Collectors.partitioningBy(biomeThresholdTest));
        if (!worldCoords.get(false).isEmpty()) {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of(errorMsg, AreaSelectionUtil.prettyWorldCoordList(worldCoords.get(false))));
        }
        return worldCoords.get(true);
    }

    private static String prettyWorldCoordList(List<WorldCoord> worldCoords) {
        return StringMgmt.join(worldCoords.stream().map(wc -> String.format("(%s)", wc.getCoord().toString())).collect(Collectors.toList()), ", ");
    }

    public static int getAreaSelectPivot(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equalsIgnoreCase("within")) continue;
            return i;
        }
        return -1;
    }

    public static boolean isOnEdgeOfOwnership(TownBlockOwner owner, WorldCoord worldCoord) {
        return worldCoord.getCardinallyAdjacentWorldCoords(false).stream().filter(wc -> !wc.hasTownBlock() || !wc.getTownBlockOrNull().isOwner(owner)).findAny().isPresent();
    }
}

