/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.utils;

import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.object.CellBorder;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.utils.PlayerCacheUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BorderUtil {
    private static final int[][] DIRECTIONS = new int[][]{{-1, 0}, {1, 0}, {0, -1}, {0, 1}};

    public static List<CellBorder> getOuterBorder(List<WorldCoord> worldCoords) {
        ArrayList<CellBorder> borderCoords = new ArrayList<CellBorder>();
        for (WorldCoord worldCoord : worldCoords) {
            boolean[] blArray = new boolean[8];
            blArray[0] = !worldCoords.contains(worldCoord.add(-1, 0));
            blArray[1] = !worldCoords.contains(worldCoord.add(-1, -1));
            blArray[2] = !worldCoords.contains(worldCoord.add(0, -1));
            blArray[3] = !worldCoords.contains(worldCoord.add(1, -1));
            blArray[4] = !worldCoords.contains(worldCoord.add(1, 0));
            blArray[5] = !worldCoords.contains(worldCoord.add(1, 1));
            blArray[6] = !worldCoords.contains(worldCoord.add(0, 1));
            boolean bl = blArray[7] = !worldCoords.contains(worldCoord.add(-1, 1));
            CellBorder border = new CellBorder(worldCoord, blArray);
            if (!border.hasAnyBorder()) continue;
            borderCoords.add(border);
        }
        return borderCoords;
    }

    public static List<CellBorder> getPlotBorder(List<WorldCoord> worldCoords) {
        ArrayList<CellBorder> borderCoords = new ArrayList<CellBorder>();
        for (WorldCoord worldCoord : worldCoords) {
            CellBorder border = BorderUtil.getPlotBorder(worldCoord);
            borderCoords.add(border);
        }
        return borderCoords;
    }

    public static CellBorder getPlotBorder(WorldCoord worldCoord) {
        return new CellBorder(worldCoord, new boolean[]{true, true, true, true, true, true, true, true});
    }

    public static List<BlockState> allowedBlocks(List<BlockState> blocks, Block originBlock) {
        return BorderUtil.allowedBlocks(blocks, originBlock, null);
    }

    public static List<BlockState> allowedBlocks(List<BlockState> blocks, Block originBlock, Player player) {
        return blocks.stream().filter(blockState -> BorderUtil.allowedMove(originBlock, blockState.getBlock(), player)).collect(Collectors.toList());
    }

    public static List<BlockState> disallowedBlocks(List<BlockState> blocks, Block originBlock) {
        return BorderUtil.disallowedBlocks(blocks, originBlock, null);
    }

    public static List<BlockState> disallowedBlocks(List<BlockState> blocks, Block originBlock, Player player) {
        return blocks.stream().filter(blockState -> !BorderUtil.allowedMove(originBlock, blockState.getBlock(), player)).collect(Collectors.toList());
    }

    public static boolean allowedMove(Block block, Block blockTo) {
        return BorderUtil.allowedMove(block, blockTo, null);
    }

    public static boolean allowedMove(Block block, Block blockTo, @Nullable Player player) {
        Resident resident;
        WorldCoord to;
        if (player != null && PlayerCacheUtil.getCachePermission(player, blockTo.getLocation(), block.getType(), TownyPermission.ActionType.BUILD) && PlayerCacheUtil.getCachePermission(player, block.getLocation(), block.getType(), TownyPermission.ActionType.BUILD)) {
            return true;
        }
        WorldCoord from = WorldCoord.parseWorldCoord(block);
        if (from.equals(to = WorldCoord.parseWorldCoord(blockTo)) || TownyAPI.getInstance().isWilderness(to)) {
            return true;
        }
        if (!from.hasTownBlock()) {
            return false;
        }
        TownBlock currentTownBlock = from.getTownBlockOrNull();
        TownBlock destinationTownBlock = to.getTownBlockOrNull();
        if (currentTownBlock.hasResident() != destinationTownBlock.hasResident()) {
            return false;
        }
        Resident resident2 = resident = player != null ? TownyAPI.getInstance().getResident(player) : null;
        if (resident != null && currentTownBlock.hasTrustedResident(resident) && !destinationTownBlock.hasTrustedResident(resident) && destinationTownBlock.getResidentOrNull() != resident) {
            return false;
        }
        if (currentTownBlock.hasResident() && destinationTownBlock.hasResident() && currentTownBlock.getResidentOrNull() == destinationTownBlock.getResidentOrNull()) {
            return true;
        }
        return currentTownBlock.getTownOrNull() == destinationTownBlock.getTownOrNull() && !currentTownBlock.hasResident() && !destinationTownBlock.hasResident();
    }

    @ApiStatus.Internal
    @NotNull
    public static FloodfillResult getFloodFillableCoords(@NotNull Town town, @NotNull WorldCoord origin) {
        TownyWorld originWorld = origin.getTownyWorld();
        if (originWorld == null) {
            return FloodfillResult.fail(null);
        }
        if (origin.hasTownBlock()) {
            return FloodfillResult.fail(Translatable.of("msg_err_floodfill_not_in_wild"));
        }
        HashSet coords = new HashSet(town.getTownBlockMap().keySet());
        coords.removeIf(coord -> !originWorld.equals(coord.getTownyWorld()));
        if (coords.isEmpty()) {
            return FloodfillResult.fail(null);
        }
        int minX = origin.getX();
        int maxX = origin.getX();
        int minZ = origin.getZ();
        int maxZ = origin.getZ();
        for (WorldCoord coord2 : coords) {
            minX = Math.min(minX, coord2.getX());
            maxX = Math.max(maxX, coord2.getX());
            minZ = Math.min(minZ, coord2.getZ());
            maxZ = Math.max(maxZ, coord2.getZ());
        }
        HashSet<WorldCoord> valid = new HashSet<WorldCoord>();
        HashSet<WorldCoord> visited = new HashSet<WorldCoord>();
        LinkedList<WorldCoord> queue = new LinkedList<WorldCoord>();
        queue.offer(origin);
        visited.add(origin);
        while (!queue.isEmpty()) {
            WorldCoord current = (WorldCoord)queue.poll();
            valid.add(current);
            for (int[] direction : DIRECTIONS) {
                int xOffset = direction[0];
                int zOffset = direction[1];
                WorldCoord candidate = current.add(xOffset, zOffset);
                if (!(coords.contains(candidate) || candidate.getX() < maxX && candidate.getX() > minX && candidate.getZ() < maxZ && candidate.getZ() > minZ)) {
                    return FloodfillResult.oob();
                }
                TownBlock townBlock = candidate.getTownBlockOrNull();
                if (townBlock != null && townBlock.hasTown() && !town.equals(townBlock.getTownOrNull())) {
                    return FloodfillResult.fail(Translatable.of("msg_err_floodfill_cannot_contain_towns"));
                }
                if (townBlock != null || visited.contains(candidate) || coords.contains(candidate)) continue;
                queue.offer(candidate);
                visited.add(candidate);
            }
        }
        return FloodfillResult.success(valid);
    }

    public record FloodfillResult(@NotNull Type type, @Nullable Translatable feedback, @NotNull Collection<WorldCoord> coords) {
        static FloodfillResult fail(@Nullable Translatable feedback) {
            return new FloodfillResult(Type.FAIL, feedback, Collections.emptySet());
        }

        static FloodfillResult oob() {
            return new FloodfillResult(Type.OUT_OF_BOUNDS, Translatable.of("msg_err_floodfill_out_of_bounds"), Collections.emptySet());
        }

        static FloodfillResult success(Collection<WorldCoord> coords) {
            return new FloodfillResult(Type.SUCCESS, null, coords);
        }

        public static enum Type {
            SUCCESS,
            FAIL,
            OUT_OF_BOUNDS;

        }
    }
}

