/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.utils;

import com.palmergames.bukkit.towny.object.ChangelogResult;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class ChangelogReader {
    private final String lastVersion;
    private final InputStream changelogStream;
    private final int limit;

    private ChangelogReader(String lastVersion, InputStream inputStream, int limit) {
        this.lastVersion = lastVersion;
        this.changelogStream = inputStream;
        this.limit = limit;
    }

    @NotNull
    public ChangelogResult read() throws IOException {
        ArrayList<String> out = new ArrayList<String>();
        int linesRead = 0;
        boolean limitReached = false;
        int nextVersionIndex = 0;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.changelogStream, StandardCharsets.UTF_8));){
            String line;
            boolean lastVersionFound = false;
            boolean nextVersionFound = false;
            while ((line = reader.readLine()) != null) {
                ++linesRead;
                if (!lastVersionFound && line.startsWith(this.lastVersion)) {
                    lastVersionFound = true;
                    continue;
                }
                if (lastVersionFound && !nextVersionFound && !line.trim().startsWith("-")) {
                    nextVersionFound = true;
                    nextVersionIndex = linesRead;
                }
                if (!nextVersionFound) continue;
                if (this.limit < 0 || out.size() < this.limit) {
                    out.add(line);
                    continue;
                }
                limitReached = true;
            }
            if (!lastVersionFound) {
                ChangelogResult changelogResult = new ChangelogResult(Collections.emptyList(), false, false, -1, linesRead);
                return changelogResult;
            }
        }
        return new ChangelogResult(out, true, limitReached, nextVersionIndex, linesRead);
    }

    public static ChangelogReader reader(@NotNull String lastVersion, @NotNull InputStream changelogStream) {
        return ChangelogReader.reader(lastVersion, changelogStream, -1);
    }

    public static ChangelogReader reader(@NotNull String lastVersion, @NotNull InputStream changelogStream, int limit) {
        return new ChangelogReader(lastVersion, changelogStream, limit);
    }
}

