/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.utils;

import com.palmergames.bukkit.config.ConfigNodes;
import com.palmergames.bukkit.towny.ChunkNotification;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.event.ChunkNotificationEvent;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.scheduling.ScheduledTask;
import com.palmergames.bukkit.towny.utils.TownyComponents;
import com.palmergames.bukkit.util.BukkitTools;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class ChunkNotificationUtil {
    private static final Map<UUID, ScheduledTask> playerActionTasks = new HashMap<UUID, ScheduledTask>();
    private static final Map<UUID, BossBar> playerBossBarMap = new HashMap<UUID, BossBar>();

    public static void showChunkNotification(Player player, Resident resident, WorldCoord to, WorldCoord from) {
        String msg = null;
        try {
            ChunkNotification chunkNotifier = new ChunkNotification(from, to);
            msg = chunkNotifier.getNotificationString(resident);
        }
        catch (NullPointerException e) {
            Towny.getPlugin().getLogger().log(Level.WARNING, "ChunkNotifier generated an NPE, this is harmless but if you'd like to report it the following information will be useful: " + System.lineSeparator() + "  Player: " + player.getName() + "  To: " + to.getWorldName() + "," + to.getX() + "," + to.getZ() + "  From: " + from.getWorldName() + "," + from.getX() + "," + from.getZ(), e);
        }
        if (msg == null) {
            return;
        }
        ChunkNotificationEvent cne = new ChunkNotificationEvent(player, msg, to, from);
        BukkitTools.fireEvent(cne);
        msg = cne.getMessage();
        if (cne.isCancelled() || msg == null || msg.isEmpty()) {
            return;
        }
        ChunkNotificationUtil.sendChunkNoticiation(player, msg);
    }

    public static void cancelChunkNotificationTasks() {
        playerActionTasks.values().forEach(ScheduledTask::cancel);
    }

    private static void sendChunkNoticiation(Player player, String msg) {
        switch (TownySettings.getNotificationsAppearAs().toLowerCase(Locale.ROOT)) {
            case "bossbar": {
                ChunkNotificationUtil.sendBossBarChunkNotification(player, TownyComponents.miniMessage(msg));
                break;
            }
            case "chat": {
                TownyMessaging.sendMessage((Object)player, msg);
                break;
            }
            case "none": {
                break;
            }
            default: {
                ChunkNotificationUtil.sendActionBarChunkNotification(player, TownyComponents.miniMessage(msg));
            }
        }
    }

    private static void sendActionBarChunkNotification(Player player, Component msgComponent) {
        int seconds = TownySettings.getInt(ConfigNodes.NOTIFICATION_DURATION);
        if (seconds > 3) {
            if (playerActionTasks.get(player.getUniqueId()) != null) {
                ChunkNotificationUtil.removePlayerActionTasks(player);
            }
            AtomicInteger remainingSeconds = new AtomicInteger(seconds);
            ScheduledTask task = Towny.getPlugin().getScheduler().runAsyncRepeating(() -> {
                TownyMessaging.sendActionBarMessageToPlayer(player, msgComponent);
                remainingSeconds.getAndDecrement();
                if (remainingSeconds.get() == 0 && playerActionTasks.containsKey(player.getUniqueId())) {
                    ChunkNotificationUtil.removePlayerActionTasks(player);
                }
            }, 0L, 20L);
            playerActionTasks.put(player.getUniqueId(), task);
        } else {
            TownyMessaging.sendActionBarMessageToPlayer(player, msgComponent);
        }
    }

    private static void sendBossBarChunkNotification(Player player, Component message) {
        int ticks = TownySettings.getInt(ConfigNodes.NOTIFICATION_DURATION) * 20;
        if (playerBossBarMap.containsKey(player.getUniqueId())) {
            ChunkNotificationUtil.removePlayerActionTasks(player);
            ChunkNotificationUtil.removePlayerBossBar(player);
        }
        BossBar.Color color = (BossBar.Color)BossBar.Color.NAMES.valueOr((Object)TownySettings.getBossBarNotificationColor().toLowerCase(Locale.ROOT), (Object)BossBar.Color.WHITE);
        BossBar.Overlay overlay = (BossBar.Overlay)BossBar.Overlay.NAMES.valueOr((Object)TownySettings.getBossBarNotificationOverlay().toLowerCase(Locale.ROOT), (Object)BossBar.Overlay.PROGRESS);
        BossBar bossBar = BossBar.bossBar((Component)message, (float)TownySettings.getBossBarNotificationProgress(), (BossBar.Color)color, (BossBar.Overlay)overlay);
        TownyMessaging.sendBossBarMessageToPlayer(player, bossBar);
        ScheduledTask task = Towny.getPlugin().getScheduler().runAsyncLater(() -> {
            playerActionTasks.remove(player.getUniqueId());
            ChunkNotificationUtil.removePlayerBossBar(player);
        }, ticks);
        playerBossBarMap.put(player.getUniqueId(), bossBar);
        playerActionTasks.put(player.getUniqueId(), task);
    }

    private static void removePlayerActionTasks(Player player) {
        ScheduledTask task = playerActionTasks.remove(player.getUniqueId());
        if (task != null) {
            task.cancel();
        }
    }

    private static void removePlayerBossBar(Player player) {
        BossBar bar = playerBossBarMap.remove(player.getUniqueId());
        if (bar != null) {
            player.hideBossBar(bar);
        }
    }

    public static void cancelPlayerTasks(@NotNull Player player) {
        ChunkNotificationUtil.removePlayerActionTasks(player);
        ChunkNotificationUtil.removePlayerBossBar(player);
    }
}

