/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.utils;

import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyFormatter;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.event.economy.NationPreTransactionEvent;
import com.palmergames.bukkit.towny.event.economy.NationTransactionEvent;
import com.palmergames.bukkit.towny.event.economy.TownPreTransactionEvent;
import com.palmergames.bukkit.towny.event.economy.TownTransactionEvent;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownBlockTypeCache;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.Translator;
import com.palmergames.bukkit.towny.object.economy.transaction.Transaction;
import com.palmergames.bukkit.towny.object.statusscreens.StatusScreen;
import com.palmergames.bukkit.util.BukkitTools;
import java.math.BigDecimal;
import java.math.RoundingMode;
import net.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class MoneyUtil {
    public static double getTownDebtCap(Town town, double upkeep) {
        return TownySettings.isDebtCapAFixedNumberOfDays() ? upkeep * (double)TownySettings.getDebtCapFixedDays() : MoneyUtil.getEstimatedValueOfTown(town);
    }

    public static double getEstimatedValueOfTown(Town town) {
        return TownySettings.getNewTownPrice() + (double)(town.getTownBlocks().size() - 1) * TownySettings.getClaimPrice() + (double)town.getAllOutpostSpawns().size() * (TownySettings.getOutpostCost() - TownySettings.getClaimPrice());
    }

    public static void townWithdraw(Player player, Resident resident, Town town, int amount) {
        try {
            MoneyUtil.commonTests(amount, resident, town, player.getLocation(), false, true);
            Transaction transaction = Transaction.withdraw(amount).paidBy(town).paidTo(resident).build();
            BukkitTools.ifCancelledThenThrow(new TownPreTransactionEvent(town, transaction));
            town.withdrawFromBank(resident, amount);
            TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_xx_withdrew_xx", resident.getName(), amount, Translatable.of("town_sing")));
            BukkitTools.fireEvent(new TownTransactionEvent(town, transaction));
        }
        catch (TownyException e) {
            TownyMessaging.sendErrorMsg(player, e.getMessage((CommandSender)player));
        }
    }

    public static void townDeposit(Player player, Resident resident, Town town, Nation nation, int amount) {
        try {
            MoneyUtil.commonTests(amount, resident, town, player.getLocation(), false, false);
            Transaction transaction = Transaction.deposit(amount).paidBy(resident).paidTo(town).build();
            BukkitTools.ifCancelledThenThrow(new TownPreTransactionEvent(town, transaction));
            if (nation == null) {
                town.depositToBank(resident, amount);
                TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_xx_deposited_xx", resident.getName(), amount, Translatable.of("town_sing")));
            } else {
                resident.getAccount().payTo((double)amount, town, "Town Deposit from Nation member");
                TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_xx_deposited_xx", resident.getName(), amount, Translatable.literal(town.getName() + " ").append(Translatable.of("town_sing"))));
            }
            BukkitTools.fireEvent(new TownTransactionEvent(town, transaction));
        }
        catch (TownyException e) {
            TownyMessaging.sendErrorMsg(player, e.getMessage((CommandSender)player));
        }
    }

    public static void nationWithdraw(Player player, Resident resident, Nation nation, int amount) {
        try {
            MoneyUtil.commonTests(amount, resident, nation.getCapital(), player.getLocation(), true, true);
            Transaction transaction = Transaction.withdraw(amount).paidBy(nation).paidTo(resident).build();
            BukkitTools.ifCancelledThenThrow(new NationPreTransactionEvent(nation, transaction));
            nation.withdrawFromBank(resident, amount);
            TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_xx_withdrew_xx", resident.getName(), amount, Translatable.of("nation_sing")));
            BukkitTools.fireEvent(new NationTransactionEvent(nation, transaction));
        }
        catch (TownyException e) {
            TownyMessaging.sendErrorMsg(player, e.getMessage((CommandSender)player));
        }
    }

    public static void nationDeposit(Player player, Resident resident, Nation nation, int amount) {
        try {
            MoneyUtil.commonTests(amount, resident, nation.getCapital(), player.getLocation(), true, false);
            Transaction transaction = Transaction.deposit(amount).paidBy(resident).paidTo(nation).build();
            BukkitTools.ifCancelledThenThrow(new NationPreTransactionEvent(nation, transaction));
            nation.depositToBank(resident, amount);
            TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_xx_deposited_xx", resident.getName(), amount, Translatable.of("nation_sing")));
            BukkitTools.fireEvent(new NationTransactionEvent(nation, transaction));
        }
        catch (TownyException e) {
            TownyMessaging.sendErrorMsg(player, e.getMessage((CommandSender)player));
        }
    }

    private static void commonTests(int amount, Resident resident, Town town, Location loc, boolean nation, boolean withdraw) throws TownyException {
        Nation townNation;
        Nation nation2 = townNation = nation ? town.getNationOrNull() : null;
        if (!TownyEconomyHandler.isActive()) {
            throw new TownyException(Translatable.of("msg_err_no_economy"));
        }
        if (amount < 0) {
            throw new TownyException(Translatable.of("msg_err_negative_money"));
        }
        if (!withdraw && !resident.getAccount().canPayFromHoldings(amount)) {
            throw new TownyException(Translatable.of("msg_insuf_funds"));
        }
        if (!nation && town.isRuined()) {
            throw new TownyException(Translatable.of("msg_err_cannot_use_command_because_town_ruined"));
        }
        if (withdraw && (nation && !TownySettings.getNationBankAllowWithdrawls() || !nation && !TownySettings.getTownBankAllowWithdrawls())) {
            throw new TownyException(Translatable.of("msg_err_withdraw_disabled"));
        }
        if (!withdraw && (!nation && TownySettings.getTownBankCap(town) > 0.0 || nation && TownySettings.getNationBankCap(townNation) > 0.0)) {
            double bankcap = 0.0;
            double balance = 0.0;
            if (!nation && town.getBankCap() > 0.0) {
                bankcap = town.getBankCap();
                balance = town.getAccount().getHoldingBalance();
            } else if (nation && townNation.getBankCap() > 0.0) {
                bankcap = townNation.getBankCap();
                balance = townNation.getAccount().getHoldingBalance();
            }
            if (bankcap > 0.0 && (double)amount + balance > bankcap) {
                throw new TownyException(Translatable.of("msg_err_deposit_capped", bankcap));
            }
        }
        if (TownySettings.isBankActionLimitedToBankPlots()) {
            MoneyUtil.testBankPlotRules(town, loc);
        }
        if (TownySettings.isBankActionDisallowedOutsideTown() && MoneyUtil.isNotInOwnTown(town, loc)) {
            if (nation) {
                throw new TownyException(Translatable.of("msg_err_unable_to_use_bank_outside_nation_capital"));
            }
            throw new TownyException(Translatable.of("msg_err_unable_to_use_bank_outside_your_town"));
        }
        int minAmount = 0;
        if (withdraw) {
            minAmount = nation ? TownySettings.getNationMinWithdraw() : TownySettings.getTownMinWithdraw();
        } else {
            int n = minAmount = nation ? TownySettings.getNationMinDeposit() : TownySettings.getTownMinDeposit();
        }
        if (amount < minAmount) {
            throw new TownyException(Translatable.of("msg_err_must_be_greater_than_or_equal_to", MoneyUtil.formatMoney(minAmount)));
        }
    }

    private static void testBankPlotRules(Town town, Location loc) throws TownyException {
        if (MoneyUtil.isNotInOwnTown(town, loc)) {
            throw new TownyException(Translatable.of("msg_err_unable_to_command_outside_of_town"));
        }
        TownBlock tb = TownyAPI.getInstance().getTownBlock(loc);
        if (tb.getType().equals(TownBlockType.BANK)) {
            return;
        }
        if (TownySettings.doHomeblocksNoLongerWorkWhenATownHasBankPlots() && town.getTownBlockTypeCache().getNumTownBlocks(TownBlockType.BANK, TownBlockTypeCache.CacheType.ALL) > 0) {
            throw new TownyException(Translatable.of("msg_err_unable_to_use_bank_outside_bank_plot_no_homeblock"));
        }
        if (!tb.isHomeBlock()) {
            throw new TownyException(Translatable.of("msg_err_unable_to_use_bank_outside_bank_plot"));
        }
    }

    private static boolean isNotInOwnTown(Town town, Location loc) {
        return TownyAPI.getInstance().isWilderness(loc) || !town.equals(TownyAPI.getInstance().getTown(loc));
    }

    public static double getMoneyAboveZeroOrThrow(String input) throws TownyException {
        double amount;
        try {
            amount = Double.parseDouble(input);
        }
        catch (NumberFormatException e) {
            throw new TownyException(Translatable.of("msg_error_must_be_num"));
        }
        if (amount < 0.0) {
            throw new TownyException(Translatable.of("msg_err_negative_money"));
        }
        return amount;
    }

    public static double returnPurchasedBlocksCost(int alreadyPurchased, int toPurchase, Town town) {
        boolean hasMaxPrice;
        int n = alreadyPurchased + toPurchase > TownySettings.getMaxPurchasedBlocks(town) ? TownySettings.getMaxPurchasedBlocks(town) - alreadyPurchased : toPurchase;
        if (n == 0) {
            return n;
        }
        double increaseValue = TownySettings.getPurchasedBonusBlocksIncreaseValue();
        double baseCost = TownySettings.getPurchasedBonusBlocksCost();
        double maxPrice = TownySettings.getPurchasedBonusBlocksMaxPrice();
        boolean bl = hasMaxPrice = maxPrice >= 0.0;
        if (increaseValue == 1.0) {
            double perBlockCost = hasMaxPrice ? Math.min(baseCost, maxPrice) : baseCost;
            return Math.round(perBlockCost * (double)n);
        }
        double blockCost = baseCost * Math.pow(increaseValue, alreadyPurchased);
        if (hasMaxPrice) {
            if (blockCost >= maxPrice) {
                return Math.round(maxPrice * (double)n);
            }
            int increases = (int)Math.ceil((Math.log(maxPrice) - Math.log(blockCost)) / Math.log(increaseValue));
            if (increases < n) {
                double cost = blockCost * (1.0 - Math.pow(increaseValue, increases)) / (1.0 - increaseValue) + (double)(n - increases) * maxPrice;
                return Math.round(cost);
            }
        }
        double cost = blockCost * (1.0 - Math.pow(increaseValue, n)) / (1.0 - increaseValue);
        return Math.round(cost);
    }

    public static void addTownMoneyComponents(Town town, Translator translator, StatusScreen screen) {
        double neutralCost;
        screen.addComponentOf("moneynewline", (Component)Component.newline());
        screen.addComponentOf("bankString", TownyFormatter.colourKeyValue(translator.of("status_bank"), town.getAccount().getHoldingFormattedBalance()));
        if (town.isBankrupt()) {
            if (town.getAccount().getDebtCap() == 0.0) {
                town.getAccount().setDebtCap(MoneyUtil.getTownDebtCap(town, TownySettings.getTownUpkeepCost(town)));
            }
            screen.addComponentOf("bankrupt", translator.of("status_bank_bankrupt") + " " + TownyFormatter.colourKeyValue(translator.of("status_debtcap"), "-" + MoneyUtil.formatMoney(town.getAccount().getDebtCap())));
        }
        if (!TownySettings.isTaxingDaily()) {
            return;
        }
        if (town.hasUpkeep()) {
            screen.addComponentOf("upkeep", translator.of("status_splitter") + TownyFormatter.colourKey(translator.of("status_bank_town2")) + " " + TownyFormatter.colourKeyImportant(MoneyUtil.formatMoney(BigDecimal.valueOf(TownySettings.getTownUpkeepCost(town)).setScale(2, RoundingMode.HALF_UP).doubleValue())));
        }
        if (TownySettings.getUpkeepPenalty() > 0.0 && town.isOverClaimed()) {
            screen.addComponentOf("upkeepPenalty", translator.of("status_splitter") + TownyFormatter.colourKey(translator.of("status_bank_town_penalty_upkeep")) + " " + TownyFormatter.colourKeyImportant(MoneyUtil.formatMoney(TownySettings.getTownPenaltyUpkeepCost(town))));
        }
        if (town.isNeutral() && (neutralCost = TownySettings.getTownNeutralityCost(town)) > 0.0) {
            screen.addComponentOf("neutralityCost", translator.of("status_splitter") + TownyFormatter.colourKey(translator.of("status_neutrality_cost") + " " + TownyFormatter.colourKeyImportant(MoneyUtil.formatMoney(neutralCost))));
        }
        screen.addComponentOf("towntax", translator.of("status_splitter") + TownyFormatter.colourKey(translator.of("status_bank_town3")) + " " + TownyFormatter.colourKeyImportant((String)(town.isTaxPercentage() ? town.getTaxes() + "%" : MoneyUtil.formatMoney(town.getTaxes()))));
    }

    public static void addNationMoneyComponentsToScreen(Nation nation, Translator translator, StatusScreen screen) {
        double neutralCost;
        screen.addComponentOf("moneynewline", (Component)Component.newline());
        screen.addComponentOf("bankString", TownyFormatter.colourKeyValue(translator.of("status_bank"), nation.getAccount().getHoldingFormattedBalance()));
        if (!TownySettings.isTaxingDaily()) {
            return;
        }
        if (TownySettings.getNationUpkeepCost(nation) > 0.0) {
            screen.addComponentOf("nationupkeep", translator.of("status_splitter") + TownyFormatter.colourKey(translator.of("status_bank_town2") + " " + TownyFormatter.colourKeyImportant(MoneyUtil.formatMoney(TownySettings.getNationUpkeepCost(nation)))));
        }
        if (nation.isNeutral() && (neutralCost = TownySettings.getNationNeutralityCost(nation)) > 0.0) {
            screen.addComponentOf("neutralityCost", translator.of("status_splitter") + TownyFormatter.colourKey(translator.of("status_neutrality_cost") + " " + TownyFormatter.colourKeyImportant(MoneyUtil.formatMoney(neutralCost))));
        }
        screen.addComponentOf("nationtax", translator.of("status_splitter") + TownyFormatter.colourKey(translator.of("status_nation_tax")) + " " + TownyFormatter.colourKeyImportant((String)(nation.isTaxPercentage() ? nation.getTaxes() + "%" : MoneyUtil.formatMoney(nation.getTaxes()))));
        screen.addComponentOf("nationConqueredTax", translator.of("status_splitter") + TownyFormatter.colourKey(translator.of("status_nation_conquered_tax")) + " " + TownyFormatter.colourKeyImportant(MoneyUtil.formatMoney(nation.getConqueredTax())));
    }

    private static String formatMoney(double money) {
        return TownyEconomyHandler.getFormattedBalance(money);
    }
}

