/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.utils;

import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.object.Nameable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

public class NameUtil {
    public static <T extends Nameable> List<String> getNames(Collection<T> objs) {
        ArrayList<String> names = new ArrayList<String>();
        for (Nameable obj : objs) {
            if (obj.getName() == null) continue;
            names.add(obj.getName());
        }
        return names;
    }

    public static List<String> filterByStart(List<String> list, String startingWith) {
        if (list == null || startingWith == null) {
            return Collections.emptyList();
        }
        return list.stream().filter(name -> name.toLowerCase(Locale.ROOT).startsWith(startingWith.toLowerCase(Locale.ROOT))).collect(Collectors.toList());
    }

    public static String getTagFromName(String name) {
        return name.substring(0, Math.min(name.length(), TownySettings.getMaxTagLength())).replace("_", "").replace("-", "");
    }
}

