/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.utils;

import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyFormatter;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.conversation.ResidentConversation;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.PermissionData;
import com.palmergames.bukkit.towny.object.PlotGroup;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.object.gui.EditGUI;
import com.palmergames.bukkit.towny.object.gui.PermissionGUI;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.utils.ResidentUtil;
import com.palmergames.bukkit.util.Colors;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.permissions.Permissible;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

public class PermissionGUIUtil {
    @NotNull
    public static final NamespacedKey EDIT_GUI_SAVE_KEY = Objects.requireNonNull(NamespacedKey.fromString((String)"towny:permission_edit_gui_save"));
    @NotNull
    public static final NamespacedKey EDIT_GUI_BACK_KEY = Objects.requireNonNull(NamespacedKey.fromString((String)"towny:permission_edit_gui_back"));
    @NotNull
    public static final NamespacedKey EDIT_GUI_DELETE_KEY = Objects.requireNonNull(NamespacedKey.fromString((String)"towny:permission_edit_gui_delete"));
    @NotNull
    public static final NamespacedKey GUI_ADD_KEY = Objects.requireNonNull(NamespacedKey.fromString((String)"towny:permission_gui_add"));
    @NotNull
    private static final NamespacedKey GUI_PLAYER_UUID_KEY = Objects.requireNonNull(NamespacedKey.fromString((String)"towny:permission_gui_player_uuid"));
    private static final SetPermissionType[] defaultTypes = new SetPermissionType[]{SetPermissionType.UNSET, SetPermissionType.UNSET, SetPermissionType.UNSET, SetPermissionType.UNSET};
    private static final int[] woolSlots = new int[]{21, 23, 30, 32};

    public static void openPermissionGUI(@NotNull Resident resident, @NotNull TownBlock townBlock) {
        Player player = resident.getPlayer();
        if (player == null) {
            return;
        }
        boolean canEdit = true;
        try {
            TownyAPI.getInstance().testPlotOwnerOrThrow(resident, townBlock);
        }
        catch (TownyException e) {
            canEdit = false;
        }
        Inventory page = ResidentUtil.getBlankPage(Translatable.of("permission_gui_header").forLocale(resident));
        ArrayList<Inventory> pages = new ArrayList<Inventory>();
        for (Map.Entry<Resident, PermissionData> entry : townBlock.getPermissionOverrides().entrySet()) {
            ItemStack skull = new ItemStack(Material.PLAYER_HEAD);
            SkullMeta meta2 = (SkullMeta)skull.getItemMeta();
            meta2.setOwningPlayer(Bukkit.getOfflinePlayer((UUID)entry.getKey().getUUID()));
            meta2.getPersistentDataContainer().set(GUI_PLAYER_UUID_KEY, PersistentDataType.STRING, (Object)entry.getKey().getUUID().toString());
            meta2.displayName(Component.text((String)entry.getKey().getName(), (TextColor)NamedTextColor.GOLD).decoration(TextDecoration.ITALIC, false));
            ArrayList<Component> lore = new ArrayList<Component>();
            ArrayList<Component> actionTypeComponents = new ArrayList<Component>();
            for (TownyPermission.ActionType actionType : TownyPermission.ActionType.values()) {
                actionTypeComponents.add(Component.text((String)actionType.getCommonName(), (TextColor)entry.getValue().getPermissionTypes()[actionType.getIndex()].color()).decoration(TextDecoration.ITALIC, false));
            }
            TextComponent splitter = Component.text((String)" | ", (TextColor)NamedTextColor.DARK_GRAY);
            lore.add(((Component)actionTypeComponents.get(0)).append((Component)splitter).append((Component)actionTypeComponents.get(1)));
            lore.add(((Component)actionTypeComponents.get(2)).append((Component)splitter).append((Component)actionTypeComponents.get(3)));
            if (canEdit) {
                if (entry.getValue().getLastChangedAt() > 0L && !entry.getValue().getLastChangedBy().isEmpty()) {
                    lore.add(Translatable.of("msg_last_edited", TownyFormatter.lastOnlineFormat.format(entry.getValue().getLastChangedAt()), entry.getValue().getLastChangedBy()).component(player.locale()));
                }
                lore.add(Translatable.of("msg_click_to_edit").component(player.locale()));
            }
            meta2.lore(lore);
            skull.setItemMeta((ItemMeta)meta2);
            if (page.firstEmpty() == 46) {
                pages.add(page);
                page = ResidentUtil.getBlankPage(Translatable.of("permission_gui_header").forLocale(resident));
            }
            page.addItem(new ItemStack[]{skull});
        }
        if (canEdit) {
            ItemStack addButton = new ItemStack(Material.NAME_TAG);
            addButton.editMeta(meta -> {
                meta.displayName(Component.text((String)"Add Player", (TextColor)NamedTextColor.GOLD).decoration(TextDecoration.ITALIC, false));
                meta.getPersistentDataContainer().set(GUI_ADD_KEY, PersistentDataType.BOOLEAN, (Object)true);
            });
            page.setItem(46, addButton);
        }
        page.setItem(52, PermissionGUIUtil.createTutorialBook());
        pages.add(page);
        resident.setGUIPages(pages);
        resident.setGUIPageNum(0);
        new PermissionGUI(resident, pages.get(0), Translatable.of("permission_gui_header").component(player.locale()), townBlock, canEdit);
    }

    public static void openPermissionEditorGUI(@NotNull Resident resident, @NotNull TownBlock townBlock, @NotNull ItemStack clickedItem) {
        Player player = resident.getPlayer();
        if (player == null || !clickedItem.hasItemMeta()) {
            return;
        }
        Inventory inventory = Bukkit.createInventory(null, (int)54, (Component)Translatable.of("permission_gui_header").component(player.locale()));
        String uuidString = (String)clickedItem.getItemMeta().getPersistentDataContainer().get(GUI_PLAYER_UUID_KEY, PersistentDataType.STRING);
        if (uuidString == null) {
            return;
        }
        Resident skullOwner = null;
        try {
            skullOwner = TownyAPI.getInstance().getResident(UUID.fromString(uuidString));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (skullOwner == null) {
            return;
        }
        inventory.setItem(4, clickedItem);
        SetPermissionType[] setPermissionTypes = townBlock.getPermissionOverrides().get(skullOwner).getPermissionTypes();
        for (TownyPermission.ActionType actionType : TownyPermission.ActionType.values()) {
            ItemStack wool = new ItemStack(setPermissionTypes[actionType.getIndex()].getWoolColour());
            ItemMeta woolMeta = wool.getItemMeta();
            woolMeta.displayName(Component.text((String)actionType.getCommonName(), (TextColor)setPermissionTypes[actionType.getIndex()].color()).decoration(TextDecoration.ITALIC, false));
            wool.setItemMeta(woolMeta);
            inventory.setItem(woolSlots[actionType.getIndex()], wool);
        }
        ItemStack saveButton = new ItemStack(Material.LIME_WOOL);
        saveButton.editMeta(meta -> {
            meta.displayName(Component.text((String)"Save", (TextColor)NamedTextColor.GREEN, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}).decoration(TextDecoration.ITALIC, false));
            meta.getPersistentDataContainer().set(EDIT_GUI_SAVE_KEY, PersistentDataType.BOOLEAN, (Object)true);
        });
        ItemStack backButton = new ItemStack(Material.RED_WOOL);
        backButton.editMeta(meta -> {
            meta.displayName(Component.text((String)"Back", (TextColor)NamedTextColor.DARK_RED, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}).decoration(TextDecoration.ITALIC, false));
            meta.getPersistentDataContainer().set(EDIT_GUI_BACK_KEY, PersistentDataType.BOOLEAN, (Object)true);
        });
        ItemStack deleteButton = new ItemStack(Material.RED_WOOL);
        deleteButton.editMeta(meta -> {
            meta.displayName(Component.text((String)"Delete", (TextColor)NamedTextColor.DARK_RED, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}).decoration(TextDecoration.ITALIC, false));
            meta.getPersistentDataContainer().set(EDIT_GUI_DELETE_KEY, PersistentDataType.BOOLEAN, (Object)true);
        });
        inventory.setItem(48, saveButton);
        inventory.setItem(50, backButton);
        inventory.setItem(53, deleteButton);
        new EditGUI(resident, inventory, Translatable.of("permission_gui_header").component(player.locale()), townBlock, skullOwner);
    }

    public static SetPermissionType[] getDefaultTypes() {
        return defaultTypes;
    }

    public static int[] getWoolSlots() {
        return woolSlots;
    }

    public static ItemStack createTutorialBook() {
        ItemStack book = new ItemStack(Material.WRITTEN_BOOK);
        BookMeta meta = (BookMeta)book.getItemMeta();
        ArrayList<String> pages = new ArrayList<String>();
        pages.add("    <bold>Plot Perm GUI</bold>\n\nUsing the GUI, you can give or remove permissions from individual players in your plots.\n\n<bold>  Getting Started</bold>\n\nTo start, you will need to add players to the GUI. You can do this using /plot perm add.");
        pages.add("After a player has been added, you can now start editing their permissions.\n\n<bold>    Permissions</bold>\n\nAfter you've clicked on a player head, you will be able to edit their permissions. <green>Green</green> means that this player has this permission.");
        pages.add("<red>Red</red> means that this player does not have this permission.\n\n<gray>Gray</gray> means that normal plot permissions apply.\n\nWhen starting out, all permissions will be gray. Note that denying permissions will not work for plot owners or mayors.");
        meta.setTitle("GUI Tutorial");
        meta.setGeneration(BookMeta.Generation.ORIGINAL);
        for (String page : pages) {
            meta.addPages(new Component[]{MiniMessage.miniMessage().deserialize((Object)page)});
        }
        meta.setAuthor("Warriorrr");
        book.setItemMeta((ItemMeta)meta);
        return book;
    }

    public static void handleConversation(Player player) {
        TownBlock startingTownBlock = WorldCoord.parseWorldCoord((Entity)player).getTownBlockOrNull();
        if (startingTownBlock == null) {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_not_claimed_1"));
            return;
        }
        new ResidentConversation(player).runOnResponse(res -> {
            if (!TownyUniverse.getInstance().getPermissionSource().testPermission((Permissible)player, PermissionNodes.TOWNY_COMMAND_PLOT_PERM_ADD.getNode())) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_command_disable"));
                return;
            }
            Resident resident = (Resident)res;
            if (startingTownBlock.hasPlotObjectGroup()) {
                PlotGroup group = startingTownBlock.getPlotObjectGroup();
                if (group.getPermissionOverrides().containsKey(resident)) {
                    TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_overrides_already_set", resident.getName(), Translatable.of("plotgroup_sing")));
                    return;
                }
                group.putPermissionOverride(resident, new PermissionData(PermissionGUIUtil.getDefaultTypes(), player.getName()));
            } else {
                if (startingTownBlock.getPermissionOverrides().containsKey(resident)) {
                    TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_overrides_already_set", resident.getName(), Translatable.of("townblock")));
                    return;
                }
                startingTownBlock.getPermissionOverrides().put(resident, new PermissionData(PermissionGUIUtil.getDefaultTypes(), player.getName()));
                startingTownBlock.save();
            }
            TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_overrides_added", resident.getName()));
            PermissionGUIUtil.openPermissionGUI(TownyAPI.getInstance().getResident(player), startingTownBlock);
        });
    }

    public static enum SetPermissionType {
        UNSET(NamedTextColor.DARK_GRAY, Material.GRAY_WOOL),
        SET(NamedTextColor.DARK_GREEN, Material.LIME_WOOL),
        NEGATED(NamedTextColor.DARK_RED, Material.RED_WOOL);

        private final NamedTextColor color;
        private final Material woolColour;

        private SetPermissionType(NamedTextColor color, Material woolColour) {
            this.color = color;
            this.woolColour = woolColour;
        }

        @Deprecated(since="0.101.2.5")
        public String getColor() {
            return Colors.getLegacyFromNamedTextColor(this.color);
        }

        public TextColor color() {
            return this.color;
        }

        public Material getWoolColour() {
            return this.woolColour;
        }
    }
}

