/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.utils;

import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.District;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockOwner;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.utils.AreaSelectionUtil;
import com.palmergames.util.MathUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class ProximityUtil {
    public static void allowTownHomeBlockOrThrow(TownyWorld world, Coord key, @Nullable Town town, boolean newTown) throws TownyException {
        if (!world.hasTowns()) {
            return;
        }
        if (newTown && (TownySettings.getMinDistanceFromTownPlotblocks() > 0 || TownySettings.getNewTownMinDistanceFromTownPlots() > 0)) {
            int minDistance = TownySettings.getNewTownMinDistanceFromTownPlots();
            if (minDistance <= 0) {
                minDistance = TownySettings.getMinDistanceFromTownPlotblocks();
            }
            if (world.getMinDistanceFromOtherTownsPlots(key) < minDistance) {
                throw new TownyException(Translatable.of("msg_too_close2", Translatable.of("townblock")));
            }
        }
        if (TownySettings.getMinDistanceFromTownHomeblocks() > 0 || TownySettings.getMaxDistanceBetweenHomeblocks() > 0 || TownySettings.getMinDistanceBetweenHomeblocks() > 0 || newTown && TownySettings.getNewTownMinDistanceFromTownHomeblocks() > 0) {
            int minDistance;
            int distanceToNextNearestHomeblock = world.getMinDistanceFromOtherTownsHomeBlocks(key, town);
            int n = minDistance = newTown ? TownySettings.getNewTownMinDistanceFromTownHomeblocks() : 0;
            if (minDistance <= 0) {
                minDistance = TownySettings.getMinDistanceFromTownHomeblocks();
            }
            if (distanceToNextNearestHomeblock < minDistance || distanceToNextNearestHomeblock < TownySettings.getMinDistanceBetweenHomeblocks()) {
                throw new TownyException(Translatable.of("msg_too_close2", Translatable.of("homeblock")));
            }
            if (TownySettings.getMaxDistanceBetweenHomeblocks() > 0 && distanceToNextNearestHomeblock > TownySettings.getMaxDistanceBetweenHomeblocks()) {
                throw new TownyException(Translatable.of("msg_too_far"));
            }
        }
    }

    public static void allowTownClaimOrThrow(TownyWorld world, WorldCoord townBlockToClaim, @Nullable Town town, boolean outpost) throws TownyException {
        ProximityUtil.allowTownClaimOrThrow(world, townBlockToClaim, town, outpost, false);
    }

    public static void allowTownClaimOrThrow(TownyWorld world, WorldCoord townBlockToClaim, @Nullable Town town, boolean outpost, boolean trade) throws TownyException {
        if (!town.hasUnlimitedClaims() && town.availableTownBlocks() <= 0) {
            throw new TownyException(Translatable.of("msg_err_not_enough_blocks"));
        }
        if (!trade && !townBlockToClaim.isWilderness()) {
            throw new TownyException(Translatable.of("msg_already_claimed", townBlockToClaim.getTownOrNull()));
        }
        if (AreaSelectionUtil.isTooCloseToHomeBlock(townBlockToClaim, town)) {
            throw new TownyException(Translatable.of("msg_too_close2", Translatable.of("homeblock")));
        }
        if (world.getMinDistanceFromOtherTownsPlots(townBlockToClaim, town) < TownySettings.getMinDistanceFromTownPlotblocks()) {
            throw new TownyException(Translatable.of("msg_too_close2", Translatable.of("townblock")));
        }
        ProximityUtil.testAdjacentClaimsRulesOrThrow(townBlockToClaim, town, outpost);
        if (!(outpost || ProximityUtil.isEdgeBlock(town, townBlockToClaim) || town.getTownBlocks().isEmpty())) {
            throw new TownyException(Translatable.of("msg_err_not_attached_edge"));
        }
    }

    public static void testAdjacentClaimsRulesOrThrow(WorldCoord townBlockToClaim, Town town, boolean outpost) throws TownyException {
        int minAdjacentBlocks = TownySettings.getMinAdjacentBlocks();
        ProximityUtil.testAdjacentClaimsRulesOrThrow(townBlockToClaim, town, outpost, minAdjacentBlocks);
    }

    public static void testAdjacentClaimsRulesOrThrow(WorldCoord townBlockToClaim, Town town, boolean outpost, int minAdjacentBlocks) throws TownyException {
        int numAdjacent;
        if (!outpost && minAdjacentBlocks > 0 && ProximityUtil.townHasClaimedEnoughLandToBeRestrictedByAdjacentClaims(town, minAdjacentBlocks) && (numAdjacent = ProximityUtil.numAdjacentTownOwnedTownBlocks(town, townBlockToClaim)) < minAdjacentBlocks && ProximityUtil.numAdjacentOutposts(town, townBlockToClaim) == 0) {
            throw new TownyException(Translatable.of("msg_min_adjacent_blocks", minAdjacentBlocks, numAdjacent));
        }
    }

    private static boolean townHasClaimedEnoughLandToBeRestrictedByAdjacentClaims(Town town, int minAdjacentBlocks) {
        if (minAdjacentBlocks == 3 && town.getTownBlocks().size() < 5) {
            return false;
        }
        return town.getTownBlocks().size() > minAdjacentBlocks;
    }

    private static int numAdjacentTownOwnedTownBlocks(Town town, WorldCoord worldCoord) {
        return (int)worldCoord.getCardinallyAdjacentWorldCoords(true).stream().filter(wc -> wc.hasTown(town)).count();
    }

    private static int numAdjacentOutposts(Town town, WorldCoord worldCoord) {
        return (int)worldCoord.getCardinallyAdjacentWorldCoords(true).stream().filter(wc -> wc.hasTown(town)).map(WorldCoord::getTownBlockOrNull).filter(Objects::nonNull).filter(TownBlock::isOutpost).count();
    }

    private static boolean isEdgeBlock(TownBlockOwner owner, WorldCoord worldCoord) {
        for (WorldCoord wc : worldCoord.getCardinallyAdjacentWorldCoords(new boolean[0])) {
            if (wc.isWilderness() || !wc.getTownBlockOrNull().isOwner(owner)) continue;
            return true;
        }
        return false;
    }

    public static void allowTownUnclaimOrThrow(TownyWorld world, WorldCoord townBlockToUnclaim, @Nullable Town town) throws TownyException {
        if (townBlockToUnclaim.isWilderness()) {
            throw new TownyException(Translatable.of("msg_err_empty_area_selection"));
        }
        if (!townBlockToUnclaim.getTownBlockOrNull().getTownOrNull().equals(town)) {
            throw new TownyException(Translatable.of("msg_not_own_area"));
        }
        if (townBlockToUnclaim.getTownBlock().isHomeBlock()) {
            throw new TownyException(Translatable.of("msg_err_cannot_unclaim_homeblock"));
        }
        ProximityUtil.testAdjacentUnclaimsRulesOrThrow(townBlockToUnclaim, town);
    }

    public static void testAdjacentUnclaimsRulesOrThrow(WorldCoord townBlockToUnclaim, Town town) throws TownyException {
        int minAdjacentBlocks = TownySettings.getMinAdjacentBlocks();
        ProximityUtil.testAdjacentUnclaimsRulesOrThrow(townBlockToUnclaim, town, minAdjacentBlocks);
    }

    public static void testAdjacentUnclaimsRulesOrThrow(WorldCoord townBlockToUnclaim, Town town, int minAdjacentBlocks) throws TownyException {
        if (minAdjacentBlocks > 0 && ProximityUtil.townHasClaimedEnoughLandToBeRestrictedByAdjacentClaims(town, minAdjacentBlocks)) {
            WorldCoord firstWorldCoord = townBlockToUnclaim;
            for (WorldCoord wc : firstWorldCoord.getCardinallyAdjacentWorldCoords(true)) {
                int numAdjacent;
                if (wc.isWilderness() || !wc.hasTown(town) || (numAdjacent = ProximityUtil.numAdjacentTownOwnedTownBlocks(town, wc)) - 1 >= minAdjacentBlocks || ProximityUtil.numAdjacentOutposts(town, wc) != 0) continue;
                throw new TownyException(Translatable.of("msg_err_cannot_unclaim_not_enough_adjacent_claims", wc.getX(), wc.getZ(), numAdjacent));
            }
        }
    }

    public static void testAdjacentAddDistrictRulesOrThrow(WorldCoord townBlockToClaim, Town town, District district, int minAdjacentBlocks) throws TownyException {
        int numAdjacent;
        if (minAdjacentBlocks > 0 && ProximityUtil.townHasClaimedEnoughLandToBeRestrictedByAdjacentClaims(town, minAdjacentBlocks) && (numAdjacent = ProximityUtil.numAdjacentDistrictTownBlocks(town, district, townBlockToClaim)) < minAdjacentBlocks) {
            throw new TownyException(Translatable.of("msg_min_adjacent_district_blocks", minAdjacentBlocks));
        }
    }

    private static int numAdjacentDistrictTownBlocks(Town town, District district, WorldCoord worldCoord) {
        return (int)worldCoord.getCardinallyAdjacentWorldCoords(true).stream().filter(wc -> wc.hasTown(town) && wc.getTownBlockOrNull() != null).map(wc -> wc.getTownBlockOrNull()).filter(tb -> tb.hasDistrict() && tb.getDistrict().equals(district)).count();
    }

    public static void testAdjacentRemoveDistrictRulesOrThrow(WorldCoord districtCoordBeingRemoved, Town town, District district, int minAdjacentBlocks) throws TownyException {
        if (minAdjacentBlocks > 0 && ProximityUtil.townHasClaimedEnoughLandToBeRestrictedByAdjacentClaims(town, minAdjacentBlocks)) {
            List<WorldCoord> allAdjacentDistrictWorldCoords = ProximityUtil.getAdjacentDistrictWorldCoords(town, district, districtCoordBeingRemoved, false);
            int districtPlots = allAdjacentDistrictWorldCoords.size();
            if (districtPlots >= 7) {
                return;
            }
            if (districtPlots < minAdjacentBlocks) {
                throw new TownyException(Translatable.of("msg_err_cannot_remove_from_district_not_enough_adjacent_claims", district.getName()));
            }
            for (WorldCoord wc : allAdjacentDistrictWorldCoords) {
                int numAdjacent;
                if (wc.isWilderness() || !wc.hasTown(town) || !wc.getTownBlock().hasDistrict() || !wc.getTownBlock().getDistrict().getName().equals(district.getName()) || (numAdjacent = ProximityUtil.numAdjacentDistrictTownBlocks(town, district, wc)) - 1 >= minAdjacentBlocks) continue;
                throw new TownyException(Translatable.of("msg_err_cannot_remove_from_district_not_enough_adjacent_claims", wc.getX(), wc.getZ(), numAdjacent));
            }
            List<WorldCoord> cardinallyAdjacentDistrictWorldCoords = ProximityUtil.getAdjacentDistrictWorldCoords(town, district, districtCoordBeingRemoved, true);
            if (ProximityUtil.checkForTwoDistrictsPlotsOnOppositeSides(cardinallyAdjacentDistrictWorldCoords, district.getName())) {
                return;
            }
            for (WorldCoord coord : cardinallyAdjacentDistrictWorldCoords) {
                allAdjacentDistrictWorldCoords.remove(coord);
            }
            if (ProximityUtil.checkForTwoDistrictsPlotsOnOppositeSides(allAdjacentDistrictWorldCoords, district.getName())) {
                return;
            }
        }
    }

    private static boolean checkForTwoDistrictsPlotsOnOppositeSides(List<WorldCoord> worldCoordsToTest, String districtName) throws TownyException {
        if (worldCoordsToTest.size() != 2) {
            return true;
        }
        double distance = MathUtil.distance(worldCoordsToTest.get(0), worldCoordsToTest.get(1));
        if (distance >= 2.0) {
            throw new TownyException(Translatable.of("msg_err_cannot_remove_from_district_not_enough_adjacent_claims", districtName));
        }
        return true;
    }

    private static List<WorldCoord> getAdjacentDistrictWorldCoords(Town town, District district, WorldCoord worldCoord, boolean cardinalOnly) {
        return worldCoord.getCardinallyAdjacentWorldCoords(!cardinalOnly).stream().filter(wc -> wc.hasTown(town) && wc.getTownBlockOrNull() != null).map(wc -> wc.getTownBlockOrNull()).filter(tb -> tb.hasDistrict() && tb.getDistrict().equals(district)).map(TownBlock::getWorldCoord).collect(Collectors.toList());
    }

    public static void testTownProximityToNation(Town town, Nation nation) throws TownyException {
        if (TownySettings.getNationProximityToCapital() <= 0.0) {
            return;
        }
        Town capital = nation.getCapital();
        if (!capital.hasHomeBlock() || !town.hasHomeBlock()) {
            throw new TownyException(Translatable.of("msg_err_homeblock_has_not_been_set"));
        }
        WorldCoord capitalCoord = capital.getHomeBlockOrNull().getWorldCoord();
        WorldCoord townCoord = town.getHomeBlockOrNull().getWorldCoord();
        if (!capitalCoord.getWorldName().equalsIgnoreCase(townCoord.getWorldName())) {
            throw new TownyException(Translatable.of("msg_err_nation_homeblock_in_another_world"));
        }
        List<Town> townsClosestToFarthest = ProximityUtil.sortTownsClosestToFarthest(nation);
        if (ProximityUtil.isTownTooFarFromNation(town, capital, townsClosestToFarthest)) {
            throw new TownyException(Translatable.of("msg_err_town_not_close_enough_to_nation", town.getName()));
        }
    }

    private static List<Town> sortTownsClosestToFarthest(Nation nation) {
        List<Town> sortedTowns = nation.getTowns().stream().sorted(Comparator.comparingInt(t -> ProximityUtil.getDistanceFromCapital(t, nation))).collect(Collectors.toList());
        return sortedTowns;
    }

    private static int getDistanceFromCapital(Town town, Nation nation) {
        TownBlock capitalHomeblock = nation.getCapital().getHomeBlockOrNull();
        TownBlock townHomeblock = town.getHomeBlockOrNull();
        if (capitalHomeblock == null || townHomeblock == null) {
            return Integer.MAX_VALUE;
        }
        if (!capitalHomeblock.getWorld().equals(townHomeblock.getWorld())) {
            return Integer.MAX_VALUE;
        }
        return (int)MathUtil.distance(capitalHomeblock.getCoord(), townHomeblock.getCoord());
    }

    public static List<Town> gatherOutOfRangeTowns(Nation nation) {
        return ProximityUtil.gatherOutOfRangeTowns(nation, nation.getCapital());
    }

    public static List<Town> gatherOutOfRangeTowns(Nation nation, Town capital) {
        List<Town> recentValidTowns;
        ArrayList<Town> removedTowns = new ArrayList<Town>();
        if (TownySettings.getNationProximityToCapital() <= 0.0) {
            return removedTowns;
        }
        TownBlock capitalHomeBlock = capital.getHomeBlockOrNull();
        if (capitalHomeBlock == null) {
            return removedTowns;
        }
        WorldCoord capitalCoord = capitalHomeBlock.getWorldCoord();
        List<Town> townsToCheck = ProximityUtil.sortTownsClosestToFarthest(nation);
        ArrayList<Town> localTownsToKeep = new ArrayList<Town>();
        townsToCheck.remove(capital);
        localTownsToKeep.add(capital);
        while (townsToCheck.size() > 0 && (recentValidTowns = ProximityUtil.getListOfInRangeTownsFromList(townsToCheck, localTownsToKeep, capital, capitalCoord)).size() != 0) {
            for (Town validTown : recentValidTowns) {
                localTownsToKeep.add(validTown);
                townsToCheck.remove(validTown);
            }
        }
        return nation.getTowns().stream().filter(t -> !localTownsToKeep.contains(t)).collect(Collectors.toList());
    }

    private static List<Town> getListOfInRangeTownsFromList(List<Town> townsToCheck, List<Town> validTowns, Town capital, WorldCoord capitalCoord) {
        ArrayList<Town> allowedTowns = new ArrayList<Town>();
        for (Town town : townsToCheck) {
            if (town.equals(capital) || !ProximityUtil.isTownCloseEnoughToNation(town, capital, townsToCheck, validTowns)) continue;
            allowedTowns.add(town);
        }
        return allowedTowns;
    }

    public static boolean isTownCloseEnoughToNation(Town town, Town newCapital, List<Town> townsToCheck, List<Town> validTowns) {
        return ProximityUtil.closeEnoughToCapital(town, newCapital) || ProximityUtil.closeEnoughToOtherNationTowns(town, newCapital, townsToCheck, validTowns);
    }

    private static boolean closeEnoughToOtherNationTowns(Town town, Town newCapital, List<Town> townsToCheck, List<Town> validTowns) {
        double maxDistanceFromOtherTowns = TownySettings.getNationProximityToOtherNationTowns();
        double maxDistanceFromTheCapital = TownySettings.getNationProximityAbsoluteMaximum();
        if (maxDistanceFromOtherTowns <= 0.0) {
            return false;
        }
        if (maxDistanceFromTheCapital > 0.0 && !ProximityUtil.closeEnoughToTown(town, newCapital, maxDistanceFromTheCapital)) {
            return false;
        }
        for (Town validTown : validTowns) {
            if (!ProximityUtil.closeEnoughToTown(validTown, town, maxDistanceFromOtherTowns)) continue;
            return true;
        }
        return false;
    }

    public static void removeOutOfRangeTowns(Nation nation) {
        if (!nation.hasCapital() || TownySettings.getNationProximityToCapital() <= 0.0) {
            return;
        }
        List<Town> toRemove = ProximityUtil.gatherOutOfRangeTowns(nation);
        if (toRemove.isEmpty()) {
            return;
        }
        toRemove.stream().forEach(town -> {
            TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_town_left_nation", nation.getName()));
            TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_nation_town_left", town.getName()));
            town.removeNation();
            town.save();
        });
    }

    public static boolean isTownTooFarFromNation(Town town, Town newCapital, List<Town> towns) {
        return !ProximityUtil.closeEnoughToCapital(town, newCapital) && !ProximityUtil.closeEnoughToOtherNationTowns(town, newCapital, towns);
    }

    private static boolean closeEnoughToCapital(Town town, Town newCapital) {
        return ProximityUtil.closeEnoughToTown(town, newCapital, TownySettings.getNationProximityToCapital());
    }

    private static boolean closeEnoughToOtherNationTowns(Town town, Town newCapital, List<Town> towns) {
        double maxDistanceFromOtherTowns = TownySettings.getNationProximityToOtherNationTowns();
        double maxDistanceFromTheCapital = TownySettings.getNationProximityAbsoluteMaximum();
        if (maxDistanceFromOtherTowns <= 0.0) {
            return false;
        }
        if (maxDistanceFromTheCapital > 0.0 && !ProximityUtil.closeEnoughToTown(town, newCapital, maxDistanceFromTheCapital)) {
            return false;
        }
        return towns.stream().filter(t -> !t.equals(town) && !t.isCapital()).anyMatch(t -> ProximityUtil.closeEnoughToTown(town, t, maxDistanceFromOtherTowns));
    }

    private static boolean closeEnoughToTown(Town town1, Town town2, double maxAllowedDistance) {
        if (!town1.hasHomeBlock() || !town2.hasHomeBlock()) {
            return false;
        }
        WorldCoord town1Coord = town1.getHomeBlockOrNull().getWorldCoord();
        WorldCoord town2Coord = town2.getHomeBlockOrNull().getWorldCoord();
        if (!town1Coord.getWorldName().equals(town2Coord.getWorldName())) {
            return false;
        }
        return MathUtil.distance(town1Coord, town2Coord) <= maxAllowedDistance;
    }
}

