/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.utils;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyTimerHandler;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.confirmations.Confirmation;
import com.palmergames.bukkit.towny.event.NationSpawnEvent;
import com.palmergames.bukkit.towny.event.SpawnEvent;
import com.palmergames.bukkit.towny.event.TownSpawnEvent;
import com.palmergames.bukkit.towny.event.teleport.ResidentSpawnEvent;
import com.palmergames.bukkit.towny.event.teleport.SuccessfulTownyTeleportEvent;
import com.palmergames.bukkit.towny.event.teleport.UnjailedResidentTeleportEvent;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.SpawnInformation;
import com.palmergames.bukkit.towny.object.SpawnType;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.object.economy.Account;
import com.palmergames.bukkit.towny.object.economy.TownyServerAccount;
import com.palmergames.bukkit.towny.object.spawnlevel.NationSpawnLevel;
import com.palmergames.bukkit.towny.object.spawnlevel.TownSpawnLevel;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.tasks.CooldownTimerTask;
import com.palmergames.bukkit.towny.tasks.TeleportWarmupTimerTask;
import com.palmergames.bukkit.towny.utils.CombatUtil;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.ItemLists;
import java.util.BitSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpawnUtil {
    private static Towny plugin;

    public static void initialize(Towny plugin) {
        SpawnUtil.plugin = plugin;
    }

    public static void sendToTownySpawn(Player player, String[] split, TownyObject townyObject, String notAffordMSG, boolean outpost, boolean ignoreWarn, SpawnType spawnType) throws TownyException {
        Resident resident = TownyAPI.getInstance().getResidentOrThrow(player);
        Town town = switch (spawnType) {
            case SpawnType.RESIDENT -> resident.getTownOrNull();
            case SpawnType.TOWN -> (Town)townyObject;
            default -> null;
        };
        Nation nation = spawnType == SpawnType.NATION ? (Nation)townyObject : null;
        SpawnInformation spawnInfo = SpawnUtil.getSpawnInformation(player, split.length == 0, notAffordMSG, outpost, spawnType, resident, town, nation);
        SpawnUtil.getSpawnLoc(player, town, nation, spawnType, outpost, split).thenAccept(spawnLoc -> {
            if (!spawnLoc.isWorldLoaded()) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_world_not_loaded"));
                return;
            }
            try {
                SpawnUtil.sendSpawnEvent(player, spawnType, spawnLoc, spawnInfo);
            }
            catch (TownyException e) {
                TownyMessaging.sendErrorMsg(player, e.getMessage((CommandSender)player));
                return;
            }
            if (spawnInfo.travelCost > 0.0) {
                String paymentMsg = SpawnUtil.getPaymentMsg(spawnInfo.townSpawnLevel, spawnInfo.nationSpawnLevel, spawnType);
                TownyServerAccount payee = TownySettings.isTownSpawnPaidToTown() ? SpawnUtil.getPayee(town, nation, spawnType) : TownyServerAccount.ACCOUNT;
                SpawnUtil.initiateCostedSpawn(player, resident, spawnLoc, spawnInfo.travelCost, payee, paymentMsg, ignoreWarn, spawnInfo.cooldown);
            } else {
                SpawnUtil.initiateSpawn(player, spawnLoc, spawnInfo.cooldown, 0.0, null);
            }
        });
    }

    private static SpawnInformation getSpawnInformation(Player player, boolean noCmdArgs, String notAffordMSG, boolean outpost, SpawnType spawnType, Resident resident, Town town, Nation nation) {
        boolean isTownyAdmin = SpawnUtil.isTownyAdmin(player);
        SpawnInformation spawnInformation = new SpawnInformation();
        try {
            SpawnUtil.testResidentAbility(resident);
            spawnInformation.townSpawnLevel = SpawnUtil.getTownSpawnLevel(player, noCmdArgs, spawnType, resident, town, outpost, isTownyAdmin);
            spawnInformation.nationSpawnLevel = SpawnUtil.getNationSpawnLevel(player, noCmdArgs, spawnType, resident, nation, isTownyAdmin);
            spawnInformation.cooldown = SpawnUtil.getCooldown(player, spawnInformation);
            if (!isTownyAdmin) {
                SpawnUtil.testDisallowedZones(player, resident, spawnType, TownySettings.getDisallowedTownSpawnZones());
            }
            spawnInformation.travelCost = SpawnUtil.getTravelCost(player, town, nation, spawnInformation.townSpawnLevel, spawnInformation.nationSpawnLevel, spawnType);
            if (spawnInformation.travelCost > 0.0 && !resident.getAccount().canPayFromHoldings(spawnInformation.travelCost)) {
                throw new TownyException(notAffordMSG);
            }
        }
        catch (TownyException te) {
            spawnInformation.eventCancelled = true;
            spawnInformation.eventCancellationMessage = te.getMessage();
        }
        return spawnInformation;
    }

    public static void outlawTeleport(Town town, Resident outlaw) {
        Player outlawedPlayer = outlaw.getPlayer();
        if (outlawedPlayer == null) {
            return;
        }
        BukkitTools.getRespawnLocation(outlawedPlayer).thenAccept(bed -> {
            Location spawnLocation = town.getWorld().getSpawnLocation();
            if (!TownySettings.getOutlawTeleportWorld().equals("")) {
                spawnLocation = Objects.requireNonNull(Bukkit.getWorld((String)TownySettings.getOutlawTeleportWorld())).getSpawnLocation();
            }
            if (bed != null && TownyAPI.getInstance().getTown((Location)bed) != town) {
                spawnLocation = bed;
            }
            if (outlaw.hasTown() && TownyAPI.getInstance().getTownSpawnLocation(outlawedPlayer) != null) {
                spawnLocation = TownyAPI.getInstance().getTownSpawnLocation(outlawedPlayer);
            }
            TownyMessaging.sendMsg(outlaw, Translatable.of("msg_outlaw_kicked", town));
            SpawnUtil.initiatePluginTeleport(outlaw, spawnLocation, true);
        });
    }

    public static void jailAwayTeleport(Resident jailed) {
        SpawnUtil.getIdealLocation(jailed).thenAccept(loc -> {
            UnjailedResidentTeleportEvent event = new UnjailedResidentTeleportEvent(jailed, (Location)loc);
            if (BukkitTools.isEventCancelled(event)) {
                return;
            }
            SpawnUtil.initiatePluginTeleport(jailed, event.getLocation(), false);
        });
    }

    public static void jailTeleport(Resident jailed) {
        SpawnUtil.initiatePluginTeleport(jailed, jailed.getJailSpawn(), false);
    }

    private static void testResidentAbility(Resident resident) throws TownyException {
        if (CooldownTimerTask.hasCooldown(resident.getName(), "teleport")) {
            throw new TownyException(Translatable.of("msg_err_cannot_spawn_x_seconds_remaining", CooldownTimerTask.getCooldownRemaining(resident.getName(), "teleport")));
        }
        if (resident.isJailed()) {
            throw new TownyException(Translatable.of("msg_cannot_spawn_while_jailed"));
        }
    }

    private static boolean isTownyAdmin(Player player) {
        return TownyUniverse.getInstance().getPermissionSource().isTownyAdmin((Permissible)player) || SpawnUtil.hasPerm(player, PermissionNodes.TOWNY_SPAWN_ADMIN);
    }

    private static boolean playerHasFreeSpawn(Player player) {
        return SpawnUtil.hasPerm(player, PermissionNodes.TOWNY_COMMAND_TOWNYADMIN_TOWN_SPAWN_FREECHARGE) || SpawnUtil.hasPerm(player, PermissionNodes.TOWNY_SPAWN_ADMIN_NOCHARGE);
    }

    private static TownSpawnLevel getTownSpawnLevel(Player player, boolean noCmdArgs, SpawnType spawnType, Resident resident, Town town, boolean outpost, boolean isTownyAdmin) throws TownyException {
        return switch (spawnType) {
            case SpawnType.RESIDENT -> {
                if (isTownyAdmin) {
                    yield TownSpawnLevel.ADMIN;
                }
                yield TownSpawnLevel.TOWN_RESIDENT;
            }
            case SpawnType.TOWN -> {
                if (isTownyAdmin) {
                    yield TownSpawnLevel.ADMIN;
                }
                yield SpawnUtil.getTownSpawnLevel(player, resident, town, outpost, noCmdArgs);
            }
            default -> null;
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static TownSpawnLevel getTownSpawnLevel(Player player, Resident resident, Town town, boolean outpost, boolean noArg) throws TownyException {
        TownSpawnLevel townSpawnLevel = null;
        if (noArg && !outpost) {
            townSpawnLevel = TownSpawnLevel.TOWN_RESIDENT;
        } else {
            if (TownySettings.trustedResidentsGetToSpawnToTown() && (town.hasTrustedResident(resident) || resident.hasTown() && town.hasTrustedTown(resident.getTownOrNull()))) {
                townSpawnLevel = TownSpawnLevel.TOWN_RESIDENT;
            } else if (!resident.hasTown()) {
                townSpawnLevel = TownSpawnLevel.UNAFFILIATED;
            } else if (resident.getTownOrNull() == town) {
                townSpawnLevel = outpost ? TownSpawnLevel.TOWN_RESIDENT_OUTPOST : TownSpawnLevel.TOWN_RESIDENT;
            } else if (resident.hasNation() && town.hasNation()) {
                Nation targetNation;
                Nation playerNation = resident.getNationOrNull();
                if (playerNation == (targetNation = town.getNationOrNull())) {
                    if (!town.isPublic() && TownySettings.isAllySpawningRequiringPublicStatus() && !resident.hasPermissionNode(PermissionNodes.TOWNY_SPAWN_NATION_BYPASS_PUBLIC.getNode())) {
                        throw new TownyException(Translatable.of("msg_err_ally_isnt_public", town));
                    }
                    townSpawnLevel = TownSpawnLevel.PART_OF_NATION;
                } else if (targetNation.hasEnemy(playerNation)) {
                    if (!town.isNeutral() || !TownySettings.areEnemiesAllowedToSpawnToPeacefulTowns()) throw new TownyException(Translatable.of("msg_err_public_spawn_enemy"));
                    townSpawnLevel = TownSpawnLevel.TOWN_RESIDENT;
                } else if (targetNation.hasAlly(playerNation)) {
                    if (!town.isPublic() && TownySettings.isAllySpawningRequiringPublicStatus() && !resident.hasPermissionNode(PermissionNodes.TOWNY_SPAWN_ALLY_BYPASS_PUBLIC.getNode())) {
                        throw new TownyException(Translatable.of("msg_err_ally_isnt_public", town));
                    }
                    townSpawnLevel = TownSpawnLevel.NATION_ALLY;
                } else {
                    townSpawnLevel = TownSpawnLevel.UNAFFILIATED;
                }
            } else {
                townSpawnLevel = TownSpawnLevel.UNAFFILIATED;
            }
            if (townSpawnLevel == TownSpawnLevel.UNAFFILIATED && !town.isPublic()) {
                if (TownySettings.isConfigAllowingPublicTownSpawnTravel()) throw new TownyException(Translatable.of("msg_err_not_public"));
                throw new TownyException(Translatable.of("msg_err_town_unaffiliated"));
            }
        }
        townSpawnLevel.checkIfAllowed(player, town);
        return townSpawnLevel;
    }

    private static NationSpawnLevel getNationSpawnLevel(Player player, boolean noCmdArgs, SpawnType spawnType, Resident resident, Nation nation, boolean isTownyAdmin) throws TownyException {
        return spawnType == SpawnType.NATION ? (isTownyAdmin ? NationSpawnLevel.ADMIN : SpawnUtil.getNationSpawnLevel(player, resident, nation, noCmdArgs)) : null;
    }

    private static NationSpawnLevel getNationSpawnLevel(Player player, Resident resident, Nation nation, boolean noArg) throws TownyException {
        NationSpawnLevel nationSpawnLevel = null;
        if (noArg) {
            nationSpawnLevel = NationSpawnLevel.PART_OF_NATION;
        } else {
            if (!resident.hasTown()) {
                nationSpawnLevel = NationSpawnLevel.UNAFFILIATED;
            } else if (resident.hasNation()) {
                Nation playerNation = resident.getNationOrNull();
                if (playerNation == nation) {
                    nationSpawnLevel = NationSpawnLevel.PART_OF_NATION;
                } else {
                    if (nation.hasEnemy(playerNation)) {
                        throw new TownyException(Translatable.of("msg_err_public_spawn_enemy"));
                    }
                    nationSpawnLevel = nation.hasAlly(playerNation) ? NationSpawnLevel.NATION_ALLY : NationSpawnLevel.UNAFFILIATED;
                }
            } else {
                nationSpawnLevel = NationSpawnLevel.UNAFFILIATED;
            }
            if (nationSpawnLevel == NationSpawnLevel.UNAFFILIATED && !nation.isPublic()) {
                if (!TownySettings.isConfigAllowingPublicNationSpawnTravel()) {
                    throw new TownyException(Translatable.of("msg_err_nation_unaffiliated"));
                }
                throw new TownyException(Translatable.of("msg_err_nation_not_public"));
            }
        }
        nationSpawnLevel.checkIfAllowed(player, nation);
        return nationSpawnLevel;
    }

    private static int getCooldown(Player player, SpawnInformation spawnInformation) {
        return player.hasPermission(PermissionNodes.TOWNY_SPAWN_ADMIN_NOCOOLDOWN.getNode()) ? 0 : (spawnInformation.townSpawnLevel != null ? spawnInformation.townSpawnLevel.getCooldown() : spawnInformation.nationSpawnLevel.getCooldown());
    }

    private static CompletableFuture<Location> getSpawnLoc(Player player, Town town, Nation nation, SpawnType spawnType, boolean outpost, String[] split) throws TownyException {
        return switch (spawnType) {
            default -> throw new IncompatibleClassChangeError();
            case SpawnType.RESIDENT -> {
                if (TownySettings.getBedUse()) {
                    yield BukkitTools.getRespawnLocation(player).thenApply(bedLoc -> {
                        if (bedLoc != null) {
                            return bedLoc;
                        }
                        if (town != null && town.hasSpawn()) {
                            return town.getSpawnOrNull();
                        }
                        return player.getWorld().getSpawnLocation();
                    });
                }
                if (town != null && town.hasSpawn()) {
                    yield SpawnUtil.adaptSpawnLocation(town.getSpawn(), player);
                }
                yield CompletableFuture.completedFuture(player.getWorld().getSpawnLocation());
            }
            case SpawnType.TOWN -> {
                if (outpost) {
                    yield SpawnUtil.adaptSpawnLocation(SpawnUtil.getOutpostSpawnLocation(player, town, split), player);
                }
                yield SpawnUtil.adaptSpawnLocation(town.getSpawn(), player);
            }
            case SpawnType.NATION -> SpawnUtil.adaptSpawnLocation(nation.getSpawn(), player);
        };
    }

    private static CompletableFuture<Location> adaptSpawnLocation(@NotNull Location location, @NotNull Player player) {
        if (!TownySettings.isSafeTeleportUsed()) {
            return CompletableFuture.completedFuture(location);
        }
        return location.getWorld().getChunkAtAsync(location).thenApply(chunk -> SpawnUtil.getSafeLocation(location, player));
    }

    private static Location getSafeLocation(Location location, Player p) {
        if (!TownySettings.isSafeTeleportUsed()) {
            return location;
        }
        if (SpawnUtil.isSafeLocation(location)) {
            return location;
        }
        if (TownySettings.isStrictSafeTeleportUsed()) {
            TownyMessaging.sendErrorMsg((CommandSender)p, Translatable.of("msg_spawn_cancel_safe_teleport"));
            return null;
        }
        int range = 22;
        BitSet isLiquidMap = new BitSet(44);
        BitSet isSolidMap = new BitSet(44);
        Location temp = location.clone().subtract(0.0, 22.0, 0.0);
        for (int i = 0; i < 44; ++i) {
            Material type = temp.getBlock().getType();
            if (ItemLists.LIQUID_BLOCKS.contains(type)) {
                isLiquidMap.set(i);
            }
            if (!ItemLists.NOT_SOLID_BLOCKS.contains(type)) {
                isSolidMap.set(i);
            }
            temp = temp.add(0.0, 1.0, 0.0);
        }
        int y = 0;
        for (int steps = 1; steps <= 40; ++steps) {
            int value = y + 22;
            if (!(!isSolidMap.get(value) || isLiquidMap.get(value) || isSolidMap.get(value + 1) || isLiquidMap.get(value + 1) || isSolidMap.get(value + 2) || isLiquidMap.get(value + 2))) {
                return location.clone().add(0.0, (double)(y + 1), 0.0);
            }
            y = SpawnUtil.next(y);
        }
        TownyMessaging.sendErrorMsg((CommandSender)p, Translatable.of("msg_spawn_fail_safe_teleport"));
        return null;
    }

    private static int next(int i) {
        if (i <= 0) {
            i = -i;
            ++i;
        } else {
            i = -i;
        }
        return i;
    }

    private static boolean isSafeLocation(Location location) {
        World world = location.getWorld();
        if (world == null) {
            return false;
        }
        Block block = world.getBlockAt(location);
        Material type = block.getType();
        if (!ItemLists.NOT_SOLID_BLOCKS.contains(type) || ItemLists.LIQUID_BLOCKS.contains(type)) {
            return false;
        }
        Block belowBlock = world.getBlockAt(location.clone().subtract(0.0, 1.0, 0.0));
        Material belowType = belowBlock.getType();
        if (ItemLists.NOT_SOLID_BLOCKS.contains(belowType) || ItemLists.LIQUID_BLOCKS.contains(type)) {
            return false;
        }
        Block aboveBlock = world.getBlockAt(location.clone().add(0.0, 1.0, 0.0));
        Material aboveType = aboveBlock.getType();
        return ItemLists.NOT_SOLID_BLOCKS.contains(aboveType) && !ItemLists.LIQUID_BLOCKS.contains(aboveType);
    }

    private static Location getOutpostSpawnLocation(Player player, Town town, String[] split) throws TownyException {
        if (!town.hasOutpostSpawn()) {
            throw new TownyException(Translatable.of("msg_err_outpost_spawn"));
        }
        Integer index = null;
        if (split.length <= 0) {
            index = 1;
        } else {
            String userInput = split[split.length - 1];
            try {
                index = !userInput.contains("name:") ? Integer.valueOf(Integer.parseInt(userInput)) : SpawnUtil.getOutpostIndexFromName(town, index, userInput.replace("name:", "").replace("_", " "));
            }
            catch (NumberFormatException e) {
                index = SpawnUtil.getOutpostIndexFromName(town, index, userInput.replace("_", " "));
            }
            catch (ArrayIndexOutOfBoundsException i) {
                index = 1;
            }
        }
        if (!TownyUniverse.getInstance().getPermissionSource().isTownyAdmin((Permissible)player) && TownySettings.isOutpostLimitStoppingTeleports() && TownySettings.isOutpostsLimitedByLevels() && town.isOverOutpostLimit() && Math.max(1, index) > town.getOutpostLimit()) {
            throw new TownyException(Translatable.of("msg_err_over_outposts_limit", town.getMaxOutpostSpawn(), town.getOutpostLimit()));
        }
        return town.getOutpostSpawn(Math.max(1, index));
    }

    private static Integer getOutpostIndexFromName(Town town, Integer index, String userInput) {
        for (Location loc : town.getAllOutpostSpawns()) {
            String name;
            TownBlock tboutpost = TownyAPI.getInstance().getTownBlock(loc);
            if (tboutpost == null || !(name = !tboutpost.hasPlotObjectGroup() ? tboutpost.getName() : tboutpost.getPlotObjectGroup().getName()).toLowerCase(Locale.ROOT).startsWith(userInput.toLowerCase(Locale.ROOT))) continue;
            index = 1 + town.getAllOutpostSpawns().indexOf(loc);
        }
        if (index == null) {
            index = 1;
        }
        return index;
    }

    private static void testDisallowedZones(Player player, Resident resident, SpawnType spawnType, List<String> disallowedZones) throws TownyException {
        if (!disallowedZones.isEmpty()) {
            Town townAtPlayerLoc = TownyAPI.getInstance().getTown(player.getLocation());
            if (townAtPlayerLoc == null && disallowedZones.contains("unclaimed")) {
                throw new TownyException(Translatable.of("msg_err_x_spawn_disallowed_from_x", spawnType.typeName(), Translatable.of("msg_the_wilderness")));
            }
            if (townAtPlayerLoc != null) {
                Nation townLocNation;
                if (townAtPlayerLoc.hasOutlaw(player.getName()) && disallowedZones.contains("outlaw")) {
                    throw new TownyException(Translatable.of("msg_err_x_spawn_disallowed_from_x", "RTP", Translatable.of("msg_a_town_you_are_outlawed_in")));
                }
                if (resident.hasTown() && townAtPlayerLoc.hasNation() && (townLocNation = townAtPlayerLoc.getNationOrNull()).hasSanctionedTown(resident.getTownOrNull())) {
                    throw new TownyException(Translatable.of("msg_err_cannot_nation_spawn_your_town_is_sanctioned", townLocNation.getName()));
                }
                if (resident.hasNation() && townAtPlayerLoc.hasNation()) {
                    Nation resNation;
                    if (CombatUtil.isEnemy(resident.getTownOrNull(), townAtPlayerLoc) && disallowedZones.contains("enemy")) {
                        throw new TownyException(Translatable.of("msg_err_x_spawn_disallowed_from_x", spawnType.typeName(), Translatable.of("msg_enemy_areas")));
                    }
                    townLocNation = townAtPlayerLoc.getNationOrNull();
                    if (!townLocNation.hasAlly(resNation = resident.getNationOrNull()) && !townLocNation.hasEnemy(resNation) && disallowedZones.contains("neutral")) {
                        throw new TownyException(Translatable.of("msg_err_x_spawn_disallowed_from_x", spawnType.typeName(), Translatable.of("msg_neutral_towns")));
                    }
                }
            }
        }
    }

    private static double getTravelCost(Player player, Town town, Nation nation, TownSpawnLevel townSpawnLevel, NationSpawnLevel nationSpawnLevel, SpawnType spawnType) {
        if (!TownyEconomyHandler.isActive() || SpawnUtil.playerHasFreeSpawn(player)) {
            return 0.0;
        }
        if (!TownySettings.isPublicSpawnCostAffectedByTownSpawncost() && (SpawnUtil.isPublicSpawn(townSpawnLevel) || SpawnUtil.isPublicSpawn(nationSpawnLevel))) {
            return TownySettings.getSpawnTravelCost();
        }
        return switch (spawnType) {
            default -> throw new IncompatibleClassChangeError();
            case SpawnType.RESIDENT -> {
                if (town == null) {
                    yield 0.0;
                }
                yield Math.min(townSpawnLevel.getCost(town), townSpawnLevel.getCost());
            }
            case SpawnType.TOWN -> Math.min(townSpawnLevel.getCost(town), townSpawnLevel.getCost());
            case SpawnType.NATION -> Math.min(nationSpawnLevel.getCost(nation), nationSpawnLevel.getCost());
        };
    }

    private static boolean isPublicSpawn(NationSpawnLevel nationSpawnLevel) {
        return NationSpawnLevel.UNAFFILIATED.equals((Object)nationSpawnLevel);
    }

    private static boolean isPublicSpawn(TownSpawnLevel townSpawnLevel) {
        return TownSpawnLevel.UNAFFILIATED.equals((Object)townSpawnLevel);
    }

    private static String getPaymentMsg(TownSpawnLevel townSpawnLevel, NationSpawnLevel nationSpawnLevel, SpawnType spawnType) {
        return switch (spawnType) {
            default -> throw new IncompatibleClassChangeError();
            case SpawnType.RESIDENT -> String.format(spawnType.getTypeName() + " (%s)", new Object[]{townSpawnLevel});
            case SpawnType.TOWN -> String.format(spawnType.getTypeName() + " (%s)", new Object[]{townSpawnLevel});
            case SpawnType.NATION -> String.format(spawnType.getTypeName() + " (%s)", new Object[]{nationSpawnLevel});
        };
    }

    private static Account getPayee(Town town, Nation nation, SpawnType spawnType) {
        return switch (spawnType) {
            default -> throw new IncompatibleClassChangeError();
            case SpawnType.RESIDENT -> {
                if (town == null) {
                    yield TownyServerAccount.ACCOUNT;
                }
                yield town.getAccount();
            }
            case SpawnType.TOWN -> town.getAccount();
            case SpawnType.NATION -> nation.getAccount();
        };
    }

    private static void sendSpawnEvent(Player player, SpawnType spawnType, Location spawnLoc, SpawnInformation spawnInformation) throws TownyException {
        BukkitTools.ifCancelledThenThrow(SpawnUtil.getSpawnEvent(player, spawnType, spawnLoc, spawnInformation));
    }

    private static SpawnEvent getSpawnEvent(Player player, SpawnType spawnType, Location spawnLoc, SpawnInformation spawnInfo) {
        return switch (spawnType) {
            default -> throw new IncompatibleClassChangeError();
            case SpawnType.RESIDENT -> new ResidentSpawnEvent(player, player.getLocation(), spawnLoc, spawnInfo.eventCancelled, spawnInfo.eventCancellationMessage);
            case SpawnType.TOWN -> new TownSpawnEvent(player, player.getLocation(), spawnLoc, spawnInfo.eventCancelled, spawnInfo.eventCancellationMessage);
            case SpawnType.NATION -> new NationSpawnEvent(player, player.getLocation(), spawnLoc, spawnInfo.eventCancelled, spawnInfo.eventCancellationMessage);
        };
    }

    private static void initiateSpawn(Player player, Location spawnLoc, int cooldown, double cost, @Nullable Account refundAccount) {
        Resident resident = TownyAPI.getInstance().getResident(player);
        if (resident == null) {
            return;
        }
        if (TownyTimerHandler.isTeleportWarmupRunning() && !SpawnUtil.hasPerm(player, PermissionNodes.TOWNY_SPAWN_ADMIN_NOWARMUP)) {
            TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_town_spawn_warmup", TownySettings.getTeleportWarmupTime()));
            TeleportWarmupTimerTask.requestTeleport(resident, spawnLoc, cooldown, refundAccount, cost);
        } else {
            if (player.getVehicle() != null) {
                player.getVehicle().eject();
            }
            SpawnUtil.addAndRemoveChunkTicket(WorldCoord.parseWorldCoord(player.getLocation()));
            Location prior = player.getLocation();
            player.teleportAsync(spawnLoc, PlayerTeleportEvent.TeleportCause.COMMAND).thenAccept(successfulTeleport -> {
                if (successfulTeleport.booleanValue()) {
                    BukkitTools.fireEvent(new SuccessfulTownyTeleportEvent(resident, spawnLoc, cost, prior));
                }
            });
            if (cooldown > 0 && !SpawnUtil.hasPerm(player, PermissionNodes.TOWNY_SPAWN_ADMIN_NOCOOLDOWN)) {
                CooldownTimerTask.addCooldownTimer(player.getName(), "teleport", cooldown);
            }
        }
    }

    private static void initiateCostedSpawn(Player player, Resident resident, Location spawnLoc, double travelCost, Account payee, String paymentMsg, boolean ignoreWarn, int cooldown) {
        if (ignoreWarn || !TownySettings.isSpawnWarnConfirmationUsed()) {
            SpawnUtil.payAndThenSpawn(player, resident, spawnLoc, travelCost, payee, paymentMsg, cooldown);
        } else {
            Confirmation.runOnAccept(() -> SpawnUtil.payAndThenSpawn(player, resident, spawnLoc, travelCost, payee, paymentMsg, cooldown)).setTitle(Translatable.of("msg_spawn_warn", TownyEconomyHandler.getFormattedBalance(travelCost))).sendTo((CommandSender)player);
        }
    }

    private static void payAndThenSpawn(Player player, Resident resident, Location spawnLoc, double travelCost, Account payee, String paymentMsg, int cooldown) {
        if (resident.getAccount().payTo(travelCost, payee, paymentMsg)) {
            TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_cost_spawn", TownyEconomyHandler.getFormattedBalance(travelCost)));
            SpawnUtil.initiateSpawn(player, spawnLoc, cooldown, travelCost, payee);
        }
    }

    private static CompletableFuture<Location> getIdealLocation(Resident resident) {
        Town town = resident.getTownOrNull();
        Location loc = resident.getPlayer().getWorld().getSpawnLocation();
        if (town != null && town.hasSpawn()) {
            loc = town.getSpawnOrNull();
        }
        Location finalLoc = loc;
        return BukkitTools.getRespawnLocation(resident.getPlayer()).thenApply(bed -> bed == null ? finalLoc : bed);
    }

    private static void initiatePluginTeleport(Resident resident, Location loc, boolean ignoreWarmup) {
        Player player = resident.getPlayer();
        if (player == null) {
            return;
        }
        plugin.getScheduler().runLater((Entity)player, () -> resident.getPlayer().teleportAsync(loc, PlayerTeleportEvent.TeleportCause.PLUGIN), ignoreWarmup ? 0L : (long)TownySettings.getTeleportWarmupTime() * 20L);
    }

    private static void initiatePluginTeleport(Resident resident, CompletableFuture<Location> loc, boolean ignoreWarmup) {
        loc.thenAccept(location -> SpawnUtil.initiatePluginTeleport(resident, location, ignoreWarmup));
    }

    private static boolean hasPerm(Player player, PermissionNodes node) {
        return TownyUniverse.getInstance().getPermissionSource().testPermission((Permissible)player, node.getNode());
    }

    public static void addAndRemoveChunkTicket(WorldCoord wc) {
        wc.loadChunks();
        Towny.getPlugin().getScheduler().runAsyncLater(() -> wc.unloadChunks(), 20L);
    }
}

