/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.utils;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyFormatter;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.confirmations.Confirmation;
import com.palmergames.bukkit.towny.confirmations.ConfirmationTransaction;
import com.palmergames.bukkit.towny.event.DeleteTownEvent;
import com.palmergames.bukkit.towny.event.plot.group.PlotGroupDeletedEvent;
import com.palmergames.bukkit.towny.event.town.TownPreReclaimEvent;
import com.palmergames.bukkit.towny.event.town.TownReclaimedEvent;
import com.palmergames.bukkit.towny.event.town.TownRuinedEvent;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.PlotGroup;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.Translator;
import com.palmergames.bukkit.towny.object.statusscreens.StatusScreen;
import com.palmergames.bukkit.towny.utils.ResidentUtil;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.util.StringMgmt;
import com.palmergames.util.TimeTools;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class TownRuinUtil {
    private TownRuinUtil() {
    }

    public static boolean isPlayersTownRuined(@NotNull Player player) {
        Town town = TownyAPI.getInstance().getTown(player);
        return town != null && town.isRuined();
    }

    public static void putTownIntoRuinedState(Town town) {
        if (town.isRuined()) {
            return;
        }
        Nation nation = town.getNationOrNull();
        if (nation != null) {
            double bankBalance;
            if (TownyEconomyHandler.isActive() && TownySettings.areRuinedTownsBanksPaidToNation() && (bankBalance = town.getAccount().getHoldingBalance()) > 0.0) {
                town.getAccount().payTo(bankBalance, nation, String.format("Ruined Town (%s) Paid Remaining Bank To Nation", town.getName()));
            }
            town.removeNation();
        }
        String oldMayorName = town.hasMayor() ? town.getMayor().getName() : "none";
        Resident resident = ResidentUtil.createAndGetNPCResident();
        try {
            resident.setTown(town);
        }
        catch (AlreadyRegisteredException alreadyRegisteredException) {
            // empty catch block
        }
        resident.save();
        TownRuinUtil.setMayor(town, resident);
        town.setHasUpkeep(false);
        BukkitTools.fireEvent(new TownRuinedEvent(town, oldMayorName));
        town.setRuined(true);
        town.setRuinedTime(System.currentTimeMillis());
        town.setPublic(TownySettings.areRuinsMadePublic());
        town.setOpen(TownySettings.areRuinsMadeOpen());
        town.getPermissions().setAll(true);
        for (TownBlock townBlock : town.getTownBlocks()) {
            if (townBlock.hasResident()) {
                townBlock.removeResident();
            }
            townBlock.setType(TownBlockType.RESIDENTIAL);
            townBlock.setPlotPrice(-1.0);
            townBlock.removePlotObjectGroup();
            townBlock.getPermissionOverrides().clear();
            townBlock.getTrustedResidents().clear();
            townBlock.save();
        }
        if (town.getPlotGroups() != null) {
            for (PlotGroup group : new ArrayList<PlotGroup>(town.getPlotGroups())) {
                if (BukkitTools.isEventCancelled(new PlotGroupDeletedEvent(group, null, PlotGroupDeletedEvent.Cause.TOWN_DELETED))) continue;
                TownyUniverse.getInstance().getDataSource().removePlotGroup(group);
            }
        }
        if (TownySettings.getMaxResidentsPerTown() > 0) {
            ResidentUtil.reduceResidentCountToFitTownMaxPop(town);
        }
        town.setForSale(false);
        town.save();
        Towny.getPlugin().resetCache();
        TownyMessaging.sendGlobalMessage(Translatable.of("msg_ruin_town", town.getName()));
    }

    public static void processRuinedTownReclaimRequest(Player player) {
        try {
            Town town;
            Resident resident = TownyUniverse.getInstance().getResident(player.getUniqueId());
            Town town2 = town = resident != null ? resident.getTownOrNull() : null;
            if (town == null) {
                throw new TownyException(Translatable.of("msg_err_dont_belong_town"));
            }
            if (!town.isRuined()) {
                throw new TownyException(Translatable.of("msg_err_cannot_reclaim_town_unless_ruined"));
            }
            double townReclaimCost = TownySettings.getEcoPriceReclaimTown();
            if (TownySettings.getTownRuinsMinDurationHours() - TownRuinUtil.getTimeSinceRuining(town) > 0) {
                throw new TownyException(Translatable.of("msg_err_cannot_reclaim_town_yet", TownySettings.getTownRuinsMinDurationHours() - TownRuinUtil.getTimeSinceRuining(town)));
            }
            Confirmation.runOnAccept(() -> TownRuinUtil.reclaimTown(resident, town)).setCost(new ConfirmationTransaction(() -> townReclaimCost, resident, "Cost of town reclaim.", Translatable.of("msg_insuf_funds"))).setTitle(Translatable.of("msg_confirm_purchase", TownyEconomyHandler.getFormattedBalance(townReclaimCost))).setCancellableEvent(new TownPreReclaimEvent(town, resident, player)).sendTo((CommandSender)player);
        }
        catch (TownyException e) {
            TownyMessaging.sendErrorMsg(player, e.getMessage((CommandSender)player));
        }
    }

    public static void reclaimTown(@NotNull Resident resident, @NotNull Town town) {
        if (!town.isRuined()) {
            if (resident.isOnline()) {
                TownyMessaging.sendErrorMsg((CommandSender)resident.getPlayer(), Translatable.of("msg_err_cannot_reclaim_town_unless_ruined"));
            }
            return;
        }
        town.setRuined(false);
        town.setRuinedTime(0L);
        if (!resident.equals(town.getMayor())) {
            TownRuinUtil.setMayor(town, resident);
        }
        town.getPermissions().loadDefault(town);
        for (TownBlock townBlock : town.getTownBlocks()) {
            townBlock.getPermissions().loadDefault(town);
            townBlock.setChanged(false);
            townBlock.save();
        }
        town.save();
        Towny.getPlugin().resetCache();
        BukkitTools.fireEvent(new TownReclaimedEvent(town, resident));
        TownyMessaging.sendGlobalMessage(Translatable.of("msg_town_reclaimed", resident.getName(), town.getName()));
    }

    private static void setMayor(Town town, Resident newMayor) {
        Resident oldMayor = town.getMayor();
        town.setMayor(newMayor);
        if (oldMayor != null && oldMayor.isNPC()) {
            oldMayor.removeTown();
            TownyUniverse.getInstance().getDataSource().removeResident(oldMayor);
            town.setHasUpkeep(true);
        }
        TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_new_mayor", newMayor.getName()));
    }

    public static void evaluateRuinedTownRemovals() {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        ArrayList ruinedTowns = new ArrayList(townyUniverse.getTowns().stream().filter(Town::isRuined).collect(Collectors.toList()));
        ListIterator townItr = ruinedTowns.listIterator();
        while (townItr.hasNext()) {
            Town town = (Town)townItr.next();
            if (!town.exists()) continue;
            if (TownRuinUtil.hasRuinTimeExpired(town) && townyUniverse.getDataSource().removeTown(town, DeleteTownEvent.Cause.RUINED)) {
                TownyMessaging.sendMsg(Translatable.of("msg_ruined_town_being_deleted", town.getName(), TownySettings.getTownRuinsMaxDurationHours()));
                continue;
            }
            if (!TownySettings.doRuinsPlotPermissionsProgressivelyAllowAll()) continue;
            Town finalTown = town;
            Towny.getPlugin().getScheduler().runAsync(() -> TownRuinUtil.allowPermissionsOnRuinedTownBlocks(finalTown));
        }
    }

    private static boolean hasRuinTimeExpired(Town town) {
        return town.getRuinedTime() != 0L && TownRuinUtil.getTimeSinceRuining(town) > TownySettings.getTownRuinsMaxDurationHours();
    }

    public static int getTimeSinceRuining(Town town) {
        return TimeTools.getHours(System.currentTimeMillis() - town.getRuinedTime());
    }

    public static void addRuinedComponents(Town town, StatusScreen screen, Translator translator) {
        screen.addComponentOf("ruinedTime", TownyFormatter.colourKey(translator.of("msg_time_remaining_before_full_removal", TownySettings.getTownRuinsMaxDurationHours() - TownRuinUtil.getTimeSinceRuining(town))));
        if (TownySettings.getTownRuinsReclaimEnabled()) {
            if (TownRuinUtil.getTimeSinceRuining(town) < TownySettings.getTownRuinsMinDurationHours()) {
                screen.addComponentOf("reclaim", TownyFormatter.colourKeyImportant(translator.of("msg_time_until_reclaim_available", TownySettings.getTownRuinsMinDurationHours() - TownRuinUtil.getTimeSinceRuining(town))));
            } else {
                screen.addComponentOf("reclaim", TownyFormatter.colourKeyImportant(translator.of("msg_reclaim_available")));
            }
        }
    }

    private static void allowPermissionsOnRuinedTownBlocks(Town town) {
        long unprotectedBlockCount = TownRuinUtil.getNumTownblocksWithNoProtection(town);
        if (unprotectedBlockCount <= 0L) {
            return;
        }
        TownyPermission openPerms = new TownyPermission();
        openPerms.setAllNonEnvironmental(true);
        List alteredBlocks = town.getTownBlocks().stream().sorted(Comparator.comparingLong(TownBlock::getClaimedAt).reversed()).limit(unprotectedBlockCount).filter(tb -> TownRuinUtil.tryAndAllowPermsInPlot(tb, openPerms)).collect(Collectors.toList());
        if (alteredBlocks.size() > 0) {
            TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_ruined_town_plot_permissions_allowed_on_x_plots", alteredBlocks.size()));
            TownyMessaging.sendMsg(Translatable.of("console_msg_ruined_town_plot_permissions_allowed_on_x_plots", town.getName(), alteredBlocks.size(), StringMgmt.join(alteredBlocks, ", ")));
        }
    }

    private static long getNumTownblocksWithNoProtection(Town town) {
        int timeSinceRuining;
        int hoursTotal = TownySettings.getTownRuinsMaxDurationHours();
        int hoursLeft = hoursTotal - (timeSinceRuining = TownRuinUtil.getTimeSinceRuining(town));
        if (hoursLeft >= hoursTotal) {
            return 0L;
        }
        if (hoursLeft == 0) {
            return town.getNumTownBlocks();
        }
        int numTownBlocks = town.getNumTownBlocks();
        if (numTownBlocks == 0) {
            return 0L;
        }
        int townBlocksPerHour = numTownBlocks / hoursLeft;
        double end = numTownBlocks > hoursTotal ? (double)(townBlocksPerHour * timeSinceRuining) : (double)numTownBlocks * ((double)timeSinceRuining / (double)hoursTotal);
        return (long)end;
    }

    private static boolean tryAndAllowPermsInPlot(TownBlock tb, TownyPermission openPerms) {
        if (tb == null || tb.getPermissions().equalsNonEnvironmental(openPerms)) {
            return false;
        }
        Towny.getPlugin().getScheduler().runAsync(() -> {
            tb.getPermissions().setAllNonEnvironmental(true);
            tb.save();
        });
        return true;
    }
}

