/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.utils;

import com.palmergames.bukkit.util.Colors;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.minimessage.tag.standard.StandardTags;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class TownyComponents {
    private static final MiniMessage EMPTY = MiniMessage.builder().tags(TagResolver.empty()).build();

    public static Component miniMessage(@NotNull String string) {
        return MiniMessage.miniMessage().deserialize((Object)Colors.translateLegacyCharacters(Colors.translateLegacyHex(string)));
    }

    public static String toMiniMessage(@NotNull Component component) {
        return (String)MiniMessage.miniMessage().serialize(component);
    }

    public static String plain(@NotNull Component component) {
        return PlainTextComponentSerializer.plainText().serialize(component);
    }

    public static Component legacy(@NotNull String string) {
        return LegacyComponentSerializer.legacySection().deserialize(Colors.translateColorCodes(string));
    }

    public static String toLegacy(@NotNull Component component) {
        return LegacyComponentSerializer.legacySection().serialize(component);
    }

    public static String stripTags(@NotNull String input) {
        return MiniMessage.miniMessage().stripTags(input);
    }

    public static String stripTags(@NotNull String input, TagResolver ... resolvers) {
        return EMPTY.stripTags(input, resolvers);
    }

    public static String stripClickTags(@NotNull String input) {
        return TownyComponents.stripTags(input, StandardTags.clickEvent());
    }

    public static Component joinList(List<Component> components, Component delimiter) {
        TextComponent full = Component.empty();
        for (int i = 0; i < components.size(); ++i) {
            full = ((TextComponent)Component.empty().append((Component)full)).append(components.get(i));
            if (i == components.size() - 1) continue;
            full = ((TextComponent)Component.empty().append((Component)full)).append(delimiter);
        }
        return full;
    }
}

